/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javap;

import com.sun.tools.classfile.Attribute;
import com.sun.tools.classfile.ClassFile;
import com.sun.tools.classfile.Code_attribute;
import com.sun.tools.classfile.ConstantPoolException;
import com.sun.tools.classfile.Instruction;
import com.sun.tools.classfile.LineNumberTable_attribute;
import com.sun.tools.classfile.SourceFile_attribute;
import com.sun.tools.javap.Context;
import com.sun.tools.javap.InstructionDetailWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class SourceWriter
extends InstructionDetailWriter {
    private JavaFileManager fileManager;
    private ClassFile classFile;
    private SortedMap<Integer, SortedSet<Integer>> lineMap;
    private List<Integer> lineList;
    private String[] sourceLines;

    static SourceWriter instance(Context context) {
        SourceWriter instance = context.get(SourceWriter.class);
        if (instance == null) {
            instance = new SourceWriter(context);
        }
        return instance;
    }

    protected SourceWriter(Context context) {
        super(context);
        context.put(SourceWriter.class, this);
    }

    void setFileManager(JavaFileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void reset(ClassFile cf, Code_attribute attr) {
        this.setSource(cf);
        this.setLineMap(attr);
    }

    @Override
    public void writeDetails(Instruction instr) {
        String indent = this.space(40);
        Set lines = (Set)this.lineMap.get(instr.getPC());
        if (lines != null) {
            Iterator iterator = lines.iterator();
            while (iterator.hasNext()) {
                int line = (Integer)iterator.next();
                this.print(indent);
                this.print(String.format(" %4d ", line));
                if (line < this.sourceLines.length) {
                    this.print(this.sourceLines[line]);
                }
                this.println();
                int nextLine = this.nextLine(line);
                for (int i = line + 1; i < nextLine; ++i) {
                    this.print(indent);
                    this.print(String.format("(%4d)", i));
                    if (i < this.sourceLines.length) {
                        this.print(this.sourceLines[i]);
                    }
                    this.println();
                }
            }
        }
    }

    public boolean hasSource() {
        return this.sourceLines.length > 0;
    }

    private void setLineMap(Code_attribute attr) {
        TreeMap<Integer, SortedSet<Integer>> map = new TreeMap<Integer, SortedSet<Integer>>();
        TreeSet<Integer> allLines = new TreeSet<Integer>();
        for (Attribute a : attr.attributes) {
            if (!(a instanceof LineNumberTable_attribute)) continue;
            LineNumberTable_attribute t = (LineNumberTable_attribute)a;
            for (LineNumberTable_attribute.Entry e : t.line_number_table) {
                int start_pc = e.start_pc;
                int line = e.line_number;
                TreeSet<Integer> pcLines = (TreeSet<Integer>)map.get(start_pc);
                if (pcLines == null) {
                    pcLines = new TreeSet<Integer>();
                    map.put(start_pc, pcLines);
                }
                pcLines.add(line);
                allLines.add(line);
            }
        }
        this.lineMap = map;
        this.lineList = new ArrayList<Integer>(allLines);
    }

    private void setSource(ClassFile cf) {
        if (cf != this.classFile) {
            this.classFile = cf;
            this.sourceLines = SourceWriter.splitLines(this.readSource(cf));
        }
    }

    private String readSource(ClassFile cf) {
        if (this.fileManager == null) {
            return null;
        }
        StandardLocation location = this.fileManager.hasLocation(StandardLocation.SOURCE_PATH) ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH;
        try {
            String className = cf.getName();
            SourceFile_attribute sf = (SourceFile_attribute)cf.attributes.get("SourceFile");
            if (sf == null) {
                this.report(this.messages.getMessage("err.no.SourceFile.attribute", new Object[0]));
                return null;
            }
            String sourceFile = sf.getSourceFile(cf.constant_pool);
            String fileBase = sourceFile.endsWith(".java") ? sourceFile.substring(0, sourceFile.length() - 5) : sourceFile;
            int sep = className.lastIndexOf("/");
            String pkgName = sep == -1 ? "" : className.substring(0, sep + 1);
            String topClassName = (pkgName + fileBase).replace('/', '.');
            JavaFileObject fo = this.fileManager.getJavaFileForInput(location, topClassName, JavaFileObject.Kind.SOURCE);
            if (fo == null) {
                this.report(this.messages.getMessage("err.source.file.not.found", new Object[0]));
                return null;
            }
            return fo.getCharContent(true).toString();
        }
        catch (ConstantPoolException e) {
            this.report(e);
            return null;
        }
        catch (IOException e) {
            this.report(e.getLocalizedMessage());
            return null;
        }
    }

    private static String[] splitLines(String text) {
        if (text == null) {
            return new String[0];
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("");
        try {
            String line;
            BufferedReader r = new BufferedReader(new StringReader(text));
            while ((line = r.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lines.toArray(new String[lines.size()]);
    }

    private int nextLine(int line) {
        int i = this.lineList.indexOf(line);
        if (i == -1 || i == this.lineList.size() - 1) {
            return -1;
        }
        return this.lineList.get(i + 1);
    }
}

