/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javadoc;

import com.sun.javadoc.AnnotationDesc;
import com.sun.javadoc.AnnotationTypeDoc;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javadoc.AnnotationDescImpl;
import com.sun.tools.javadoc.AnnotationTypeDocImpl;
import com.sun.tools.javadoc.ClassDocImpl;
import com.sun.tools.javadoc.DocEnv;
import com.sun.tools.javadoc.DocImpl;
import com.sun.tools.javadoc.SourcePositionImpl;
import java.io.IOException;
import java.io.InputStream;
import javax.tools.FileObject;

public class PackageDocImpl
extends DocImpl
implements PackageDoc {
    protected Symbol.PackageSymbol sym;
    private JCTree.JCCompilationUnit tree = null;
    public FileObject docPath = null;
    private boolean foundDoc;
    boolean isIncluded = false;
    public boolean setDocPath = false;
    private List<ClassDocImpl> allClassesFiltered = null;
    private List<ClassDocImpl> allClasses = null;
    private String qualifiedName;
    private boolean checkDocWarningEmitted = false;

    public PackageDocImpl(DocEnv env, Symbol.PackageSymbol sym) {
        this(env, sym, null);
    }

    public PackageDocImpl(DocEnv env, Symbol.PackageSymbol sym, TreePath treePath) {
        super(env, treePath);
        this.sym = sym;
        this.tree = treePath == null ? null : (JCTree.JCCompilationUnit)treePath.getCompilationUnit();
        this.foundDoc = this.documentation != null;
    }

    void setTree(JCTree tree) {
        this.tree = (JCTree.JCCompilationUnit)tree;
    }

    @Override
    public void setTreePath(TreePath treePath) {
        super.setTreePath(treePath);
        this.checkDoc();
    }

    @Override
    protected String documentation() {
        if (this.documentation != null) {
            return this.documentation;
        }
        if (this.docPath != null) {
            try {
                InputStream s = this.docPath.openInputStream();
                this.documentation = this.readHTMLDocumentation(s, this.docPath);
            }
            catch (IOException exc) {
                this.documentation = "";
                this.env.error(null, "javadoc.File_Read_Error", this.docPath.getName());
            }
        } else {
            this.documentation = "";
        }
        return this.documentation;
    }

    private List<ClassDocImpl> getClasses(boolean filtered) {
        if (this.allClasses != null && !filtered) {
            return this.allClasses;
        }
        if (this.allClassesFiltered != null && filtered) {
            return this.allClassesFiltered;
        }
        ListBuffer<ClassDocImpl> classes = new ListBuffer<ClassDocImpl>();
        for (Symbol enumerated : this.sym.members().getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
            Symbol.ClassSymbol s;
            ClassDocImpl c;
            if (enumerated == null || (c = this.env.getClassDoc(s = (Symbol.ClassSymbol)enumerated)) == null || c.isSynthetic()) continue;
            c.addAllClasses(classes, filtered);
        }
        if (filtered) {
            this.allClassesFiltered = classes.toList();
            return this.allClassesFiltered;
        }
        this.allClasses = classes.toList();
        return this.allClasses;
    }

    public void addAllClassesTo(ListBuffer<ClassDocImpl> list) {
        list.appendList(this.getClasses(true));
    }

    public ClassDoc[] allClasses(boolean filter) {
        List<ClassDocImpl> classes = this.getClasses(filter);
        return classes.toArray(new ClassDocImpl[classes.length()]);
    }

    public ClassDoc[] allClasses() {
        return this.allClasses(true);
    }

    public ClassDoc[] ordinaryClasses() {
        ListBuffer<ClassDocImpl> ret = new ListBuffer<ClassDocImpl>();
        for (ClassDocImpl c : this.getClasses(true)) {
            if (!c.isOrdinaryClass()) continue;
            ret.append(c);
        }
        return ret.toArray(new ClassDocImpl[ret.length()]);
    }

    public ClassDoc[] exceptions() {
        ListBuffer<ClassDocImpl> ret = new ListBuffer<ClassDocImpl>();
        for (ClassDocImpl c : this.getClasses(true)) {
            if (!c.isException()) continue;
            ret.append(c);
        }
        return ret.toArray(new ClassDocImpl[ret.length()]);
    }

    public ClassDoc[] errors() {
        ListBuffer<ClassDocImpl> ret = new ListBuffer<ClassDocImpl>();
        for (ClassDocImpl c : this.getClasses(true)) {
            if (!c.isError()) continue;
            ret.append(c);
        }
        return ret.toArray(new ClassDocImpl[ret.length()]);
    }

    public ClassDoc[] enums() {
        ListBuffer<ClassDocImpl> ret = new ListBuffer<ClassDocImpl>();
        for (ClassDocImpl c : this.getClasses(true)) {
            if (!c.isEnum()) continue;
            ret.append(c);
        }
        return ret.toArray(new ClassDocImpl[ret.length()]);
    }

    public ClassDoc[] interfaces() {
        ListBuffer<ClassDocImpl> ret = new ListBuffer<ClassDocImpl>();
        for (ClassDocImpl c : this.getClasses(true)) {
            if (!c.isInterface()) continue;
            ret.append(c);
        }
        return ret.toArray(new ClassDocImpl[ret.length()]);
    }

    public AnnotationTypeDoc[] annotationTypes() {
        ListBuffer<AnnotationTypeDocImpl> ret = new ListBuffer<AnnotationTypeDocImpl>();
        for (ClassDocImpl c : this.getClasses(true)) {
            if (!c.isAnnotationType()) continue;
            ret.append((AnnotationTypeDocImpl)c);
        }
        return ret.toArray(new AnnotationTypeDocImpl[ret.length()]);
    }

    public AnnotationDesc[] annotations() {
        AnnotationDesc[] res = new AnnotationDesc[this.sym.getRawAttributes().length()];
        int i = 0;
        for (Attribute.Compound a : this.sym.getRawAttributes()) {
            res[i++] = new AnnotationDescImpl(this.env, a);
        }
        return res;
    }

    public ClassDoc findClass(String className) {
        boolean filtered = true;
        for (ClassDocImpl c : this.getClasses(true)) {
            if (!c.name().equals(className)) continue;
            return c;
        }
        return null;
    }

    @Override
    public boolean isIncluded() {
        return this.isIncluded;
    }

    @Override
    public String name() {
        return this.qualifiedName();
    }

    @Override
    public String qualifiedName() {
        if (this.qualifiedName == null) {
            Name fullname = this.sym.getQualifiedName();
            this.qualifiedName = fullname.isEmpty() ? "" : fullname.toString();
        }
        return this.qualifiedName;
    }

    public void setDocPath(FileObject path) {
        this.setDocPath = true;
        if (path == null) {
            return;
        }
        if (!path.equals(this.docPath)) {
            this.docPath = path;
            this.checkDoc();
        }
    }

    private void checkDoc() {
        if (this.foundDoc) {
            if (!this.checkDocWarningEmitted) {
                this.env.warning(null, "javadoc.Multiple_package_comments", this.name());
                this.checkDocWarningEmitted = true;
            }
        } else {
            this.foundDoc = true;
        }
    }

    @Override
    public SourcePosition position() {
        return this.tree != null ? SourcePositionImpl.make(this.tree.sourcefile, this.tree.pos, this.tree.lineMap) : SourcePositionImpl.make(this.docPath, -1, null);
    }
}

