/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import java.io.IOException;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.dd.api.common.VersionNotSupportedException;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class HintsUtils {
    private static final Logger LOG = Logger.getLogger(HintsUtils.class.getName());
    private static final String CACHED_CONTEXT = "cached-ejbProblemContext-";

    public static ErrorDescription createProblem(Element subject, CompilationInfo cinfo, String description) {
        return HintsUtils.createProblem(subject, cinfo, description, Severity.ERROR, Collections.emptyList());
    }

    public static ErrorDescription createProblem(Element subject, CompilationInfo cinfo, String description, Severity severity) {
        return HintsUtils.createProblem(subject, cinfo, description, severity, Collections.emptyList());
    }

    public static ErrorDescription createProblem(Element subject, CompilationInfo cinfo, String description, Severity severity, Fix fix) {
        return HintsUtils.createProblem(subject, cinfo, description, severity, Collections.singletonList(fix));
    }

    public static ErrorDescription createProblem(Element subject, CompilationInfo cinfo, String description, Fix fix) {
        return HintsUtils.createProblem(subject, cinfo, description, Severity.ERROR, Collections.singletonList(fix));
    }

    public static ErrorDescription createProblem(Element subject, CompilationInfo cinfo, String description, Severity severity, List<Fix> fixes) {
        ErrorDescription err = null;
        List<Object> fixList = fixes == null ? Collections.emptyList() : fixes;
        Tree elementTree = cinfo.getTrees().getTree(subject);
        if (elementTree != null) {
            TextSpan underlineSpan = HintsUtils.getUnderlineSpan(cinfo, elementTree);
            err = ErrorDescriptionFactory.createErrorDescription((Severity)severity, (String)description, fixList, (FileObject)cinfo.getFileObject(), (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset());
        }
        return err;
    }

    public static boolean isEjb30Plus(String ejbVersion) {
        return "3.0".equals(ejbVersion) || "3.1".equals(ejbVersion) || "3.2".equals(ejbVersion);
    }

    public static TextSpan getUnderlineSpan(CompilationInfo info, Tree tree) {
        SourcePositions srcPos = info.getTrees().getSourcePositions();
        int startOffset = (int)srcPos.getStartPosition(info.getCompilationUnit(), tree);
        int endOffset = (int)srcPos.getEndPosition(info.getCompilationUnit(), tree);
        Tree startSearchingForNameIndentifierBehindThisTree = null;
        if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind())) {
            startSearchingForNameIndentifierBehindThisTree = ((ClassTree)tree).getModifiers();
        } else if (tree.getKind() == Tree.Kind.METHOD) {
            startSearchingForNameIndentifierBehindThisTree = ((MethodTree)tree).getReturnType();
        } else if (tree.getKind() == Tree.Kind.VARIABLE) {
            startSearchingForNameIndentifierBehindThisTree = ((VariableTree)tree).getType();
        }
        if (startSearchingForNameIndentifierBehindThisTree != null) {
            int searchStart = (int)srcPos.getEndPosition(info.getCompilationUnit(), startSearchingForNameIndentifierBehindThisTree);
            TokenSequence tokenSequence = info.getTreeUtilities().tokensFor(tree);
            if (tokenSequence != null) {
                boolean eob = false;
                tokenSequence.move(searchStart);
                do {
                    boolean bl = eob = !tokenSequence.moveNext();
                } while (!eob && tokenSequence.token().id() != JavaTokenId.IDENTIFIER);
                if (!eob) {
                    Token identifier = tokenSequence.token();
                    startOffset = identifier.offset(info.getTokenHierarchy());
                    endOffset = startOffset + identifier.length();
                }
            }
        }
        return new TextSpan(startOffset, endOffset);
    }

    public static boolean isContainingKnownClasses(ExecutableElement method) {
        if (method.getReturnType().getKind() == TypeKind.ERROR) {
            return false;
        }
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            if (typeMirror.getKind() != TypeKind.ERROR) continue;
            return false;
        }
        for (VariableElement variableElement : method.getParameters()) {
            if (variableElement.asType().getKind() != TypeKind.ERROR) continue;
            return false;
        }
        return true;
    }

    public static EJBProblemContext getOrCacheContext(HintContext context) {
        Element element = context.getInfo().getTrees().getElement(context.getPath());
        String elementType = element.asType().toString();
        return HintsUtils.getOrCacheContext(context, elementType);
    }

    public static EJBProblemContext getOrCacheContext(HintContext context, String elementType) {
        Object cached = context.getInfo().getCachedValue((Object)(CACHED_CONTEXT + elementType));
        if (cached == null) {
            LOG.log(Level.FINEST, "HintContext doesn''t contain cached EJBProblemContext which is going to be created for type: {0}", elementType);
            EJBProblemContext newContext = HintsUtils.createEJBProblemContext(context);
            context.getInfo().putCachedValue((Object)(CACHED_CONTEXT + elementType), (Object)newContext, CompilationInfo.CacheClearPolicy.ON_SIGNATURE_CHANGE);
            return newContext;
        }
        LOG.log(Level.FINEST, "EJBProblemContext cached value used.");
        return (EJBProblemContext)cached;
    }

    private static EJBProblemContext createEJBProblemContext(final HintContext context) {
        final CompilationInfo info = context.getInfo();
        final FileObject file = info.getFileObject();
        final Project project = FileOwnerQuery.getOwner((FileObject)file);
        if (project == null) {
            return null;
        }
        J2eeProjectCapabilities projCap = J2eeProjectCapabilities.forProject((Project)project);
        if (projCap == null || !projCap.isEjb30Supported() && !projCap.isEjb31LiteSupported()) {
            return null;
        }
        final EjbJar ejbModule = EjbJar.getEjbJar((FileObject)file);
        if (ejbModule == null) {
            return null;
        }
        try {
            return (EJBProblemContext)ejbModule.getMetadataModel().runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, EJBProblemContext>(){

                public EJBProblemContext run(EjbJarMetadata metadata) {
                    long startTime = Calendar.getInstance().getTimeInMillis();
                    String ejbVersion = metadata.getRoot().getVersion().toString();
                    if (!HintsUtils.isEjb30Plus(ejbVersion)) {
                        return null;
                    }
                    Element element = info.getTrees().getElement(context.getPath());
                    if (element instanceof TypeElement) {
                        TypeElement javaClass = (TypeElement)element;
                        Ejb ejb = metadata.findByEjbClass(javaClass.getQualifiedName().toString());
                        String[] businessLocal = new String[]{};
                        String[] businessRemote = new String[]{};
                        String sessionType = "";
                        try {
                            if (ejb instanceof Session) {
                                Session session = (Session)ejb;
                                businessLocal = session.getBusinessLocal();
                                businessRemote = session.getBusinessRemote();
                                sessionType = session.getSessionType();
                            }
                        }
                        catch (VersionNotSupportedException ex) {
                            LOG.log(Level.INFO, ex.getMessage(), ex);
                        }
                        if (LOG.isLoggable(Level.FINE)) {
                            long timeElapsed = Calendar.getInstance().getTimeInMillis() - startTime;
                            LOG.log(Level.FINE, "processed class {0} in {1} ms", new Object[]{javaClass.getSimpleName(), timeElapsed});
                        }
                        return new EJBProblemContext(project, ejbModule, file, javaClass, ejb, new EJBProblemContext.SessionData(businessLocal, businessRemote, sessionType));
                    }
                    return null;
                }
            });
        }
        catch (MetadataModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public static class TextSpan {
        private int startOffset;
        private int endOffset;

        public TextSpan(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

