/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Iterator;
import org.clank.java.std;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.ushort;

public abstract class SmallVectorImplUShort
implements Native.assignable<SmallVectorImplUShort>,
Native.NativeComparable<SmallVectorImplUShort>,
Native.ComparableLower,
NativeType.SizeofCapable,
Iterable<Character>,
Native.NativeIterable<iterator> {
    protected final char defaultValue;
    private char[] array;
    private static final char[] EMPTY = NativePointer.new$ushort((int)0);
    private int end;

    public final char[] $array() {
        return this.array;
    }

    protected SmallVectorImplUShort(int capacity, char defaultValue) {
        this.array = capacity == 0 ? EMPTY : NativePointer.new$ushort((int)capacity);
        this.end = 0;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplUShort(int capacity, int initialSize, char defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, defaultValue);
    }

    protected SmallVectorImplUShort(int capacity, int initialSize, char value, char defaultValue) {
        this(capacity, defaultValue);
        this.assign(initialSize, value);
    }

    protected SmallVectorImplUShort(char[] array2, char defaultValue) {
        this.array = array2;
        this.end = array2 == null ? 0 : array2.length;
        this.defaultValue = defaultValue;
    }

    protected SmallVectorImplUShort(int capacity, ushort.iterator<?> iter, int length, char defaultValue) {
        this(capacity, iter, (ushort.iterator)iter.$add(length), defaultValue);
    }

    protected SmallVectorImplUShort(int capacity, ushort.iterator<?> begin, ushort.iterator<?> end, char defaultValue) {
        this(capacity, defaultValue);
        this.append(begin, end);
    }

    protected SmallVectorImplUShort(SmallVectorImplUShort other) {
        this.defaultValue = other.defaultValue;
        this.array = (char[])other.array.clone();
        this.end = other.end;
    }

    protected SmallVectorImplUShort(JavaDifferentiators.JD.Move _dparam, SmallVectorImplUShort other) {
        this.defaultValue = other.defaultValue;
        this.array = other.array;
        this.end = other.end;
        other.array = null;
        other.end = 0;
    }

    public final SmallVectorImplUShort $assign(SmallVectorImplUShort other) {
        this.array = other.array;
        this.end = other.end;
        return this;
    }

    public final SmallVectorImplUShort $assignMove(SmallVectorImplUShort other) {
        assert (this != other) : "moving self";
        this.array = other.array;
        this.end = other.end;
        other.array = null;
        other.end = 0;
        return this;
    }

    public final void clear() {
        this.destroy_range(0, this.size());
        this.setEnd(0);
    }

    public final boolean resize(int newSize) {
        return this.resize(newSize, this.defaultValue);
    }

    public final boolean resize(int newSize, char defaultValue) {
        assert (newSize >= 0) : "can not be negative " + newSize;
        boolean grown = false;
        if (newSize < this.end) {
            this.destroy_range(newSize, this.end);
        } else if (newSize > this.end) {
            if (this.capacity() < newSize) {
                this.grow(newSize);
                grown = true;
            }
            for (int i = this.end; i < newSize; ++i) {
                this.array[i] = Native.$tryClone((char)defaultValue);
            }
        }
        this.setEnd(newSize);
        return grown;
    }

    public final void reserve(int N) {
        assert (N >= 0) : "can not be negative " + N;
        if (this.capacity() < N) {
            this.grow(N);
        }
    }

    public final void assign(int NumElts, char Elt) {
        assert (NumElts >= 0) : "can not be negative " + NumElts;
        this.clear();
        if (this.capacity() < NumElts) {
            this.grow(NumElts);
        }
        this.setEnd(NumElts);
        for (int i = 0; i < this.size(); ++i) {
            this.$set(i, Elt);
        }
    }

    public final void assign(ushort.iterator<?> __first, ushort.iterator<?> __last) {
        this.clear();
        this.append(__first, __last);
    }

    public final void swap(SmallVectorImplUShort RHS) {
        char[] arrTmp = this.array;
        this.array = RHS.array;
        RHS.array = arrTmp;
        int endTmp = this.end;
        this.end = RHS.end;
        RHS.end = endTmp;
    }

    public final int find(char elem) {
        return this.find(elem, 0);
    }

    public final int find(char elem, int from) {
        boolean isDataPointerLike = this.isDataPointerLike();
        for (int i = from; i < this.end; ++i) {
            if (!Native.$eq((char)this.array[i], (char)elem, (boolean)isDataPointerLike)) continue;
            return i;
        }
        return std.string.npos;
    }

    public final boolean contains(char elem) {
        return this.find(elem) != std.string.npos;
    }

    public final boolean erase(char elem) {
        int index = this.find(elem);
        if (index == std.string.npos) {
            return false;
        }
        this.destroy_range(index, index + 1);
        --this.end;
        if (index < this.end) {
            std.copy((char[])this.array, (int)(index + 1), (int)(this.end - index), (char[])this.array, (int)index);
        }
        this.$set(this.end, this.defaultValue);
        return true;
    }

    public final iterator erase(iterator I) {
        assert (I.$greatereq(this.begin())) : "Iterator to erase is out of bounds.";
        assert (I.$less(this.end())) : "Erasing at past-the-end iterator.";
        iterator N = I;
        std.copy((ushort.iterator)I.$add(1), (ushort.iterator)this.end(), (ushort.iterator)I);
        this.pop_back();
        return N;
    }

    public final iterator erase(iterator S, iterator E) {
        assert (S.$greatereq(this.begin())) : "Range to erase is out of bounds.";
        assert (S.$lesseq(E)) : "Trying to erase invalid range.";
        assert (E.$lesseq(this.end())) : "Trying to erase past the end.";
        iterator N = S;
        iterator I = (iterator)std.copy((ushort.iterator)E, (ushort.iterator)this.end(), (ushort.iterator)S);
        this.destroy_range(I, this.end());
        this.setEnd(I);
        return N;
    }

    public final iterator insert(iterator I, char Elt) {
        if (I.$eq(this.end())) {
            this.push_back(Elt);
            return this.end().$sub(1);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        if (this.size() >= this.capacity()) {
            int EltNo = I.$sub(this.begin());
            this.grow();
            I = this.begin().$add(EltNo);
        }
        assert (this.size() < this.capacity());
        this.setEnd(this.size() + 1);
        std.copy_backward((ushort.iterator)I, (ushort.iterator)this.end().$sub(1), (ushort.iterator)this.end());
        I.star$ref().$set(Elt);
        return I;
    }

    public final iterator insert(iterator I, int NumToInsert, char Elt) {
        assert (NumToInsert >= 0) : "can not be negative " + NumToInsert;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(NumToInsert, Elt);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((ushort.iterator)I, (ushort.iterator)OldEnd.$sub(NumToInsert), (ushort.iterator)OldEnd);
            std.fill_n((ushort.iterator)I, (int)NumToInsert, (char)Elt);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        int NumOverwritten = OldEnd.$sub(I);
        std.copy((ushort.iterator)I, (ushort.iterator)OldEnd, (ushort.iterator)this.end().$sub(NumOverwritten));
        std.fill_n((ushort.iterator)I, (int)NumOverwritten, (char)Elt);
        std.fill_n((ushort.iterator)OldEnd, (int)(NumToInsert - NumOverwritten), (char)Elt);
        return I;
    }

    public final iterator insert(iterator I, ushort.iterator<?> From, ushort.iterator<?> To) {
        int NumOverwritten;
        int InsertElt = I.$sub(this.begin());
        if (I.$eq(this.end())) {
            this.append(From, To);
            return this.begin().$add(InsertElt);
        }
        assert (I.$greatereq(this.begin())) : "Insertion iterator is out of bounds.";
        assert (I.$lesseq(this.end())) : "Inserting past the end of the vector.";
        int NumToInsert = std.distance(From, To);
        this.reserve(this.size() + NumToInsert);
        I = this.begin().$add(InsertElt);
        if (this.end().$sub(I) >= NumToInsert) {
            iterator OldEnd = this.end();
            this.append(this.end().$sub(NumToInsert), this.end());
            std.copy_backward((ushort.iterator)I, (ushort.iterator)OldEnd.$sub(NumToInsert), (ushort.iterator)OldEnd);
            std.copy(From, To, (ushort.iterator)I);
            return I;
        }
        iterator OldEnd = this.end();
        this.setEnd(this.size() + NumToInsert);
        std.copy((ushort.iterator)I, (ushort.iterator)OldEnd, (ushort.iterator)this.end().$sub(NumOverwritten));
        iterator J = I.clone();
        for (NumOverwritten = OldEnd.$sub(I); NumOverwritten > 0; --NumOverwritten) {
            J.star$ref().$set(From.$star());
            J.$preInc();
            From.$preInc();
        }
        std.copy(From, To, (ushort.iterator)OldEnd);
        return I;
    }

    public final void append(ushort.iterator<?> in_start, ushort.iterator<?> in_end) {
        int NumInputs = std.distance(in_start, in_end);
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        ushort.iterator iter = (ushort.iterator)in_start.clone();
        while (!iter.$eq(in_end)) {
            this.$set(this.end, iter.$star());
            ++this.end;
            iter.$preInc();
        }
    }

    public final void append(char[] a) {
        this.append(a, 0, a.length);
    }

    public final void append(char[] a, int fromIndex, int count) {
        if (count > this.capacity() - this.size()) {
            this.grow(this.size() + count);
        }
        while (count-- > 0) {
            char el = a[fromIndex++];
            this.$set(this.end, el);
            ++this.end;
        }
    }

    public final void append(int NumInputs, char Elt) {
        assert (NumInputs >= 0) : "can not be negative " + NumInputs;
        if (NumInputs > this.capacity() - this.size()) {
            this.grow(this.size() + NumInputs);
        }
        for (int i = 0; i < NumInputs; ++i) {
            this.$set(this.end, Elt);
            ++this.end;
        }
    }

    public final boolean $eq(SmallVectorImplUShort RHS) {
        int size = this.size();
        if (size != RHS.size()) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            if (!Native.$noteq((char)this.array[i], (char)RHS.array[i])) continue;
            return false;
        }
        return true;
    }

    public final boolean $noteq(SmallVectorImplUShort RHS) {
        return !this.$eq(RHS);
    }

    public final boolean $less(Object obj) {
        return std.lexicographical_compare((Object)this.begin(), (Object)this.end(), (Object)((SmallVectorImplUShort)obj).begin(), (Object)((SmallVectorImplUShort)obj).end());
    }

    public final boolean $lesseq(Object obj) {
        return this.$less(obj) || this.$eq((SmallVectorImplUShort)obj);
    }

    public final ushort.ref ref$at(int idx) {
        return NativePointer.create_ushort$ref((char[])this.array, (int)idx);
    }

    public final char $at(int idx) {
        return this.array[idx];
    }

    public final char $set(int idx, char value) {
        this.array[idx] = value;
        return value;
    }

    public final boolean empty() {
        return this.size() == 0;
    }

    public final void $destroy() {
    }

    public final void push_back(char val) {
        if (this.size() >= this.capacity()) {
            this.grow();
        }
        this.$set(this.size(), val);
        this.setEnd(this.size() + 1);
    }

    public final void emplace_back(char val) {
        this.push_back(val);
    }

    public final void emplace_back() {
        this.push_back(this.defaultValue);
    }

    public final void pop_back() {
        this.destroy_range(this.size() - 1, this.size());
        this.setEnd(this.size() - 1);
    }

    public final char pop_back_val() {
        char val = this.back();
        this.setEnd(this.end - 1);
        return val;
    }

    public final iterator begin() {
        return new iterator(this, 0, false);
    }

    public final iterator end() {
        return new iterator(this, this.end, false);
    }

    public final std.reverse_iteratorUShort rbegin() {
        return new std.reverse_iteratorUShort((ushort.iterator)NativePointer.create_ushort$ptr((char[])this.array, (int)this.end));
    }

    public final std.reverse_iteratorUShort rend() {
        return new std.reverse_iteratorUShort((ushort.iterator)NativePointer.create_ushort$ptr((char[])this.array));
    }

    public final ushort.ptr data() {
        return NativePointer.create_ushort$ptr((char[])this.array);
    }

    public final char front() {
        return this.array[0];
    }

    public final char back() {
        return this.array[this.end - 1];
    }

    public final ushort.ref ref$front() {
        return new ushort.ref(){
            private final char stored;
            private final int index = 0;
            {
                this.stored = SmallVectorImplUShort.this.array[0];
                this.index = 0;
            }

            public char $deref() {
                return this.stored;
            }

            public char $set(char value) {
                ((SmallVectorImplUShort)SmallVectorImplUShort.this).array[0] = value;
                return value;
            }

            public ushort.ptr deref$ptr() {
                return (ushort.ptr)SmallVectorImplUShort.this.data().$add(0);
            }
        };
    }

    public final ushort.ref ref$back() {
        return new ushort.ref(){
            private final char stored;
            private final int index;
            {
                this.stored = SmallVectorImplUShort.this.array[SmallVectorImplUShort.this.end - 1];
                this.index = SmallVectorImplUShort.this.end - 1;
            }

            public char $deref() {
                return this.stored;
            }

            public char $set(char value) {
                ((SmallVectorImplUShort)SmallVectorImplUShort.this).array[this.index] = value;
                return value;
            }

            public ushort.ptr deref$ptr() {
                return (ushort.ptr)SmallVectorImplUShort.this.data().$add(this.index);
            }
        };
    }

    public final int size() {
        return this.end;
    }

    public final int max_size() {
        return Integer.MAX_VALUE;
    }

    public final int capacity() {
        return this.array.length;
    }

    public final int $sizeof() {
        return this.capacity_in_bytes();
    }

    public final int capacity_in_bytes() {
        int oneElemSize = NativeType.sizeof((char)this.defaultValue);
        for (char elem : this.array) {
            if (elem == this.defaultValue) continue;
            oneElemSize = NativeType.sizeof((char)elem);
            break;
        }
        return this.array.length * oneElemSize;
    }

    public final ushort.ptr ptr$at(int idx) {
        return NativePointer.create_ushort$ptr((char[])this.array, (int)idx);
    }

    public final void set_size(int N) {
        assert (N >= 0) : "can not be negative " + N;
        assert (N <= this.capacity());
        this.setEnd(N);
    }

    private void destroy_range(int from, int to) {
    }

    private void destroy_range(iterator _from, iterator _to) {
        this.destroy_range(_from.$sub(this.begin()), _to.$sub(this.begin()));
    }

    private void grow(int capacity) {
        char[] oldArray = this.array;
        this.array = NativePointer.new$ushort((int)capacity);
        NativePointer.copy$Object((char[])oldArray, (int)0, (char[])this.array, (int)0, (int)oldArray.length);
    }

    private void grow() {
        int capacity = this.capacity();
        this.grow(capacity == 0 ? 1 : (capacity < 1024 ? capacity * 2 : capacity + 1024));
    }

    private void setEnd(int to) {
        this.end = to;
    }

    private void setEnd(iterator to) {
        this.setEnd(to.$sub(this.begin()));
    }

    public iterator $toIterator(ushort.ptr ptr2) {
        assert (ptr2.$array() == this.array);
        return new iterator(this, ptr2.$index(), false);
    }

    @Override
    public Iterator<Character> iterator() {
        return new JavaIterator(this.begin(), this.end());
    }

    public boolean isDataPointerLike() {
        return false;
    }

    public String toString() {
        if (this.end == 0) {
            return "<EMPTY>";
        }
        StringBuilder out = new StringBuilder("\nSmallVectorImplUShort{\nend = " + this.end + '\n');
        String fmt = "%" + (int)Math.ceil(Math.log10(this.end + 1)) + "d";
        for (int i = 0; i < this.end; ++i) {
            char element = this.array[i];
            out.append("[").append(String.format(fmt, i)).append("]");
            out.append(element).append('\n');
        }
        out.append("}SmallVectorImplUShort}\n");
        return out.toString();
    }

    private static final class JavaIterator
    implements Iterator<Character> {
        private final iterator begin;
        private final iterator end;

        public JavaIterator(iterator begin, iterator end) {
            this.begin = (iterator)Native.$tryClone((NativeCloneable)begin);
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.begin.$noteq(this.end);
        }

        @Override
        public Character next() {
            Character val = Character.valueOf(this.begin.$star());
            this.begin.$preInc();
            return val;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    public static final class iterator
    implements ushort.iterator<iterator>,
    Native.assignable<iterator>,
    Native.ComparableLowerGreater {
        private final boolean _const;
        private final SmallVectorImplUShort delegate;
        private int index;

        private iterator(SmallVectorImplUShort delegate, int index, boolean makeConst) {
            this.delegate = delegate;
            this.index = index;
            this._const = makeConst;
        }

        public iterator $assign(iterator other) {
            assert (this.delegate == other.delegate);
            this.index = other.index;
            return this;
        }

        public char $arrow() {
            return this.$at(0);
        }

        public char $star() {
            return this.$at(0);
        }

        public ushort.ref star$ref() {
            return this.ref$at(0);
        }

        public int $sub(iterator iter) {
            assert (this.delegate == iter.delegate);
            return this.index - iter.index;
        }

        public iterator $preInc() {
            assert (!this._const);
            ++this.index;
            return this;
        }

        public iterator $preDec() {
            assert (!this._const);
            --this.index;
            return this;
        }

        public iterator $postInc() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            ++this.index;
            return cloned;
        }

        public iterator $postDec() {
            assert (!this._const);
            iterator cloned = new iterator(this.delegate, this.index, false);
            --this.index;
            return cloned;
        }

        public iterator $inc(int amount) {
            assert (!this._const);
            this.index += amount;
            return this;
        }

        public iterator $dec(int amount) {
            assert (!this._const);
            this.index -= amount;
            return this;
        }

        public iterator $add(int amount) {
            return new iterator(this.delegate, this.index + amount, false);
        }

        public iterator $sub(int amount) {
            return new iterator(this.delegate, this.index - amount, false);
        }

        public boolean $noteq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index != ((iterator)other).index;
        }

        public boolean $eq(Object other) {
            assert (this.delegate == ((iterator)other).delegate);
            return this.index == ((iterator)other).index;
        }

        public iterator clone() {
            return new iterator(this.delegate, this.index, false);
        }

        public iterator const_clone() {
            return new iterator(this.delegate, this.index, true);
        }

        public boolean $less(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index < ((iterator)obj).index;
        }

        public boolean $lesseq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index <= ((iterator)obj).index;
        }

        public boolean $greater(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index > ((iterator)obj).index;
        }

        public boolean $greatereq(Object obj) {
            assert (this.delegate == ((iterator)obj).delegate);
            return this.index >= ((iterator)obj).index;
        }

        public char $at(int index) {
            return this.delegate.$at(this.index + index);
        }

        public ushort.ref ref$at(int index) {
            return this.delegate.ref$at(this.index + index);
        }

        public ushort.ptr toPointer() {
            return NativePointer.create_ushort$ptr((char[])this.delegate.array, (int)this.index);
        }

        public String toString() {
            return "[" + this.index + "] from\n" + this.delegate.toString();
        }
    }
}

