/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt.aliases;

import java.util.Arrays;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.aliases.DenseMapBaseUIntType;
import org.llvm.adt.aliases.DenseMapInfoUInt;
import org.llvm.support.llvm;

public class SmallDenseMapUIntType<ValueT>
extends DenseMapBaseUIntType<SmallDenseMapUIntType<ValueT>, ValueT>
implements Native.assignable<SmallDenseMapUIntType<ValueT>>,
Destructors.ClassWithDestructor {
    private std_pair.pairUIntType<ValueT>[] Buckets;
    private int NumEntries;
    private int NumTombstones;
    private int NumBuckets;
    private final type.ref<std_pair.pairUIntType<ValueT>[]> BucketsRef = new type.ref<std_pair.pairUIntType<ValueT>[]>(){

        public std_pair.pairUIntType<ValueT>[] $deref() {
            return SmallDenseMapUIntType.this.Buckets;
        }

        public std_pair.pairUIntType<ValueT>[] $set(std_pair.pairUIntType<ValueT>[] value) {
            SmallDenseMapUIntType.access$002(SmallDenseMapUIntType.this, value);
            return value;
        }
    };
    private final uint.ref NumBucketsRef = new uint.ref(){

        public int $deref() {
            return SmallDenseMapUIntType.this.NumBuckets;
        }

        public int $set(int value) {
            SmallDenseMapUIntType.this.NumBuckets = value;
            return SmallDenseMapUIntType.this.NumBuckets;
        }
    };
    private final uint.ref NumEntriesRef = new uint.ref(){

        public int $deref() {
            return SmallDenseMapUIntType.this.NumEntries;
        }

        public int $set(int value) {
            SmallDenseMapUIntType.this.NumEntries = value;
            return SmallDenseMapUIntType.this.NumEntries;
        }
    };
    private final uint.ref NumTombstonesRef = new uint.ref(){

        public int $deref() {
            return SmallDenseMapUIntType.this.NumTombstones;
        }

        public int $set(int value) {
            SmallDenseMapUIntType.this.NumTombstones = value;
            return SmallDenseMapUIntType.this.NumTombstones;
        }
    };

    public SmallDenseMapUIntType(DenseMapInfoUInt keyInfo, ValueT defaultValue) {
        this(keyInfo, 0, defaultValue);
    }

    public SmallDenseMapUIntType(DenseMapInfoUInt keyInfo, int NumInitBuckets, ValueT defaultValue) {
        super(keyInfo, defaultValue);
        this.init(NumInitBuckets);
    }

    public SmallDenseMapUIntType(SmallDenseMapUIntType<ValueT> other) {
        super(other.keyInfoT, other.defaultValue);
        this.init(0);
        this.copyFrom(other);
    }

    public SmallDenseMapUIntType(DenseMapInfoUInt keyInfo, type.iterator<?, std_pair.pairUIntType<ValueT>> I, type.iterator<?, std_pair.pairUIntType<ValueT>> E, ValueT defaultValue) {
        super(keyInfo, defaultValue);
        this.init(llvm.NextPowerOf2(std.distance(I, E)));
        this.insert(I, E);
    }

    public void $destroy() {
        this.destroyAll();
    }

    public void swap(SmallDenseMapUIntType<ValueT> RHS) {
        std.swap(this.BucketsRef, RHS.BucketsRef);
        std.swap((uint.ref)this.NumEntriesRef, (uint.ref)RHS.NumEntriesRef);
        std.swap((uint.ref)this.NumTombstonesRef, (uint.ref)RHS.NumTombstonesRef);
        std.swap((uint.ref)this.NumBucketsRef, (uint.ref)RHS.NumBucketsRef);
    }

    public SmallDenseMapUIntType<ValueT> $assign(SmallDenseMapUIntType<ValueT> other) {
        this.copyFrom(other);
        return this;
    }

    public void copyFrom(SmallDenseMapUIntType<ValueT> other) {
        this.destroyAll();
        if (this.allocateBuckets(other.NumBuckets)) {
            super.copyFrom(other);
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    public void init(int InitBuckets) {
        if (this.allocateBuckets(InitBuckets)) {
            super.initEmpty();
        } else {
            this.NumEntries = 0;
            this.NumTombstones = 0;
        }
    }

    @Override
    public void grow(int AtLeast) {
        int OldNumBuckets = this.NumBuckets;
        std_pair.pairUIntType<ValueT>[] OldBuckets = this.Buckets;
        this.allocateBuckets(std.max((int)64, (int)llvm.NextPowerOf2(AtLeast - 1)));
        if (OldBuckets == null) {
            super.initEmpty();
            return;
        }
        this.moveFromOldBuckets(OldBuckets, OldNumBuckets);
    }

    @Override
    public void shrink_and_clear() {
        int OldNumEntries = this.NumEntries;
        this.destroyAll();
        int NewNumBuckets = 0;
        if (OldNumEntries != 0) {
            NewNumBuckets = std.max((int)64, (int)(1 << llvm.Log2_32_Ceil(OldNumEntries) + 1));
        }
        if (NewNumBuckets == this.NumBuckets) {
            super.initEmpty();
            return;
        }
        this.init(NewNumBuckets);
    }

    @Override
    protected int getNumEntries() {
        return this.NumEntries;
    }

    @Override
    protected void setNumEntries(int Num) {
        this.NumEntries = Num;
    }

    @Override
    protected int getNumTombstones() {
        return this.NumTombstones;
    }

    @Override
    protected void setNumTombstones(int Num) {
        this.NumTombstones = Num;
    }

    @Override
    protected type.ptr<std_pair.pairUIntType<ValueT>> getBuckets() {
        return NativePointer.create_type$ptr((Object[])this.Buckets);
    }

    @Override
    protected std_pair.pairUIntType<ValueT>[] $Buckets() {
        return this.Buckets;
    }

    @Override
    protected int getNumBuckets() {
        return this.NumBuckets;
    }

    private boolean allocateBuckets(int Num) {
        this.NumBuckets = Num;
        if (this.NumBuckets == 0) {
            this.Buckets = null;
            return false;
        }
        std_pair.pairUIntType[] bucketsArray = new std_pair.pairUIntType[this.NumBuckets];
        for (int i = 0; i < this.NumBuckets; ++i) {
            bucketsArray[i] = new std_pair.pairUIntType();
        }
        this.Buckets = bucketsArray;
        return true;
    }

    public String toString() {
        return "DenseMap{Buckets=[\n" + Arrays.toString(this.Buckets) + "\n], NumEntries=" + this.NumEntries + ", NumTombstones=" + this.NumTombstones + ", NumBuckets=" + this.NumBuckets + '}';
    }

    static /* synthetic */ std_pair.pairUIntType[] access$002(SmallDenseMapUIntType x0, std_pair.pairUIntType[] x1) {
        x0.Buckets = x1;
        return x1;
    }
}

