/*
 * Decompiled with CFR 0.152.
 */
package org.llvm.adt;

import org.clank.support.Native;
import org.clank.support.aliases.type;
import org.llvm.adt.FoldingSet;
import org.llvm.adt.FoldingSetImpl;
import org.llvm.adt.FoldingSetNodeID;
import org.llvm.adt.FoldingSetTrait;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.pointee_iterator;

public class FoldingSetVector<T extends FoldingSetImpl.Node> {
    private FoldingSet<T> Set;
    private SmallVector<T> Vector;

    public FoldingSetVector(FoldingSetTrait<T> trait) {
        this(trait, 6);
    }

    public FoldingSetVector(FoldingSetTrait<T> trait, int Log2InitSize) {
        this.Set = new FoldingSet<T>(trait, Log2InitSize);
        this.Vector = new SmallVector(8);
    }

    public pointee_iterator<SmallVectorImpl.iterator<T>> begin() {
        return new pointee_iterator<SmallVectorImpl.iterator<T>>(this.Vector.begin());
    }

    public pointee_iterator<SmallVectorImpl.iterator<T>> end() {
        return new pointee_iterator<SmallVectorImpl.iterator<T>>(this.Vector.end());
    }

    public void clear() {
        this.Set.clear();
        this.Vector.clear();
    }

    public T FindNodeOrInsertPos(FoldingSetNodeID ID, type.ref<Object> InsertPos) {
        return this.Set.FindNodeOrInsertPos(ID, InsertPos);
    }

    public T GetOrInsertNode(T N) {
        T Result = this.Set.GetOrInsertNode((FoldingSetImpl.Node)N);
        if (Native.$eq(Result, N)) {
            this.Vector.push_back(N);
        }
        return Result;
    }

    public void InsertNode(T N, Object InsertPos) {
        this.Set.InsertNode((FoldingSetImpl.Node)N, InsertPos);
        this.Vector.push_back(N);
    }

    public void InsertNode(T N) {
        this.Set.InsertNode((FoldingSetImpl.Node)N);
        this.Vector.push_back(N);
    }

    public int size() {
        return this.Set.size();
    }

    public boolean empty() {
        return this.Set.empty();
    }

    public String toString() {
        return "Set=" + this.Set + ", Vector=" + this.Vector;
    }
}

