/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.awt.Dialog;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.httpserver.GrantAccessEvent;
import org.netbeans.modules.httpserver.GrantAccessListener;
import org.netbeans.modules.httpserver.GrantAccessPanel;
import org.netbeans.modules.httpserver.HttpServerModule;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.BeanNode;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public final class HttpServerSettings {
    private static HttpServerSettings INSTANCE = new HttpServerSettings();
    private static BeanNode view = null;
    private static final int MAX_START_RETRIES = 20;
    private static int currentRetries = 0;
    protected static final EventListenerList listenerList = new EventListenerList();
    static boolean inited = false;
    private static Hashtable<InetAddress, Thread> whoAsking = new Hashtable();
    public static final int SERVER_STARTUP_TIMEOUT = 3000;
    public static final String LOCALHOST = "local";
    public static final String ANYHOST = "any";
    public static HostProperty hostProperty = null;
    public static final String PROP_PORT = "port";
    public static final String PROP_HOST_PROPERTY = "hostProperty";
    static final String PROP_WRAPPER_BASEURL = "wrapperBaseURL";
    public static final String PROP_RUNNING = "running";
    private static final String PROP_SHOW_GRANT_ACCESS = "showGrantAccess";
    private static final int DEFAULT_PORT = 8082;
    private static String wrapperBaseURL = "/resource/";
    static boolean running = false;
    private static boolean startStopMessages = true;
    private static Properties mappedServlets = new Properties();
    public static HttpServerSettings OPTIONS = null;
    private static Object httpLock;

    private static Preferences getPreferences() {
        return NbPreferences.forModule(HttpServerSettings.class);
    }

    static final Object httpLock() {
        if (httpLock == null) {
            httpLock = new Object();
        }
        return httpLock;
    }

    private HttpServerSettings() {
    }

    public static HttpServerSettings getDefault() {
        return INSTANCE;
    }

    public boolean isRunning() {
        if (inited) {
            return running;
        }
        this.setRunning(false);
        return running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runSuccess() {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            currentRetries = 0;
            running = true;
            HttpServerSettings.httpLock().notifyAll();
        }
    }

    void runFailure(Throwable t) {
        running = false;
        if (t instanceof IncompatibleClassChangeError) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HttpServerSettings.class, (String)"MSG_HTTP_SERVER_incompatbleClasses"), 2));
        } else if (t instanceof BindException) {
            if (++currentRetries <= 20) {
                this.setPort(this.getPort() + 1);
                this.setRunning(true);
            } else {
                currentRetries = 0;
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HttpServerSettings.class, (String)"MSG_HTTP_SERVER_START_FAIL"), 2));
                int p = this.getPort();
                if (p < 1024 && inited && Utilities.isUnix()) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HttpServerSettings.class, (String)"MSG_onlyRootOnUnix"), 2));
                }
            }
        } else {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HttpServerSettings.class, (String)"MSG_HTTP_SERVER_START_FAIL_unknown"), 2));
        }
    }

    private void restartIfNecessary(boolean printMessages) {
        if (running) {
            if (!printMessages) {
                this.setStartStopMessages(false);
            }
            HttpServerModule.stopHTTPServer();
            HttpServerModule.initHTTPServer();
        }
    }

    private String getCanonicalRelativeURL(String url) {
        String newURL;
        if (url.length() == 0) {
            newURL = "/";
        } else {
            newURL = url.charAt(0) != '/' ? "/" + url : url;
            if (newURL.charAt(newURL.length() - 1) != '/') {
                newURL = newURL + "/";
            }
        }
        return newURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean running) {
        inited = true;
        if (HttpServerSettings.running == running) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            if (running) {
                HttpServerModule.initHTTPServer();
            } else {
                HttpServerSettings.running = false;
                HttpServerModule.stopHTTPServer();
            }
        }
    }

    String getWrapperBaseURL() {
        return wrapperBaseURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWrapperBaseURL(String wrapperBaseURL) {
        String newURL = this.getCanonicalRelativeURL(wrapperBaseURL);
        if (HttpServerSettings.wrapperBaseURL.equals(newURL)) {
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            String oldURL = HttpServerSettings.wrapperBaseURL;
            HttpServerSettings.wrapperBaseURL = newURL;
            this.restartIfNecessary(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPort(int p) {
        if (p <= 0 || p > 65535) {
            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(HttpServerSettings.class, (String)"ERR_PortNumberOutOfRange", (Object)new Integer(p)), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
            return;
        }
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            HttpServerSettings.getPreferences().putInt(PROP_PORT, p);
            this.restartIfNecessary(true);
        }
    }

    public int getPort() {
        return HttpServerSettings.getPreferences().getInt(PROP_PORT, 8082);
    }

    public void setStartStopMessages(boolean ssm) {
        startStopMessages = ssm;
    }

    public boolean isStartStopMessages() {
        return startStopMessages;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HttpServerSettings.class);
    }

    private String getLocalHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public void addGrantAccessListener(GrantAccessListener l) {
        listenerList.add(GrantAccessListener.class, l);
    }

    public void removeGrantAccessListener(GrantAccessListener l) {
        listenerList.remove(GrantAccessListener.class, l);
    }

    protected boolean fireGrantAccessEvent(InetAddress clientAddress, String resource) {
        Object[] listeners = listenerList.getListenerList();
        GrantAccessEvent grantAccessEvent = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != GrantAccessListener.class) continue;
            if (grantAccessEvent == null) {
                grantAccessEvent = new GrantAccessEvent(this, clientAddress, resource);
            }
            ((GrantAccessListener)listeners[i + 1]).grantAccess(grantAccessEvent);
        }
        return grantAccessEvent == null ? false : grantAccessEvent.isGranted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean allowAccess(InetAddress addr, String requestPath) {
        if (this.accessAllowedNow(addr, requestPath)) {
            return true;
        }
        Thread askThread = null;
        Object object = whoAsking;
        synchronized (object) {
            if (this.accessAllowedNow(addr, requestPath)) {
                return true;
            }
            askThread = whoAsking.get(addr);
            if (askThread == null) {
                askThread = Thread.currentThread();
                whoAsking.put(addr, askThread);
            }
        }
        object = HttpServerSettings.class;
        synchronized (HttpServerSettings.class) {
            if (askThread != Thread.currentThread()) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return this.accessAllowedNow(addr, requestPath);
            }
            try {
                if (!this.isShowGrantAccessDialog()) {
                    boolean bl = false;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return bl;
                }
                String msg = NbBundle.getMessage(HttpServerSettings.class, (String)"MSG_AddAddress", (Object)addr.getHostAddress());
                GrantAccessPanel panel = new GrantAccessPanel(msg);
                DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(HttpServerSettings.class, (String)"CTL_GrantAccessTitle"), true, 0, NotifyDescriptor.NO_OPTION, null);
                descriptor.setMessageType(3);
                Dialog d = DialogDisplayer.getDefault().createDialog(descriptor);
                d.setSize(580, 180);
                d.setVisible(true);
                this.setShowGrantAccessDialog(panel.getShowDialog());
                if (NotifyDescriptor.YES_OPTION.equals(descriptor.getValue())) {
                    this.appendAddressToGranted(addr.getHostAddress());
                    boolean bl = true;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return bl;
                }
                boolean bl = false;
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return bl;
            }
            finally {
                whoAsking.remove(addr);
            }
        }
    }

    private boolean accessAllowedNow(InetAddress addr, String resource) {
        if (hostProperty.getHost().equals(ANYHOST)) {
            return true;
        }
        Set<String> hs = this.getGrantedAddressesSet();
        if (hs.contains(addr.getHostAddress())) {
            return true;
        }
        return this.fireGrantAccessEvent(addr, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendAddressToGranted(String addr) {
        Object object = HttpServerSettings.httpLock();
        synchronized (object) {
            String granted = hostProperty.getGrantedAddresses().trim();
            if (granted.length() > 0 && granted.charAt(granted.length() - 1) != ';' && granted.charAt(granted.length() - 1) != ',') {
                granted = granted + ',';
            }
            granted = granted + addr;
            hostProperty.setGrantedAddresses(granted);
        }
    }

    Set<String> getGrantedAddressesSet() {
        HashSet<String> addr = new HashSet<String>();
        try {
            addr.add(InetAddress.getByName("localhost").getHostAddress());
            addr.add(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        StringTokenizer st = new StringTokenizer(hostProperty.getGrantedAddresses(), ",;");
        while (st.hasMoreTokens()) {
            String ipa = st.nextToken();
            ipa = ipa.trim();
            try {
                addr.add(InetAddress.getByName(ipa).getHostAddress());
            }
            catch (UnknownHostException unknownHostException) {}
        }
        return addr;
    }

    Properties getMappedServlets() {
        return mappedServlets;
    }

    static String mangle(String name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            if (Character.isLetterOrDigit(name.charAt(i)) || name.charAt(i) == '.') {
                sb.append(name.charAt(i));
                continue;
            }
            String code = Integer.toHexString(name.charAt(i)).toUpperCase();
            if (code.length() < 2) {
                code = code.length() == 0 ? "00" : "0" + code;
            }
            sb.append("%").append(code.length() == 2 ? code : code.substring(code.length() - 2));
        }
        return sb.toString();
    }

    static String demangle(String name) {
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < name.length(); ++i) {
                if (name.charAt(i) != '%') {
                    sb.append(name.charAt(i));
                    continue;
                }
                sb.append((char)Integer.parseInt(name.substring(i + 1, i + 3), 16));
                i += 2;
            }
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            return "";
        }
        return sb.toString();
    }

    public HostProperty getHostProperty() {
        if (hostProperty == null) {
            hostProperty = new HostProperty(HttpServerSettings.getPreferences().get("grantedAddresses", ""), HttpServerSettings.getPreferences().get("host", LOCALHOST));
        }
        return hostProperty;
    }

    public void setHostProperty(HostProperty hostProperty) {
        if (ANYHOST.equals(hostProperty.getHost()) || LOCALHOST.equals(hostProperty.getHost())) {
            HttpServerSettings.hostProperty.setHost(hostProperty.getHost());
            HttpServerSettings.hostProperty.setGrantedAddresses(hostProperty.getGrantedAddresses());
            HttpServerSettings.getPreferences().put("host", hostProperty.getHost());
            HttpServerSettings.getPreferences().put("grantedAddresses", hostProperty.getGrantedAddresses());
        }
    }

    public boolean isShowGrantAccessDialog() {
        return HttpServerSettings.getPreferences().getBoolean(PROP_SHOW_GRANT_ACCESS, true);
    }

    public void setShowGrantAccessDialog(boolean show) {
        HttpServerSettings.getPreferences().putBoolean(PROP_SHOW_GRANT_ACCESS, show);
    }

    public static class HostProperty
    implements Serializable {
        private String grantedAddresses;
        private String host;
        private static final long serialVersionUID = 1927848926692414249L;

        HostProperty(String grantedAddresses, String host) {
            this.grantedAddresses = grantedAddresses;
            this.host = host;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getGrantedAddresses() {
            return this.grantedAddresses;
        }

        public void setGrantedAddresses(String grantedAddresses) {
            this.grantedAddresses = grantedAddresses;
        }
    }
}

