/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.web.WebFragment;
import org.netbeans.modules.j2ee.dd.api.web.WebFragmentProvider;
import org.netbeans.modules.j2ee.dd.impl.web.WebParseUtils;
import org.netbeans.modules.j2ee.ddloaders.multiview.DDMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataLoader;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DDFragmentDataObject
extends DDDataObject {
    private transient WebApp webApp;
    private static final long serialVersionUID = 8857563089355069363L;
    private static final Logger LOG = Logger.getLogger(DDMultiViewDataObject.class.getName());

    public DDFragmentDataObject(FileObject pf, DDDataLoader loader, String editorMimeType) throws DataObjectExistsException {
        super(pf, loader, editorMimeType);
    }

    @Override
    public WebApp getWebApp() {
        if (this.webApp == null) {
            try {
                this.webApp = this.createWebFrag();
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "getWebApp failed", ex);
            }
        }
        return this.webApp;
    }

    private WebApp createWebFrag() throws IOException {
        WebFragment webFrag = WebFragmentProvider.getDefault().getWebFragmentRoot(this.getPrimaryFile());
        if (webFrag != null) {
            this.setSaxError(webFrag.getError());
        }
        return webFrag;
    }

    @Override
    protected void parseDocument() throws IOException {
        if (this.webApp == null) {
            try {
                this.webApp = WebFragmentProvider.getDefault().getWebFragmentRoot(this.getPrimaryFile());
            }
            catch (IOException ex) {
                LOG.log(Level.INFO, "parseDocument failed", ex);
            }
        }
    }

    @Override
    protected String getPrefixMark() {
        return "<web-fragment";
    }

    @Override
    protected boolean isModelCreated() {
        return this.webApp != null;
    }

    @Override
    public boolean isDeleteAllowed() {
        return true;
    }

    @Override
    protected void validateDocument() throws IOException {
        InputSource is = new InputSource(this.createReader());
        try {
            SAXParseException error = WebParseUtils.parse((InputSource)is);
            if (error != null) {
                throw error;
            }
        }
        catch (SAXException ex) {
            LOG.log(Level.SEVERE, "Parsing failed!", ex);
            throw new IOException("Parsing failed: " + ex);
        }
    }
}

