/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.zend;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.spi.phpmodule.ImportantFilesImplementation;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;

public final class ConfigurationFiles
extends FileChangeAdapter
implements ImportantFilesImplementation {
    private static final String CONFIG_DIRECTORY = "application/configs";
    private static final String BOOTSTRAP_FILE = "application/Bootstrap.php";
    private final PhpModule phpModule;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject sourceDirectory = null;

    ConfigurationFiles(PhpModule phpModule) {
        assert (phpModule != null);
        this.phpModule = phpModule;
    }

    public Collection<ImportantFilesImplementation.FileInfo> getFiles() {
        FileObject sourceDir = this.getSourceDirectory();
        if (sourceDir == null) {
            return Collections.emptyList();
        }
        ArrayList<ImportantFilesImplementation.FileInfo> files = new ArrayList<ImportantFilesImplementation.FileInfo>();
        FileObject configDir = sourceDir.getFileObject(CONFIG_DIRECTORY);
        if (configDir != null && configDir.isFolder() && configDir.isValid()) {
            FileObject[] children;
            for (FileObject child : children = configDir.getChildren()) {
                if (!child.isData()) continue;
                files.add(new ImportantFilesImplementation.FileInfo(child));
            }
        }
        Collections.sort(files, ImportantFilesImplementation.FileInfo.COMPARATOR);
        FileObject bootstrap = sourceDir.getFileObject(BOOTSTRAP_FILE);
        if (bootstrap != null) {
            files.add(new ImportantFilesImplementation.FileInfo(bootstrap));
        }
        return files;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    private void fireChange() {
        this.changeSupport.fireChange();
    }

    @CheckForNull
    private synchronized FileObject getSourceDirectory() {
        if (this.sourceDirectory == null) {
            this.sourceDirectory = this.phpModule.getSourceDirectory();
            if (this.sourceDirectory != null) {
                File sources = FileUtil.toFile((FileObject)this.sourceDirectory);
                this.addListener(new File(sources, CONFIG_DIRECTORY));
                this.addListener(new File(sources, BOOTSTRAP_FILE));
            }
        }
        return this.sourceDirectory;
    }

    private void addListener(File path) {
        block2: {
            try {
                FileUtil.addFileChangeListener((FileChangeListener)this, (File)path);
            }
            catch (IllegalArgumentException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError(path);
            }
        }
    }

    public void fileRenamed(FileRenameEvent fe) {
        this.fireChange();
    }

    public void fileDeleted(FileEvent fe) {
        this.fireChange();
    }

    public void fileDataCreated(FileEvent fe) {
        this.fireChange();
    }

    public void fileFolderCreated(FileEvent fe) {
        this.fireChange();
    }
}

