/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.storage;

import java.util.Collection;
import org.netbeans.modules.cnd.repository.api.FilePath;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.spi.RepositoryPathMapperImplementation;
import org.netbeans.modules.cnd.repository.spi.UnitDescriptorsMatcherImplementation;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.Lookup;

public final class RepositoryMapper {
    private static final RepositoryMapper instance = new RepositoryMapper();

    private RepositoryMapper() {
    }

    public static boolean matches(UnitDescriptor descriptor1, UnitDescriptor descriptor2) {
        return instance.matchesImpl(descriptor1, descriptor2);
    }

    public static UnitDescriptor mapToClient(FileSystem targetFileSystem, UnitDescriptor layerUnitDescriptor) {
        return instance.mapToClientImpl(targetFileSystem, layerUnitDescriptor);
    }

    public static UnitDescriptor mapToLayer(FileSystem targetFileSystem, UnitDescriptor clientUnitDescriptor) {
        return instance.mapToLayerImpl(targetFileSystem, clientUnitDescriptor);
    }

    public static CharSequence map(UnitDescriptor clientUnitDescriptor, FilePath sourceFilePath) {
        return instance.mapImpl(clientUnitDescriptor, sourceFilePath);
    }

    public CharSequence mapImpl(UnitDescriptor clientUnitDescriptor, FilePath sourceFilePath) {
        Collection impls = Lookup.getDefault().lookupAll(RepositoryPathMapperImplementation.class);
        for (RepositoryPathMapperImplementation impl : impls) {
            CharSequence result = impl.map(clientUnitDescriptor, sourceFilePath);
            if (result == null) continue;
            return CharSequences.create((CharSequence)result);
        }
        return CharSequences.create((CharSequence)sourceFilePath.getPath());
    }

    private boolean matchesImpl(UnitDescriptor descriptor1, UnitDescriptor descriptor2) {
        if (descriptor1.equals((Object)descriptor2)) {
            return true;
        }
        Collection matchers = Lookup.getDefault().lookupAll(UnitDescriptorsMatcherImplementation.class);
        for (UnitDescriptorsMatcherImplementation unitDescriptorsMatcher : matchers) {
            if (!unitDescriptorsMatcher.matches(descriptor1, descriptor2)) continue;
            return true;
        }
        return false;
    }

    private UnitDescriptor mapToLayerImpl(FileSystem destFileSystem, UnitDescriptor sourceUnitDescriptor) {
        return new UnitDescriptor(sourceUnitDescriptor.getName(), destFileSystem);
    }

    private UnitDescriptor mapToClientImpl(FileSystem destFileSystem, UnitDescriptor layerUnitDescriptor) {
        Collection matchers = Lookup.getDefault().lookupAll(UnitDescriptorsMatcherImplementation.class);
        for (UnitDescriptorsMatcherImplementation unitDescriptorsMatcher : matchers) {
            UnitDescriptor clientUnitDescriptor = unitDescriptorsMatcher.destinationDescriptor(destFileSystem, layerUnitDescriptor);
            if (clientUnitDescriptor == null) continue;
            return clientUnitDescriptor;
        }
        return new UnitDescriptor(layerUnitDescriptor.getName(), destFileSystem);
    }

    private UnitDescriptor mapImpl(FileSystem destFileSystem, UnitDescriptor sourceUnitDescriptor) {
        Collection matchers = Lookup.getDefault().lookupAll(UnitDescriptorsMatcherImplementation.class);
        for (UnitDescriptorsMatcherImplementation unitDescriptorsMatcher : matchers) {
            UnitDescriptor clientUnitDescriptor = unitDescriptorsMatcher.destinationDescriptor(destFileSystem, sourceUnitDescriptor);
            if (clientUnitDescriptor == null) continue;
            return clientUnitDescriptor;
        }
        return new UnitDescriptor(sourceUnitDescriptor.getName(), destFileSystem);
    }
}

