/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.utils;

public class LinkedList<V> {
    private Element<V> head = null;
    private Element<V> tail = null;
    private Element<V> current = null;
    private int size = 0;

    public void addLast(V value) {
        if (this.tail == null) {
            this.current = new Element<V>(value);
            this.tail = this.current;
            this.head = this.current;
        } else {
            ((Element)this.tail).next = (Element)new Element<V>(value, this.tail, null);
            this.tail = ((Element)this.tail).next;
        }
        ++this.size;
    }

    public void addFirst(V value) {
        if (this.tail == null) {
            this.current = new Element<V>(value);
            this.tail = this.current;
            this.head = this.current;
        } else {
            ((Element)this.head).previous = (Element)new Element<V>(value, null, this.head);
            this.head = ((Element)this.tail).previous;
        }
        ++this.size;
    }

    public V removeLast() {
        if (this.tail == null) {
            return null;
        }
        Element<V> remove = this.tail;
        Object value = ((Element)this.tail).value;
        if (((Element)this.tail).previous != null) {
            ((Element)this.tail).previous.next = null;
        } else {
            this.head = null;
        }
        if (this.current == this.tail) {
            this.current = ((Element)this.current).previous;
        }
        this.tail = ((Element)this.tail).previous;
        remove.clear();
        --this.size;
        return (V)value;
    }

    public V removeFirst() {
        if (this.head == null) {
            return null;
        }
        Element<V> remove = this.head;
        Object value = ((Element)this.head).value;
        if (((Element)this.head).next != null) {
            ((Element)this.head).next.previous = null;
        } else {
            this.tail = null;
        }
        if (this.current == this.head) {
            this.current = ((Element)this.current).next;
        }
        this.head = ((Element)this.head).next;
        remove.clear();
        --this.size;
        return (V)value;
    }

    public void addNext(V value) {
        if (this.current == null) {
            this.current = new Element<V>(value);
            this.tail = this.current;
            this.head = this.current;
        } else {
            Element<V> add = new Element<V>(value, this.current, ((Element)this.current).next);
            if (((Element)this.current).next != null) {
                ((Element)this.current).next.previous = (Element)add;
            } else {
                this.tail = add;
            }
            ((Element)this.current).next = (Element)add;
        }
        ++this.size;
    }

    public void addPrevious(V value) {
        if (this.current == null) {
            this.current = new Element<V>(value);
            this.tail = this.current;
            this.head = this.current;
        } else {
            Element<V> add = new Element<V>(value, ((Element)this.current).previous, this.current);
            if (((Element)this.current).previous != null) {
                ((Element)this.current).previous.next = (Element)add;
            } else {
                this.head = add;
            }
            ((Element)this.current).previous = (Element)add;
        }
        ++this.size;
    }

    public V removeAndPrevious() {
        if (this.current == null) {
            return null;
        }
        Element<V> remove = this.current;
        Object value = ((Element)this.current).value;
        if (((Element)remove).previous != null) {
            ((Element)remove).previous.next = ((Element)remove).next;
            this.current = ((Element)remove).previous;
        } else {
            this.head = ((Element)remove).next;
            this.current = null;
        }
        if (((Element)remove).next != null) {
            ((Element)remove).next.previous = ((Element)remove).previous;
        } else {
            this.tail = ((Element)remove).previous;
        }
        remove.clear();
        --this.size;
        return (V)value;
    }

    public V removeAndNext() {
        if (this.current == null) {
            return null;
        }
        Element<V> remove = this.current;
        Object value = ((Element)this.current).value;
        if (((Element)remove).next != null) {
            ((Element)remove).next.previous = ((Element)remove).previous;
            this.current = ((Element)remove).next;
        } else {
            this.tail = ((Element)remove).previous;
            this.current = null;
        }
        if (((Element)remove).previous != null) {
            ((Element)remove).previous.next = ((Element)remove).next;
        } else {
            this.head = ((Element)remove).next;
        }
        remove.clear();
        --this.size;
        return (V)value;
    }

    public V removeAndPreviousOrNext() {
        if (this.current == null) {
            return null;
        }
        Element<V> remove = this.current;
        Object value = ((Element)this.current).value;
        if (((Element)remove).previous != null) {
            ((Element)remove).previous.next = ((Element)remove).next;
            this.current = ((Element)remove).previous;
        } else {
            this.head = ((Element)remove).next;
            this.current = ((Element)remove).next;
        }
        if (((Element)remove).next != null) {
            ((Element)remove).next.previous = ((Element)remove).previous;
        } else {
            this.tail = ((Element)remove).previous;
        }
        remove.clear();
        --this.size;
        return (V)value;
    }

    public V removeAndNextOrPrevious() {
        if (this.current == null) {
            return null;
        }
        Element<V> remove = this.current;
        Object value = ((Element)this.current).value;
        if (((Element)remove).next != null) {
            ((Element)remove).next.previous = ((Element)remove).previous;
            this.current = ((Element)remove).next;
        } else {
            this.tail = ((Element)remove).previous;
            this.current = ((Element)remove).previous;
        }
        if (((Element)remove).previous != null) {
            ((Element)remove).previous.next = ((Element)remove).next;
        } else {
            this.head = ((Element)remove).next;
        }
        remove.clear();
        --this.size;
        return (V)value;
    }

    public boolean first() {
        this.current = this.head;
        return this.current != null;
    }

    public boolean last() {
        this.current = this.tail;
        return this.current != null;
    }

    public boolean next() {
        if (this.current != null && ((Element)this.current).next != null) {
            this.current = ((Element)this.current).next;
            return true;
        }
        return false;
    }

    public boolean previous() {
        if (this.current != null && ((Element)this.current).previous != null) {
            this.current = ((Element)this.current).previous;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public boolean isCurrent() {
        return this.current != null;
    }

    public boolean isNext() {
        return this.current != null && ((Element)this.current).next != null;
    }

    public boolean isPrevious() {
        return this.current != null && ((Element)this.current).previous != null;
    }

    public int size() {
        return this.size;
    }

    public V getCurrent() {
        if (this.current != null) {
            return (V)((Element)this.current).value;
        }
        return null;
    }

    public V getFirst() {
        if (this.head != null) {
            return (V)((Element)this.head).value;
        }
        return null;
    }

    public V getLast() {
        if (this.tail != null) {
            return (V)((Element)this.tail).value;
        }
        return null;
    }

    public V getNext() {
        if (this.current != null && ((Element)this.current).next != null) {
            return (V)((Element)this.current).next.value;
        }
        return null;
    }

    public V getPrevious() {
        if (this.current != null && ((Element)this.current).previous != null) {
            return (V)((Element)this.current).previous.value;
        }
        return null;
    }

    public String toString() {
        Element element = this.head;
        StringBuilder sb = new StringBuilder("[");
        while (element != null) {
            sb.append(element.value != null ? element.value.toString() : "null");
            if ((element = element.next) == null) continue;
            sb.append(',');
        }
        sb.append("]");
        return sb.toString();
    }

    public void clear() {
        this.current = this.head;
        while (this.current != null) {
            Element<V> delete = this.current;
            this.current = ((Element)this.current).next;
            delete.clear();
        }
        this.current = null;
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public static class Element<V> {
        private Element<V> previous;
        private Element<V> next;
        private V value;

        Element(V value) {
            this(value, null, null);
        }

        Element(V value, Element<V> previous, Element<V> next) {
            this.value = value;
            this.previous = previous;
            this.next = next;
        }

        void clear() {
            this.previous = null;
            this.next = null;
            this.value = null;
        }
    }
}

