/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.hibernate.refactoring.MoveMappingFilePanel;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUIBypass;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.NodeRenderer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;

final class MoveMappingFilesRefactoringUI
implements RefactoringUI,
RefactoringUIBypass {
    private MoveRefactoring refactoring;
    private FileObject[] mappingFileObjects;
    private MovePanel panel;
    private boolean disable;
    private FileObject targetFolder;
    private PasteType pasteType;

    public MoveMappingFilesRefactoringUI(FileObject[] mappingFileObjects, FileObject targetFolder, PasteType pasteType) {
        this.refactoring = new MoveRefactoring(Lookups.fixed((Object[])mappingFileObjects));
        this.disable = targetFolder != null;
        this.targetFolder = targetFolder;
        this.mappingFileObjects = mappingFileObjects;
        this.pasteType = pasteType;
    }

    public String getName() {
        return NbBundle.getMessage(MoveMappingFilesRefactoringUI.class, (String)"LBL_Move");
    }

    public String getDescription() {
        return this.getName();
    }

    public boolean isQuery() {
        return false;
    }

    public CustomRefactoringPanel getPanel(ChangeListener parent) {
        if (this.panel == null) {
            ClassPath cp;
            String pkgName = null;
            if (this.targetFolder != null && (cp = ClassPath.getClassPath((FileObject)this.targetFolder, (String)"classpath/source")) != null) {
                pkgName = cp.getResourceName(this.targetFolder, '.', false);
            }
            String headline = NbBundle.getMessage(MoveMappingFilesRefactoringUI.class, (String)"DSC_MoveMappingFiles");
            if (this.mappingFileObjects.length == 1) {
                headline = NbBundle.getMessage(MoveMappingFilesRefactoringUI.class, (String)"DSC_MoveOneMappingFile", (Object)this.mappingFileObjects[0].getName());
            }
            this.panel = new MovePanel(parent, pkgName != null ? pkgName : MoveMappingFilesRefactoringUI.getDOPackageName(this.mappingFileObjects[0].getParent()), headline);
        }
        return this.panel;
    }

    private static String getDOPackageName(FileObject f) {
        ClassPath cp = ClassPath.getClassPath((FileObject)f, (String)"classpath/source");
        if (cp != null) {
            return cp.getResourceName(f, '.', false);
        }
        return f.getName();
    }

    public boolean hasParameters() {
        return true;
    }

    public Problem checkParameters() {
        return this.setParameters(true);
    }

    public Problem setParameters() {
        return this.setParameters(false);
    }

    private Problem setParameters(boolean checkOnly) {
        if (this.panel == null) {
            return null;
        }
        URL url = URLMapper.findURL((FileObject)this.panel.getRootFolder(), (int)1);
        try {
            this.refactoring.setTarget(Lookups.singleton((Object)new URL(url.toExternalForm() + URLEncoder.encode(this.panel.getPackageName().replace('.', '/'), "utf-8"))));
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (MalformedURLException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        if (checkOnly) {
            return this.refactoring.fastCheckParameters();
        }
        return this.refactoring.checkParameters();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(MoveMappingFilesRefactoringUI.class);
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public boolean isRefactoringBypassRequired() {
        return !this.panel.isUpdateReferences();
    }

    public void doRefactoringBypass() throws IOException {
        this.pasteType.paste();
    }

    private final Vector getNodes() {
        Vector<Node> result = new Vector<Node>(this.mappingFileObjects.length);
        LinkedList<FileObject> q = new LinkedList<FileObject>(Arrays.asList(this.mappingFileObjects));
        while (!q.isEmpty()) {
            FileObject f = q.removeFirst();
            if (!VisibilityQuery.getDefault().isVisible(f)) continue;
            DataObject d = null;
            try {
                d = DataObject.find((FileObject)f);
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            if (d instanceof DataFolder) {
                for (DataObject o : ((DataFolder)d).getChildren()) {
                    q.addLast(o.getPrimaryFile());
                }
                continue;
            }
            result.add(d.getNodeDelegate());
        }
        return result;
    }

    class MovePanel
    extends MoveMappingFilePanel {
        public MovePanel(ChangeListener parent, String startPackage, String headLine) {
            super(parent, startPackage, headLine, MoveMappingFilesRefactoringUI.this.targetFolder != null ? MoveMappingFilesRefactoringUI.this.targetFolder : MoveMappingFilesRefactoringUI.this.mappingFileObjects[0]);
            if (MoveMappingFilesRefactoringUI.this.mappingFileObjects.length > 1) {
                this.setCombosEnabled(!MoveMappingFilesRefactoringUI.this.disable);
                JList list = new JList(MoveMappingFilesRefactoringUI.this.getNodes());
                list.setCellRenderer(new NodeRenderer());
                list.setVisibleRowCount(5);
                JScrollPane pane = new JScrollPane(list);
                this.bottomPanel.setBorder(new EmptyBorder(8, 0, 0, 0));
                this.bottomPanel.setLayout(new BorderLayout());
                this.bottomPanel.add((Component)pane, "Center");
                JLabel listOf = new JLabel();
                Mnemonics.setLocalizedText((JLabel)listOf, (String)NbBundle.getMessage(MovePanel.class, (String)"LBL_ListOfMappingFiles"));
                this.bottomPanel.add((Component)listOf, "North");
            }
        }
    }
}

