/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee.wizard;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressRunnable;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.form.j2ee.J2EEUtils;
import org.netbeans.modules.form.j2ee.wizard.DetailPanel;
import org.netbeans.modules.form.j2ee.wizard.MasterDetailGenerator;
import org.netbeans.modules.form.j2ee.wizard.MasterPanel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.JoinColumn;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.ManyToOne;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class MasterDetailWizard
implements WizardDescriptor.InstantiatingIterator {
    private static final String WIZARD_PANEL_CONTENT_DATA = "WizardPanel_contentData";
    private static final String WIZARD_PANEL_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private int panelIndex;
    private WizardDescriptor.Panel[] panels;
    private String[] steps;
    private WizardDescriptor wizard;
    private transient WizardDescriptor.InstantiatingIterator delegateIterator;
    private int beforeStepsNo;
    private String[] joinInfo;
    private String joinColumn;
    private String referencedColumn;
    private boolean needClassPathInit;
    private MetadataModel<EntityMappingsMetadata> mappings;
    private String unitName;

    MasterDetailWizard(boolean createNewFile) {
        if (createNewFile) {
            this.delegateIterator = JavaTemplates.createJavaTemplateIterator();
        }
    }

    public static MasterDetailWizard create() {
        return new MasterDetailWizard(true);
    }

    public static MasterDetailWizard createForExisting() {
        return new MasterDetailWizard(false);
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        if (this.delegateIterator != null) {
            this.delegateIterator.initialize(wizard);
        }
        this.panelIndex = 0;
        this.panels = this.createPanels();
    }

    private WizardDescriptor.Panel[] createPanels() {
        this.panels = new WizardDescriptor.Panel[]{new MasterPanel(this.delegateIterator == null), new DetailPanel()};
        return this.panels;
    }

    public WizardDescriptor.Panel current() {
        String title = NbBundle.getMessage(MasterDetailWizard.class, (String)"TITLE_MasterDetail");
        this.wizard.putProperty("NewFileWizard_Title", (Object)title);
        if (this.steps == null) {
            this.initSteps();
        }
        WizardDescriptor.Panel panel = this.panelIndex < this.beforeStepsNo ? this.delegateIterator.current() : this.panels[this.panelIndex - this.beforeStepsNo];
        JComponent comp = (JComponent)panel.getComponent();
        if (this.panelIndex < this.beforeStepsNo || comp.getClientProperty(WIZARD_PANEL_CONTENT_DATA) == null) {
            comp.putClientProperty(WIZARD_PANEL_CONTENT_DATA, this.steps);
        }
        if (comp.getClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX) == null) {
            comp.putClientProperty(WIZARD_PANEL_CONTENT_SELECTED_INDEX, this.panelIndex);
        }
        return panel;
    }

    private void initSteps() {
        int stepsStartPos;
        String[] beforeSteps;
        Object prop;
        String[] thisSteps = new String[]{NbBundle.getMessage(MasterDetailWizard.class, (String)"TITLE_MasterPanel"), NbBundle.getMessage(MasterDetailWizard.class, (String)"TITLE_DetailPanel")};
        if (this.delegateIterator != null) {
            JComponent comp = (JComponent)this.delegateIterator.current().getComponent();
            prop = comp.getClientProperty(WIZARD_PANEL_CONTENT_DATA);
        } else {
            prop = null;
        }
        if (prop instanceof String[]) {
            beforeSteps = (String[])prop;
            this.beforeStepsNo = beforeSteps.length;
            stepsStartPos = beforeSteps.length;
            if (stepsStartPos > 0 && "...".equals(beforeSteps[stepsStartPos - 1])) {
                --stepsStartPos;
            }
        } else {
            this.beforeStepsNo = 0;
            beforeSteps = null;
            stepsStartPos = 0;
        }
        this.steps = new String[stepsStartPos + thisSteps.length];
        if (beforeSteps != null) {
            System.arraycopy(beforeSteps, 0, this.steps, 0, stepsStartPos);
        }
        System.arraycopy(thisSteps, 0, this.steps, stepsStartPos, thisSteps.length);
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public boolean hasNext() {
        if (this.panelIndex + 1 < this.beforeStepsNo && !this.delegateIterator.hasNext()) {
            this.beforeStepsNo = this.panelIndex + 1;
        }
        return this.panelIndex + 1 < this.beforeStepsNo + this.panels.length;
    }

    public boolean hasPrevious() {
        return this.panelIndex > 0;
    }

    public void nextPanel() {
        ++this.panelIndex;
        if (this.panelIndex < this.beforeStepsNo) {
            this.delegateIterator.nextPanel();
        }
    }

    public void previousPanel() {
        --this.panelIndex;
        if (this.panelIndex < this.beforeStepsNo - 1) {
            this.delegateIterator.previousPanel();
        }
    }

    public Set instantiate() throws IOException {
        final IOException[] ex = new IOException[1];
        String msgKey = this.delegateIterator == null ? "MSG_DBAppCreate" : "MSG_MasterDetailCreate";
        String msg = NbBundle.getMessage(MasterDetailWizard.class, (String)msgKey);
        Set set = (Set)ProgressUtils.showProgressDialogAndRun((ProgressRunnable)new ProgressRunnable<Set>(){

            public Set run(ProgressHandle handle) {
                Set innerSet = null;
                try {
                    innerSet = MasterDetailWizard.this.instantiate0();
                }
                catch (IOException ioex) {
                    ex[0] = ioex;
                }
                return innerSet;
            }
        }, (String)msg, (boolean)false);
        if (ex[0] != null) {
            throw ex[0];
        }
        return set;
    }

    public Set instantiate0() throws IOException {
        FileObject javaFile;
        LogRecord rec;
        Logger logger;
        this.needClassPathInit = this.delegateIterator == null;
        HashSet<FileObject> resultSet = null;
        DatabaseConnection connection = (DatabaseConnection)this.wizard.getProperty("connection");
        String masterTableName = (String)this.wizard.getProperty("master");
        String detailFKTable = (String)this.wizard.getProperty("detailFKTable");
        this.joinColumn = (String)this.wizard.getProperty("detailFKColumn");
        this.referencedColumn = (String)this.wizard.getProperty("detailPKColumn");
        if (this.delegateIterator == null) {
            logger = Logger.getLogger("org.netbeans.ui.metrics.swingapp");
            rec = new LogRecord(Level.INFO, "USG_PROJECT_CREATE_JDA");
            rec.setLoggerName(logger.getName());
            rec.setParameters(new Object[]{"JDA_APP_TYPE_CRUD"});
            logger.log(rec);
        } else {
            logger = Logger.getLogger("org.netbeans.ui.metrics.form.j2ee");
            rec = new LogRecord(Level.INFO, "USG_FORM_CREATED");
            rec.setLoggerName(logger.getName());
            rec.setParameters(new Object[]{Templates.getTemplate((WizardDescriptor)this.wizard).getName()});
            logger.log(rec);
        }
        if (this.delegateIterator != null) {
            resultSet = this.delegateIterator.instantiate();
            javaFile = (FileObject)resultSet.iterator().next();
        } else {
            resultSet = new HashSet<FileObject>();
            javaFile = (FileObject)this.wizard.getProperty("mainForm");
            resultSet.add(javaFile);
        }
        javaFile.setAttribute("justCreatedByNewWizard", (Object)Boolean.TRUE);
        DataObject dob = DataObject.find((FileObject)javaFile);
        FileObject formFile = FileUtil.findBrother((FileObject)dob.getPrimaryFile(), (String)"form");
        String[][] entity = this.instantiatePersitence(javaFile.getParent(), connection, masterTableName, detailFKTable);
        if (entity[0] == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "WARNING: Cannot find entity: {0}", masterTableName);
            entity[0] = new String[]{"Object", Object.class.getName()};
        }
        if (detailFKTable != null && entity[1] == null) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "WARNING: Cannot find entity: {0}", detailFKTable);
            entity[1] = new String[]{"Object", Object.class.getName()};
        }
        String masterClass = entity[0][1];
        String masterEntity = entity[0][0];
        String detailClass = null;
        String detailEntity = null;
        if (entity[1] != null) {
            detailClass = entity[1][1];
            detailEntity = entity[1][0];
        }
        MasterDetailGenerator generator = new MasterDetailGenerator(formFile, javaFile, masterClass, detailClass, masterEntity, detailEntity, this.joinInfo == null ? null : this.joinInfo[0], this.joinInfo == null ? null : this.joinInfo[1], this.unitName);
        List masterColumnNames = (List)this.wizard.getProperty("masterColumns");
        List<String> masterColumns = J2EEUtils.propertiesForColumns(this.mappings, masterEntity, masterColumnNames);
        generator.setMasterColumns(masterColumns);
        List<String> masterColumnTypes = J2EEUtils.typesOfProperties(javaFile, masterClass, masterColumns);
        generator.setMasterColumnTypes(masterColumnTypes);
        List detailColumnNames = (List)this.wizard.getProperty("detailColumns");
        List<String> detailColumns = J2EEUtils.propertiesForColumns(this.mappings, detailEntity == null ? masterEntity : detailEntity, detailColumnNames);
        generator.setDetailColumns(detailColumns);
        if (detailClass != null) {
            List<String> detailColumnTypes = J2EEUtils.typesOfProperties(javaFile, detailClass, detailColumns);
            generator.setDetailColumnTypes(detailColumnTypes);
        }
        generator.generate();
        return resultSet;
    }

    private String[][] instantiatePersitence(FileObject folder, DatabaseConnection connection, String tableName, String detailTable) {
        Project project = FileOwnerQuery.getOwner((FileObject)folder);
        try {
            FileObject persistenceXML = J2EEUtils.getPersistenceXML(project, true);
            PersistenceUnit unit = J2EEUtils.initPersistenceUnit(persistenceXML, connection);
            this.unitName = unit.getName();
            JDBCDriver[] driver = JDBCDriverManager.getDefault().getDrivers(connection.getDriverClass());
            J2EEUtils.updateProjectForUnit(folder, unit, driver[0]);
            PersistenceScope scope = PersistenceScope.getPersistenceScope((FileObject)folder);
            this.mappings = scope.getEntityMappingsModel(unit.getName());
            this.preinitJavaInfrastructure();
            String[] relatedTables = null;
            String[] tables = new String[1];
            if (detailTable == null) {
                tables[0] = tableName;
            } else {
                tables[0] = detailTable;
                String[] entityInfo = J2EEUtils.findEntity(this.mappings, detailTable);
                if (entityInfo != null) {
                    tables[0] = tableName;
                } else {
                    entityInfo = J2EEUtils.findEntity(this.mappings, tableName);
                    if (entityInfo == null) {
                        relatedTables = new String[]{tableName};
                    }
                }
            }
            for (String table : tables) {
                String[] entityInfo = J2EEUtils.findEntity(this.mappings, table);
                if (entityInfo == null) {
                    J2EEUtils.createEntity(folder, scope, unit, connection, table, relatedTables);
                    continue;
                }
                J2EEUtils.addEntityToUnit(entityInfo[1], unit, project);
            }
            String[][] result = new String[2][];
            result[0] = J2EEUtils.findEntity(this.mappings, tableName);
            if (detailTable != null) {
                result[1] = J2EEUtils.findEntity(this.mappings, detailTable);
                if (result[0] != null && result[1] != null) {
                    this.joinInfo = MasterDetailWizard.findOneToManyRelationProperties(this.mappings, result[0][0], result[1][0], this.joinColumn);
                    if (this.joinInfo == null || this.joinInfo[1] == null) {
                        boolean anotherDetailFieldExists = !J2EEUtils.propertiesForColumns(this.mappings, result[1][0], Collections.singletonList(this.joinColumn)).isEmpty();
                        MasterDetailWizard.addRelationship(result[0], result[1], this.joinColumn, this.referencedColumn, this.joinInfo == null ? null : this.joinInfo[0], anotherDetailFieldExists, folder);
                        this.joinInfo = MasterDetailWizard.findOneToManyRelationProperties(this.mappings, result[0][0], result[1][0], this.joinColumn);
                    }
                }
            }
            J2EEUtils.makeEntityObservable(folder, result[0], this.mappings);
            if (detailTable != null) {
                J2EEUtils.makeEntityObservable(folder, result[1], this.mappings);
            }
            return result;
        }
        catch (IOException ioex) {
            Logger.getLogger(MasterDetailWizard.class.getName()).log(Level.INFO, null, ioex);
        }
        catch (InvalidPersistenceXmlException ipxex) {
            Logger.getLogger(MasterDetailWizard.class.getName()).log(Level.INFO, null, ipxex);
        }
        return null;
    }

    private void preinitJavaInfrastructure() throws IOException {
        if (this.needClassPathInit) {
            try {
                ClasspathInfo cpInfo = (ClasspathInfo)this.mappings.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, ClasspathInfo>(){

                    public ClasspathInfo run(EntityMappingsMetadata metadata) {
                        return metadata.createJavaSource().getClasspathInfo();
                    }
                }).get();
                GlobalPathRegistry.getDefault().register("classpath/boot", new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.BOOT)});
                GlobalPathRegistry.getDefault().register("classpath/compile", new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.COMPILE)});
                GlobalPathRegistry.getDefault().register("classpath/source", new ClassPath[]{cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE)});
            }
            catch (InterruptedException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            catch (MetadataModelException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
        }
    }

    public void uninitialize(WizardDescriptor wizard) {
        if (this.delegateIterator != null) {
            this.delegateIterator.uninitialize(wizard);
        }
    }

    public void addChangeListener(ChangeListener listener) {
    }

    public void removeChangeListener(ChangeListener listener) {
    }

    private static String[] findOneToManyRelationProperties(MetadataModel<EntityMappingsMetadata> mappings, final String masterEntityName, final String detailEntityName, final String relationColumn) throws IOException {
        String[] properties = null;
        try {
            properties = (String[])mappings.runReadActionWhenReady((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, String[]>(){

                public String[] run(EntityMappingsMetadata metadata) {
                    Entity[] entities = metadata.getRoot().getEntity();
                    Entity masterEntity = null;
                    Entity detailEntity = null;
                    for (int i = 0; i < entities.length; ++i) {
                        String entityName = entities[i].getName();
                        if (masterEntityName.equals(entityName)) {
                            masterEntity = entities[i];
                        }
                        if (!detailEntityName.equals(entityName)) continue;
                        detailEntity = entities[i];
                    }
                    String relationField = null;
                    for (ManyToOne manyToOne : detailEntity.getAttributes().getManyToOne()) {
                        JoinColumn[] joinColumn = manyToOne.getJoinColumn();
                        String columnName = joinColumn.length == 0 ? manyToOne.getName().toUpperCase() + "_ID" : manyToOne.getJoinColumn(0).getName();
                        if (!relationColumn.equals(columnName)) continue;
                        relationField = manyToOne.getName();
                        break;
                    }
                    if (relationField != null) {
                        for (ManyToOne manyToOne : masterEntity.getAttributes().getOneToMany()) {
                            String targetEntity = manyToOne.getTargetEntity();
                            int index = targetEntity.lastIndexOf(46);
                            if (index != -1) {
                                targetEntity = targetEntity.substring(index + 1);
                            }
                            if (!detailEntityName.equals(targetEntity) || !relationField.equals(manyToOne.getMappedBy())) continue;
                            return new String[]{J2EEUtils.fieldToProperty(relationField), J2EEUtils.fieldToProperty(manyToOne.getName())};
                        }
                        return new String[]{J2EEUtils.fieldToProperty(relationField), null};
                    }
                    return null;
                }
            }).get();
        }
        catch (InterruptedException iex) {
            Logger.getLogger(MasterDetailWizard.class.getName()).log(Level.INFO, iex.getMessage(), iex);
        }
        catch (ExecutionException eex) {
            Logger.getLogger(MasterDetailWizard.class.getName()).log(Level.INFO, eex.getMessage(), eex);
        }
        return properties;
    }

    private static void addRelationship(final String[] masterInfo, final String[] detailInfo, final String joinColumn, final String referencedColumn, String detailField, final boolean anotherDetailFieldExists, FileObject fileInProject) {
        String masterJava;
        FileObject masterFob;
        JavaSource source;
        ClassPath cp = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/source");
        final String[] df = new String[]{detailField};
        if (df[0] == null) {
            String detailJava = detailInfo[1].replace('.', '/') + ".java";
            FileObject detailFob = cp.findResource(detailJava);
            if (detailFob == null) {
                return;
            }
            source = JavaSource.forFileObject((FileObject)detailFob);
            try {
                source.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                    public void run(WorkingCopy wc) throws Exception {
                        int n;
                        wc.toPhase(JavaSource.Phase.RESOLVED);
                        CompilationUnitTree cu = wc.getCompilationUnit();
                        ClassTree clazz = null;
                        for (Tree tree : cu.getTypeDecls()) {
                            ClassTree candidate;
                            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(candidate = (ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                            clazz = candidate;
                            break;
                        }
                        int idx = 0;
                        boolean bl = false;
                        HashSet<String> methods = new HashSet<String>();
                        HashSet<String> fields = new HashSet<String>();
                        for (Tree tree : clazz.getMembers()) {
                            ++idx;
                            if (Tree.Kind.VARIABLE == tree.getKind()) {
                                VariableTree variable = (VariableTree)tree;
                                fields.add(variable.getName().toString());
                                n = idx;
                                continue;
                            }
                            if (Tree.Kind.METHOD != tree.getKind()) continue;
                            MethodTree method = (MethodTree)tree;
                            methods.add(method.getName().toString());
                        }
                        StringBuilder sb = new StringBuilder();
                        boolean bl2 = false;
                        for (int i = 0; i < joinColumn.length(); ++i) {
                            boolean bl3;
                            char c = joinColumn.charAt(i);
                            if (c == '_') {
                                bl3 = true;
                                continue;
                            }
                            c = bl3 ? Character.toUpperCase(c) : Character.toLowerCase(c);
                            sb.append(c);
                            bl3 = false;
                        }
                        String detailFieldName = sb.toString();
                        String detailMethodSuffix = Character.toUpperCase(detailFieldName.charAt(0)) + detailFieldName.substring(1);
                        String candFieldName = detailFieldName;
                        String candMethodSuffix = detailMethodSuffix;
                        int count = 1;
                        boolean ok = false;
                        while (!ok) {
                            ok = !fields.contains(candFieldName);
                            ok = ok && !methods.contains("set" + candMethodSuffix);
                            if (ok = ok && !methods.contains("get" + candMethodSuffix)) continue;
                            candFieldName = detailFieldName + ++count;
                            candMethodSuffix = detailMethodSuffix + count;
                        }
                        detailFieldName = candFieldName;
                        detailMethodSuffix = candMethodSuffix;
                        df[0] = detailFieldName;
                        TreeMaker make = wc.getTreeMaker();
                        AssignmentTree nameParameter = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"name"), (ExpressionTree)make.Literal((Object)joinColumn));
                        AssignmentTree referencedParameter = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"referencedColumnName"), (ExpressionTree)make.Literal((Object)referencedColumn));
                        ArrayList<AssignmentTree> parameters = new ArrayList<AssignmentTree>();
                        parameters.add(nameParameter);
                        parameters.add(referencedParameter);
                        if (anotherDetailFieldExists) {
                            AssignmentTree updatableParameter = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"updatable"), (ExpressionTree)make.Identifier((CharSequence)"false"));
                            AssignmentTree insertableParameter = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"insertable"), (ExpressionTree)make.Identifier((CharSequence)"false"));
                            parameters.add(updatableParameter);
                            parameters.add(insertableParameter);
                        }
                        TypeElement joinColumnElement = wc.getElements().getTypeElement("javax.persistence.JoinColumn");
                        AnnotationTree joinColumnTree = make.Annotation((Tree)make.QualIdent((Element)joinColumnElement), parameters);
                        TypeElement manyToOneElement = wc.getElements().getTypeElement("javax.persistence.ManyToOne");
                        AnnotationTree manyToOneTree = make.Annotation((Tree)make.QualIdent((Element)manyToOneElement), Collections.EMPTY_LIST);
                        ArrayList<AnnotationTree> annotations = new ArrayList<AnnotationTree>(2);
                        annotations.add(joinColumnTree);
                        annotations.add(manyToOneTree);
                        ModifiersTree modifiers = make.Modifiers(Collections.singleton(Modifier.PRIVATE), annotations);
                        TypeElement masterElement = wc.getElements().getTypeElement(masterInfo[1]);
                        VariableTree field = make.Variable(modifiers, (CharSequence)detailFieldName, (Tree)make.QualIdent((Element)masterElement), null);
                        ClassTree modifiedClass = make.insertClassMember(clazz, n, (Tree)field);
                        wc.rewrite((Tree)clazz, (Tree)modifiedClass);
                        ReturnTree returnExp = make.Return((ExpressionTree)make.Identifier((CharSequence)detailFieldName));
                        MethodTree getMethod = make.Method(make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.EMPTY_LIST), (CharSequence)("get" + detailMethodSuffix), (Tree)make.QualIdent((Element)masterElement), Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, make.Block(Collections.singletonList(returnExp), false), null);
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)getMethod);
                        wc.rewrite((Tree)clazz, (Tree)modifiedClass);
                        ModifiersTree parMods = make.Modifiers(Collections.EMPTY_SET, Collections.EMPTY_LIST);
                        VariableTree par = make.Variable(parMods, (CharSequence)detailFieldName, (Tree)make.QualIdent((Element)masterElement), null);
                        AssignmentTree assignExp = make.Assignment((ExpressionTree)make.Identifier((CharSequence)("this." + detailFieldName)), (ExpressionTree)make.Identifier((CharSequence)detailFieldName));
                        MethodTree setMethod = make.Method(make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.EMPTY_LIST), (CharSequence)("set" + detailMethodSuffix), (Tree)make.PrimitiveType(TypeKind.VOID), Collections.EMPTY_LIST, Collections.singletonList(par), Collections.EMPTY_LIST, make.Block(Collections.singletonList(make.ExpressionStatement((ExpressionTree)assignExp)), false), null);
                        modifiedClass = make.addClassMember(modifiedClass, (Tree)setMethod);
                        wc.rewrite((Tree)clazz, (Tree)modifiedClass);
                    }

                    public void cancel() {
                    }
                }).commit();
            }
            catch (IOException ioex) {
                Logger.getLogger(MasterDetailWizard.class.getName()).log(Level.INFO, ioex.getMessage(), ioex);
            }
        }
        if ((masterFob = cp.findResource(masterJava = masterInfo[1].replace('.', '/') + ".java")) == null) {
            return;
        }
        source = JavaSource.forFileObject((FileObject)masterFob);
        try {
            source.runModificationTask((Task)new CancellableTask<WorkingCopy>(){

                public void run(WorkingCopy wc) throws Exception {
                    int n;
                    wc.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree cu = wc.getCompilationUnit();
                    ClassTree clazz = null;
                    for (Tree tree : cu.getTypeDecls()) {
                        ClassTree candidate;
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(candidate = (ClassTree)tree).getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                        clazz = candidate;
                        break;
                    }
                    int idx = 0;
                    boolean bl = false;
                    HashSet<String> methods = new HashSet<String>();
                    HashSet<String> fields = new HashSet<String>();
                    for (Tree tree : clazz.getMembers()) {
                        ++idx;
                        if (Tree.Kind.VARIABLE == tree.getKind()) {
                            VariableTree variable = (VariableTree)tree;
                            fields.add(variable.getName().toString());
                            n = idx;
                            continue;
                        }
                        if (Tree.Kind.METHOD != tree.getKind()) continue;
                        MethodTree method = (MethodTree)tree;
                        methods.add(method.getName().toString());
                    }
                    String masterFieldName = detailInfo[0] + "Collection";
                    masterFieldName = Character.toLowerCase(masterFieldName.charAt(0)) + masterFieldName.substring(1);
                    String string = Character.toUpperCase(masterFieldName.charAt(0)) + masterFieldName.substring(1);
                    String candFieldName = masterFieldName;
                    String candMethodSuffix = string;
                    int count = 1;
                    boolean ok = false;
                    while (!ok) {
                        ok = !fields.contains(candFieldName);
                        ok = ok && !methods.contains("set" + candMethodSuffix);
                        if (ok = ok && !methods.contains("get" + candMethodSuffix)) continue;
                        candFieldName = masterFieldName + ++count;
                        candMethodSuffix = string + count;
                    }
                    masterFieldName = candFieldName;
                    String string2 = candMethodSuffix;
                    TreeMaker make = wc.getTreeMaker();
                    TypeElement cascadeTypeElement = wc.getElements().getTypeElement("javax.persistence.CascadeType");
                    AssignmentTree cascadeParameter = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"cascade"), (ExpressionTree)make.MemberSelect(make.QualIdent((Element)cascadeTypeElement), (CharSequence)"ALL"));
                    AssignmentTree mappedByParameter = make.Assignment((ExpressionTree)make.Identifier((CharSequence)"mappedBy"), (ExpressionTree)make.Literal((Object)df[0]));
                    ArrayList<AssignmentTree> parameters = new ArrayList<AssignmentTree>();
                    parameters.add(cascadeParameter);
                    parameters.add(mappedByParameter);
                    TypeElement oneToManyElement = wc.getElements().getTypeElement("javax.persistence.OneToMany");
                    AnnotationTree oneToManyTree = make.Annotation((Tree)make.QualIdent((Element)oneToManyElement), parameters);
                    ModifiersTree modifiers = make.Modifiers(Collections.singleton(Modifier.PRIVATE), Collections.singletonList(oneToManyTree));
                    TypeElement collectionElement = wc.getElements().getTypeElement("java.util.Collection");
                    TypeElement detailElement = wc.getElements().getTypeElement(detailInfo[1]);
                    ParameterizedTypeTree collectionTree = make.ParameterizedType((Tree)make.QualIdent((Element)collectionElement), Collections.singletonList(make.QualIdent((Element)detailElement)));
                    VariableTree field = make.Variable(modifiers, (CharSequence)masterFieldName, (Tree)collectionTree, null);
                    ClassTree modifiedClass = make.insertClassMember(clazz, n, (Tree)field);
                    wc.rewrite((Tree)clazz, (Tree)modifiedClass);
                    ReturnTree returnExp = make.Return((ExpressionTree)make.Identifier((CharSequence)masterFieldName));
                    MethodTree getMethod = make.Method(make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.EMPTY_LIST), (CharSequence)("get" + string2), (Tree)collectionTree, Collections.EMPTY_LIST, Collections.EMPTY_LIST, Collections.EMPTY_LIST, make.Block(Collections.singletonList(returnExp), false), null);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)getMethod);
                    wc.rewrite((Tree)clazz, (Tree)modifiedClass);
                    ModifiersTree parMods = make.Modifiers(Collections.EMPTY_SET, Collections.EMPTY_LIST);
                    VariableTree par = make.Variable(parMods, (CharSequence)masterFieldName, (Tree)collectionTree, null);
                    AssignmentTree assignExp = make.Assignment((ExpressionTree)make.Identifier((CharSequence)("this." + masterFieldName)), (ExpressionTree)make.Identifier((CharSequence)masterFieldName));
                    MethodTree setMethod = make.Method(make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.EMPTY_LIST), (CharSequence)("set" + string2), (Tree)make.PrimitiveType(TypeKind.VOID), Collections.EMPTY_LIST, Collections.singletonList(par), Collections.EMPTY_LIST, make.Block(Collections.singletonList(make.ExpressionStatement((ExpressionTree)assignExp)), false), null);
                    modifiedClass = make.addClassMember(modifiedClass, (Tree)setMethod);
                    wc.rewrite((Tree)clazz, (Tree)modifiedClass);
                }

                public void cancel() {
                }
            }).commit();
        }
        catch (IOException ioex) {
            Logger.getLogger(MasterDetailWizard.class.getName()).log(Level.INFO, ioex.getMessage(), ioex);
        }
    }
}

