/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.object;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.object.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UpdatableSqlQuery<T>
extends SqlQuery<T> {
    public UpdatableSqlQuery() {
        this.setUpdatableResults(true);
    }

    public UpdatableSqlQuery(DataSource ds, String sql) {
        super(ds, sql);
        this.setUpdatableResults(true);
    }

    @Override
    protected RowMapper<T> newRowMapper(Object[] parameters, Map context) {
        return new RowMapperImpl(context);
    }

    protected abstract T updateRow(ResultSet var1, int var2, Map var3) throws SQLException;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class RowMapperImpl
    implements RowMapper<T> {
        private final Map context;

        public RowMapperImpl(Map context) {
            this.context = context;
        }

        @Override
        public T mapRow(ResultSet rs, int rowNum) throws SQLException {
            Object result = UpdatableSqlQuery.this.updateRow(rs, rowNum, this.context);
            rs.updateRow();
            return result;
        }
    }
}

