/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.impl;

import org.clang.basic.SanitizerKind;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchULong;

public final class SanitizersClangGlobals {
    public static long parseSanitizerValue(StringRef Value, boolean AllowGroups) {
        long ParsedKind = new StringSwitchULong(Value).Case("address", SanitizerKind.Address).Case("kernel-address", SanitizerKind.KernelAddress).Case("memory", SanitizerKind.Memory).Case("thread", SanitizerKind.Thread).Case("leak", SanitizerKind.Leak).Case("alignment", SanitizerKind.Alignment).Case("array-bounds", SanitizerKind.ArrayBounds).Case("bool", SanitizerKind.Bool).Case("enum", SanitizerKind.Enum).Case("float-cast-overflow", SanitizerKind.FloatCastOverflow).Case("float-divide-by-zero", SanitizerKind.FloatDivideByZero).Case("function", SanitizerKind.Function).Case("integer-divide-by-zero", SanitizerKind.IntegerDivideByZero).Case("nonnull-attribute", SanitizerKind.NonnullAttribute).Case("null", SanitizerKind.Null).Case("object-size", SanitizerKind.ObjectSize).Case("return", SanitizerKind.Return).Case("returns-nonnull-attribute", SanitizerKind.ReturnsNonnullAttribute).Case("shift-base", SanitizerKind.ShiftBase).Case("shift-exponent", SanitizerKind.ShiftExponent).Case("shift", AllowGroups ? SanitizerKind.ShiftGroup : 0L).Case("signed-integer-overflow", SanitizerKind.SignedIntegerOverflow).Case("unreachable", SanitizerKind.Unreachable).Case("vla-bound", SanitizerKind.VLABound).Case("vptr", SanitizerKind.Vptr).Case("unsigned-integer-overflow", SanitizerKind.UnsignedIntegerOverflow).Case("dataflow", SanitizerKind.DataFlow).Case("cfi-cast-strict", SanitizerKind.CFICastStrict).Case("cfi-derived-cast", SanitizerKind.CFIDerivedCast).Case("cfi-icall", SanitizerKind.CFIICall).Case("cfi-unrelated-cast", SanitizerKind.CFIUnrelatedCast).Case("cfi-nvcall", SanitizerKind.CFINVCall).Case("cfi-vcall", SanitizerKind.CFIVCall).Case("cfi", AllowGroups ? SanitizerKind.CFIGroup : 0L).Case("safe-stack", SanitizerKind.SafeStack).Case("undefined", AllowGroups ? SanitizerKind.UndefinedGroup : 0L).Case("undefined-trap", AllowGroups ? SanitizerKind.UndefinedTrapGroup : 0L).Case("integer", AllowGroups ? SanitizerKind.IntegerGroup : 0L).Case("local-bounds", SanitizerKind.LocalBounds).Case("bounds", AllowGroups ? SanitizerKind.BoundsGroup : 0L).Case("efficiency-cache-frag", SanitizerKind.EfficiencyCacheFrag).Case("efficiency-working-set", SanitizerKind.EfficiencyWorkingSet).Case("efficiency-all", AllowGroups ? SanitizerKind.EfficiencyGroup : 0L).Case("all", AllowGroups ? SanitizerKind.AllGroup : 0L).Default(0L);
        return ParsedKind;
    }

    public static long expandSanitizerGroups(long Kinds) {
        if ((Kinds & SanitizerKind.ShiftGroup) != 0L) {
            Kinds |= SanitizerKind.Shift;
        }
        if ((Kinds & SanitizerKind.CFIGroup) != 0L) {
            Kinds |= SanitizerKind.CFI;
        }
        if ((Kinds & SanitizerKind.UndefinedGroup) != 0L) {
            Kinds |= SanitizerKind.Undefined;
        }
        if ((Kinds & SanitizerKind.UndefinedTrapGroup) != 0L) {
            Kinds |= SanitizerKind.UndefinedTrap;
        }
        if ((Kinds & SanitizerKind.IntegerGroup) != 0L) {
            Kinds |= SanitizerKind.Integer;
        }
        if ((Kinds & SanitizerKind.BoundsGroup) != 0L) {
            Kinds |= SanitizerKind.Bounds;
        }
        if ((Kinds & SanitizerKind.EfficiencyGroup) != 0L) {
            Kinds |= SanitizerKind.Efficiency;
        }
        if ((Kinds & SanitizerKind.AllGroup) != 0L) {
            Kinds |= SanitizerKind.All;
        }
        return Kinds;
    }
}

