/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.debug.watchesfiltering;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Watch;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.web.debug.watchesfiltering.JspElWatch;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class JspWatchesTreeFilter
implements TreeModelFilter {
    private final JPDADebugger debugger;
    private final Map<Watch, JspElWatch> watch2JspElWatch = new HashMap<Watch, JspElWatch>();
    private DebuggerListener listener;

    public JspWatchesTreeFilter(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Object getRoot(TreeModel original) {
        return original.getRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        if (parent == original.getRoot()) {
            Watch[] allWatches = DebuggerManager.getDebuggerManager().getWatches();
            Object[] result = original.getChildren(parent, from, to);
            Object[] ch = new Object[result.length];
            System.arraycopy(result, 0, ch, 0, result.length);
            Map<Watch, JspElWatch> map = this.watch2JspElWatch;
            synchronized (map) {
                for (int i = from; i < allWatches.length; ++i) {
                    Watch w = allWatches[i];
                    String expression = w.getExpression();
                    if (!this.isJSPexpression(expression)) continue;
                    JspElWatch jw = this.watch2JspElWatch.get(w);
                    if (jw == null) {
                        jw = new JspElWatch(w, this.debugger);
                        this.watch2JspElWatch.put(w, jw);
                    }
                    ch[i - from] = jw;
                }
            }
            if (this.listener == null) {
                this.listener = new DebuggerListener(this, this.debugger);
            }
            return ch;
        }
        return original.getChildren(parent, from, to);
    }

    public int getChildrenCount(TreeModel original, Object node) throws UnknownTypeException {
        if (node == original.getRoot() && this.listener == null) {
            this.listener = new DebuggerListener(this, this.debugger);
        }
        return original.getChildrenCount(node);
    }

    public boolean isLeaf(TreeModel original, Object node) throws UnknownTypeException {
        if (node instanceof JspElWatch) {
            return true;
        }
        return original.isLeaf(node);
    }

    private boolean isJSPexpression(String expression) {
        return expression.startsWith("${") && expression.endsWith("}");
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireTreeChanged() {
        Map<Watch, JspElWatch> map = this.watch2JspElWatch;
        synchronized (map) {
            for (JspElWatch jspElWatch : this.watch2JspElWatch.values()) {
                jspElWatch.setUnevaluated();
            }
        }
    }

    private static class DebuggerListener
    implements PropertyChangeListener {
        WeakReference<JspWatchesTreeFilter> jspWatchesFilterRef;
        WeakReference<JPDADebugger> debuggerRef;

        DebuggerListener(JspWatchesTreeFilter jspWatchesFilter, JPDADebugger debugger) {
            this.jspWatchesFilterRef = new WeakReference<JspWatchesTreeFilter>(jspWatchesFilter);
            this.debuggerRef = new WeakReference<JPDADebugger>(debugger);
            debugger.addPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (((JPDADebugger)this.debuggerRef.get()).getState() == 4) {
                this.destroy();
                return;
            }
            if (((JPDADebugger)this.debuggerRef.get()).getState() == 2) {
                return;
            }
            JspWatchesTreeFilter jspWatchesFilter = this.getJspWatchesFilter();
            if (jspWatchesFilter != null) {
                jspWatchesFilter.fireTreeChanged();
            }
        }

        private JspWatchesTreeFilter getJspWatchesFilter() {
            JspWatchesTreeFilter jspWatchesFilter = (JspWatchesTreeFilter)this.jspWatchesFilterRef.get();
            if (jspWatchesFilter == null) {
                this.destroy();
            }
            return jspWatchesFilter;
        }

        private void destroy() {
            JPDADebugger debugger = (JPDADebugger)this.debuggerRef.get();
            if (debugger != null) {
                debugger.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }
}

