/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.languages;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.CompletionItem;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public abstract class LibrarySupport {
    public static LibrarySupport create(String resourceName) {
        return new LibraryImpl(resourceName);
    }

    public static LibrarySupport create(List<String> resourceNames) {
        return new DelegatingLibrarySupport(resourceNames);
    }

    public abstract List<String> getItems(String var1);

    public abstract List<CompletionItem> getCompletionItems(String var1);

    public abstract String getProperty(String var1, String var2, String var3);

    static class DelegatingLibrarySupport
    extends LibrarySupport {
        private List<LibrarySupport> libraries = new ArrayList<LibrarySupport>();

        DelegatingLibrarySupport(List<String> resources) {
            for (String resource : resources) {
                this.libraries.add(new LibraryImpl(resource));
            }
        }

        @Override
        public List<String> getItems(String context) {
            ArrayList<String> result = new ArrayList<String>();
            for (LibrarySupport librarySupport : this.libraries) {
                result.addAll(librarySupport.getItems(context));
            }
            return result;
        }

        @Override
        public List<CompletionItem> getCompletionItems(String context) {
            ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
            for (LibrarySupport librarySupport : this.libraries) {
                result.addAll(librarySupport.getCompletionItems(context));
            }
            return result;
        }

        @Override
        public String getProperty(String context, String item, String propertyName) {
            for (LibrarySupport librarySupport : this.libraries) {
                String result = librarySupport.getProperty(context, item, propertyName);
                if (result == null) continue;
                return result;
            }
            return null;
        }
    }

    static class Handler
    extends DefaultHandler {
        Map<String, Map<String, List<Map<String, String>>>> result = new HashMap<String, Map<String, List<Map<String, String>>>>();

        Handler() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            try {
                if (name.equals("node")) {
                    int i;
                    String contexts = attributes.getValue("context");
                    String key = attributes.getValue("key");
                    HashMap<String, String> properties = null;
                    if (attributes.getLength() > 2) {
                        properties = new HashMap<String, String>();
                        int k = attributes.getLength();
                        for (i = 0; i < k; ++i) {
                            String propertyName = attributes.getQName(i);
                            if ("context".equals(propertyName) || "key".equals(propertyName)) continue;
                            properties.put(propertyName, attributes.getValue(i));
                        }
                    }
                    while (true) {
                        List<Map<String, String>> entries;
                        String context;
                        Map<String, List<Map<String, String>>> names;
                        if ((names = this.result.get(context = (i = contexts.indexOf(44)) >= 0 ? contexts.substring(0, i).trim() : contexts)) == null) {
                            names = new HashMap<String, List<Map<String, String>>>();
                            this.result.put(context, names);
                        }
                        if ((entries = names.get(key)) == null) {
                            entries = new ArrayList<Map<String, String>>();
                            names.put(key, entries);
                        }
                        entries.add(properties);
                        if (i >= 0) {
                            contexts = contexts.substring(i + 1);
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }

        @Override
        public InputSource resolveEntity(String pubid, String sysid) {
            return new InputSource(new ByteArrayInputStream(new byte[0]));
        }
    }

    private static class LibraryImpl
    extends LibrarySupport {
        private String resourceName;
        private Map<String, List<String>> keys = new HashMap<String, List<String>>();
        private Map<String, Map<String, List<Map<String, String>>>> items;

        LibraryImpl(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public List<String> getItems(String context) {
            List<String> k = this.keys.get(context);
            if (k == null) {
                Map<String, List<Map<String, String>>> m = this.getItems().get(context);
                if (m == null) {
                    return null;
                }
                k = new ArrayList<String>(m.keySet());
                Collections.sort(k);
                k = Collections.unmodifiableList(k);
                this.keys.put(context, k);
            }
            return k;
        }

        @Override
        public List<CompletionItem> getCompletionItems(String context) {
            ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
            Map<String, List<Map<String, String>>> items = this.getItems().get(context);
            if (items == null) {
                return result;
            }
            for (String name : items.keySet()) {
                List<Map<String, String>> items2 = items.get(name);
                for (Map<String, String> properties : items2) {
                    CompletionItem.Type type = null;
                    String stype = properties.get("type");
                    if ("class".equals(stype)) {
                        type = CompletionItem.Type.CLASS;
                    } else if ("field".equals(stype)) {
                        type = CompletionItem.Type.FIELD;
                    } else if ("constant".equals(stype)) {
                        type = CompletionItem.Type.CONSTANT;
                    } else if ("constructor".equals(stype)) {
                        type = CompletionItem.Type.CONSTRUCTOR;
                    } else if ("interface".equals(stype)) {
                        type = CompletionItem.Type.INTERFACE;
                    } else if ("keyword".equals(stype)) {
                        type = CompletionItem.Type.KEYWORD;
                    } else if ("local".equals(stype)) {
                        type = CompletionItem.Type.LOCAL;
                    } else if ("method".equals(stype)) {
                        type = CompletionItem.Type.METHOD;
                    } else if ("parameter".equals(stype)) {
                        type = CompletionItem.Type.PARAMETER;
                    }
                    result.add(CompletionItem.create(name, properties.get("description"), properties.get("library"), type, 200));
                }
            }
            return result;
        }

        @Override
        public String getProperty(String context, String item, String propertyName) {
            Map<String, List<Map<String, String>>> m = this.getItems().get(context);
            if (m == null) {
                return null;
            }
            List<Map<String, String>> l = m.get(item);
            if (l == null) {
                return null;
            }
            if (l.size() > 1) {
                throw new IllegalArgumentException();
            }
            return l.get(0).get(propertyName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Map<String, List<Map<String, String>>>> getItems() {
            if (this.items == null) {
                try {
                    XMLReader reader = XMLUtil.createXMLReader();
                    Handler handler = new Handler();
                    reader.setEntityResolver(handler);
                    reader.setContentHandler(handler);
                    ClassLoader loader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
                    InputStream is = loader.getResourceAsStream(this.resourceName);
                    try {
                        reader.parse(new InputSource(is));
                    }
                    finally {
                        is.close();
                    }
                    this.items = handler.result;
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                    this.items = Collections.emptyMap();
                }
            }
            return this.items;
        }
    }
}

