/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.core.support.java.method;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.support.java.method.ReturnTypeUIHelper;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class ParametersPanel
extends JPanel {
    private static final int COL_NAME_INDEX = 0;
    private static final int COL_TYPE_INDEX = 1;
    private static final int COL_FINAL_INDEX = 2;
    private static final String[] columnNames = new String[]{NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.LBL_Name"), NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.LBL_Type"), NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.LBL_Final")};
    public static final String SELECTION = "selection";
    private final ParamsTableModel tableModel;
    private JButton addButton;
    private JButton downButton;
    private JScrollPane jScrollPane1;
    private JButton removeButton;
    private JTable table;
    private JButton upButton;

    public ParametersPanel(ClasspathInfo cpInfo, List<MethodModel.Variable> parameters) {
        this.initComponents();
        this.tableModel = new ParamsTableModel(parameters);
        this.table.setModel(this.tableModel);
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ParametersPanel.this.firePropertyChange("parameters", null, null);
            }
        });
        if (parameters.isEmpty()) {
            this.table.setFocusable(false);
        }
        JComboBox typeCombo = new JComboBox();
        ReturnTypeUIHelper.connect(typeCombo, cpInfo);
        TableColumn typeTableColumn = this.table.getColumnModel().getColumn(1);
        typeTableColumn.setCellEditor(new DefaultCellEditor(typeCombo));
        typeCombo.addActionListener(new TypeComboListener(typeCombo));
        this.table.setRowHeight(typeCombo.getPreferredSize().height);
        this.table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ListSelectionListenerImpl listSelectionListener = new ListSelectionListenerImpl();
        this.table.getSelectionModel().addListSelectionListener(listSelectionListener);
        this.table.getColumnModel().getSelectionModel().addListSelectionListener(listSelectionListener);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ParametersPanel.this.updateButtons();
            }
        });
        this.table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ParametersPanel.this.updateButtons();
            }
        });
        this.updateButtons();
    }

    public List<MethodModel.Variable> getParameters() {
        return this.tableModel.getParameters();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.table.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.table);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParametersPanel.class, (String)"ACSN_ParametersTab"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_ParametersTab"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.addButton.text"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.removeButton.text"));
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.removeButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.upButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.upButton.text"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.upButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.downButton, (String)NbBundle.getMessage(ParametersPanel.class, (String)"ParametersPanel.downButton.text"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParametersPanel.this.downButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 241, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addButton).addComponent(this.removeButton).addComponent(this.upButton).addComponent(this.downButton)).addContainerGap()));
        layout.linkSize(0, this.addButton, this.downButton, this.removeButton, this.upButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton).addGap(22, 22, 22).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downButton)).addComponent(this.jScrollPane1, -1, 276, Short.MAX_VALUE)).addContainerGap()));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_AddParameterIntoTab"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_RemoveParameterIntoTab"));
        this.upButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_MoveUpInParamTab"));
        this.downButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParametersPanel.class, (String)"ACSD_MoveDownInParamTab"));
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.table.getSelectedRow();
        int newIndex = selIndex - 1;
        if (newIndex >= 0) {
            this.tableModel.set(newIndex, this.tableModel.set(selIndex, this.tableModel.getParameter(newIndex)));
            this.table.setRowSelectionInterval(newIndex, newIndex);
            this.updateButtons();
        }
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.table.getSelectedRow();
        int newIndex = selIndex + 1;
        if (newIndex < this.tableModel.getParameters().size()) {
            this.tableModel.set(newIndex, this.tableModel.set(selIndex, this.tableModel.getParameter(newIndex)));
            this.table.setRowSelectionInterval(newIndex, newIndex);
            this.updateButtons();
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow > -1) {
            this.tableModel.removeParameter(selectedRow);
        }
        if (selectedRow == this.table.getRowCount()) {
            --selectedRow;
        }
        this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        this.updateButtons();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        int index = this.tableModel.addParameter();
        this.table.getSelectionModel().setSelectionInterval(index, index);
        this.table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
        this.updateButtons();
    }

    private void updateButtons() {
        int selIndex = this.table.getSelectedRow();
        boolean oneSelected = this.table.getSelectedRowCount() == 1;
        this.removeButton.setEnabled(oneSelected);
        this.upButton.setEnabled(oneSelected && selIndex > 0);
        this.downButton.setEnabled(oneSelected && selIndex < this.tableModel.getRowCount() - 1);
    }

    private static String chooseType(Object aValue, String typeName) {
        if (!(aValue instanceof String)) {
            return "*";
        }
        String aValueString = ((String)aValue).trim();
        if (aValueString.equals("")) {
            return typeName;
        }
        return aValueString;
    }

    private static String chooseName(Object aValue, String name) {
        String aValueString = ((String)aValue).trim();
        if (aValueString.equals("")) {
            return name;
        }
        return aValueString;
    }

    private class TypeComboListener
    implements ActionListener {
        private JComboBox typeCombo;

        TypeComboListener(JComboBox combo) {
            this.typeCombo = combo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String typeInModel;
            int selectedRow = ParametersPanel.this.table.getSelectedRow();
            if (selectedRow >= 0 && "*".equals(typeInModel = ParametersPanel.this.tableModel.getValueAt(selectedRow, 1).toString()) && this.typeCombo.getSelectedItem() != null) {
                ParametersPanel.this.tableModel.setValueAt(this.typeCombo.getSelectedItem(), selectedRow, 1);
            }
        }
    }

    private class ListSelectionListenerImpl
    implements ListSelectionListener {
        private ListSelectionListenerImpl() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ParametersPanel.this.table.editCellAt(ParametersPanel.this.table.getSelectedRow(), ParametersPanel.this.table.getSelectedColumn());
            Component editor = ParametersPanel.this.table.getEditorComponent();
            if (editor instanceof JComboBox) {
                editor = ((JComboBox)editor).getEditor().getEditorComponent();
            }
            if (editor != null) {
                editor.requestFocus();
            }
            if (editor instanceof JTextComponent) {
                JTextComponent textComp = (JTextComponent)editor;
                textComp.selectAll();
            }
        }
    }

    static class ParamsTableModel
    extends AbstractTableModel {
        private final List<MethodModel.Variable> parameters;

        public ParamsTableModel(List<MethodModel.Variable> parameters) {
            this.parameters = new ArrayList<MethodModel.Variable>(parameters);
        }

        public List<MethodModel.Variable> getParameters() {
            return this.parameters;
        }

        public int addParameter() {
            String name = this.generateUniqueName("parameter");
            MethodModel.Variable parameter = MethodModel.Variable.create("java.lang.String", name, false);
            int index = this.parameters.size();
            this.parameters.add(parameter);
            this.fireTableRowsInserted(index, index);
            return index;
        }

        public void removeParameter(int index) {
            this.parameters.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public MethodModel.Variable getParameter(int index) {
            return this.parameters.get(index);
        }

        public MethodModel.Variable set(int index, MethodModel.Variable parameter) {
            return this.parameters.set(index, parameter);
        }

        @Override
        public int getRowCount() {
            return this.parameters.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int column) {
            MethodModel.Variable parameter;
            Object result = null;
            if (row >= 0 && (parameter = this.parameters.get(row)) != null) {
                switch (column) {
                    case 0: {
                        result = parameter.getName();
                        break;
                    }
                    case 1: {
                        result = parameter.getType();
                        break;
                    }
                    case 2: {
                        result = parameter.getFinalModifier();
                        break;
                    }
                }
            }
            return result;
        }

        @Override
        public String getColumnName(int column) {
            return columnNames[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            String insertedName;
            if (column == 0 && !Utilities.isJavaIdentifier((String)(insertedName = (String)aValue).trim())) {
                return;
            }
            MethodModel.Variable parameter = this.parameters.get(row);
            MethodModel.Variable changedParameter = MethodModel.Variable.create(column == 1 ? ParametersPanel.chooseType(aValue, parameter.getType()) : parameter.getType(), column == 0 ? ParametersPanel.chooseName(aValue, parameter.getName()) : parameter.getName(), column == 2 ? ((Boolean)aValue).booleanValue() : parameter.getFinalModifier());
            this.parameters.set(row, changedParameter);
            this.fireTableCellUpdated(row, column);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        private String generateUniqueName(String name) {
            ArrayList<Integer> numberSuffixes = new ArrayList<Integer>();
            for (MethodModel.Variable variable : this.parameters) {
                String suffix;
                if (name.equals(variable.getName()) || !variable.getName().startsWith(name) || !this.isNumber(suffix = variable.getName().substring(name.length()))) continue;
                numberSuffixes.add(Integer.parseInt(suffix));
            }
            Collections.sort(numberSuffixes);
            String result = name;
            if (numberSuffixes.size() > 0) {
                int newSuffix = (Integer)numberSuffixes.get(numberSuffixes.size() - 1) + 1;
                result = name + newSuffix;
            } else if (this.parameters.size() > 0) {
                result = name + 1;
            }
            return result;
        }

        private boolean isNumber(String value) {
            for (char character : value.toCharArray()) {
                if (Character.isDigit(character)) continue;
                return false;
            }
            return true;
        }
    }
}

