/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.ui;

import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.modules.project.ui.convertor.ProjectConvertorAcceptor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public interface ProjectConvertor {
    @CheckForNull
    public Result isProject(@NonNull FileObject var1);

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE})
    public static @interface Registration {
        public String requiredPattern();

        public int position() default -1;
    }

    public static final class Result
    implements Lookup.Provider {
        private final Lookup lkp;
        private final Callable<? extends Project> projectFactory;
        private final String displayName;
        private final Icon icon;

        public Result(@NonNull Lookup lookup, @NonNull Callable<? extends Project> projectFactory, @NullAllowed String displayName, @NullAllowed Icon icon) {
            Parameters.notNull((CharSequence)"lookup", (Object)lookup);
            Parameters.notNull((CharSequence)"projectFactory", projectFactory);
            this.lkp = lookup;
            this.projectFactory = projectFactory;
            this.displayName = displayName;
            this.icon = icon;
        }

        @CheckForNull
        public String getDisplayName() {
            return this.displayName;
        }

        @CheckForNull
        public Icon getIcon() {
            return this.icon;
        }

        @NonNull
        public Project createProject() throws IOException {
            try {
                return this.projectFactory.call();
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }

        @NonNull
        public Lookup getLookup() {
            return this.lkp;
        }

        private static ProjectConvertorAcceptor create(Map<String, Object> params) {
            return new ProjectConvertorAcceptor(params);
        }
    }
}

