/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.ui.wizard;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.weblogic9.WLDeploymentFactory;
import org.netbeans.modules.j2ee.weblogic9.ui.wizard.WLInstantiatingIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ServerRemotePropertiesVisual
extends JPanel {
    private transient WLInstantiatingIterator instantiatingIterator;
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private JLabel adminPortLabel;
    private JTextField adminPortTextField;
    private JCheckBox debugModeCheckBox;
    private JLabel debugPortLabel;
    private JTextField debugPortTextField;
    private JLabel hostNameLabel;
    private JTextField hostNameTextField;
    private JPasswordField passwordField;
    private JLabel passwordLabel;
    private JCheckBox sslCheckBox;
    private JTextField usernameField;
    private JLabel usernameLabel;

    public ServerRemotePropertiesVisual(WLInstantiatingIterator instantiatingIterator) {
        this.instantiatingIterator = instantiatingIterator;
        this.setName(NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"SERVER_PROPERTIES_STEP"));
        this.initComponents();
        this.hostNameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerRemotePropertiesVisual.this.fireChangeEvent();
            }
        });
        this.adminPortTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerRemotePropertiesVisual.this.fireChangeEvent();
            }
        });
        this.debugModeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ServerRemotePropertiesVisual.this.fireChangeEvent();
            }
        });
        this.debugPortTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerRemotePropertiesVisual.this.fireChangeEvent();
            }
        });
        this.usernameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerRemotePropertiesVisual.this.fireChangeEvent();
            }
        });
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                ServerRemotePropertiesVisual.this.fireChangeEvent();
            }
        });
    }

    public boolean valid(WizardDescriptor wizardDescriptor) {
        int port;
        wizardDescriptor.putProperty("WizardPanel_errorMessage", null);
        wizardDescriptor.putProperty("WizardPanel_infoMessage", null);
        wizardDescriptor.putProperty("WizardPanel_warningMessage", null);
        String host = this.hostNameTextField.getText();
        if (host != null) {
            host = host.trim();
        }
        if (host == null || host.isEmpty()) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ERR_EMPTY_HOST")));
            return false;
        }
        String strPort = this.adminPortTextField.getText();
        try {
            port = Integer.parseInt(strPort);
        }
        catch (NumberFormatException ex) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ERR_NON_NUMERIC_PORT")));
            return false;
        }
        String debugPort = this.debugPortTextField.getText();
        if (this.debugModeCheckBox.isSelected()) {
            try {
                Integer.parseInt(debugPort);
            }
            catch (NumberFormatException ex) {
                wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ERR_NON_NUMERIC_PORT")));
                return false;
            }
        }
        if (InstanceProperties.getInstanceProperties((String)this.getUrl(host, port)) != null) {
            wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ERR_ALREADY_REGISTERED")));
            return false;
        }
        if (this.passwordField.getPassword().length <= 0) {
            wizardDescriptor.putProperty("WizardPanel_warningMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ERR_EMPTY_PASSWORD")));
        } else {
            wizardDescriptor.putProperty("WizardPanel_infoMessage", (Object)WLInstantiatingIterator.decorateMessage(NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"MSG_RegisterRemote")));
        }
        this.instantiatingIterator.setUrl(this.getUrl(host, port));
        this.instantiatingIterator.setDomainRoot(null);
        this.instantiatingIterator.setUsername(this.usernameField.getText());
        this.instantiatingIterator.setPassword(new String(this.passwordField.getPassword()));
        this.instantiatingIterator.setPort(Integer.toString(port));
        this.instantiatingIterator.setDebugPort(debugPort);
        this.instantiatingIterator.setDomainName(null);
        this.instantiatingIterator.setHost(host);
        this.instantiatingIterator.setRemote(true);
        this.instantiatingIterator.setRemoteDebug(this.debugModeCheckBox.isSelected());
        this.instantiatingIterator.setSsl(this.sslCheckBox.isSelected());
        return true;
    }

    private String getUrl(String host, int port) {
        return WLDeploymentFactory.getUrl(host, port, this.instantiatingIterator.getServerRoot(), null);
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void fireChangeEvent() {
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(event);
        }
    }

    private void initComponents() {
        this.usernameLabel = new JLabel();
        this.usernameField = new JTextField();
        this.passwordLabel = new JLabel();
        this.passwordField = new JPasswordField();
        this.hostNameLabel = new JLabel();
        this.hostNameTextField = new JTextField();
        this.adminPortLabel = new JLabel();
        this.adminPortTextField = new JTextField();
        this.debugPortLabel = new JLabel();
        this.debugPortTextField = new JTextField();
        this.debugModeCheckBox = new JCheckBox();
        this.sslCheckBox = new JCheckBox();
        this.usernameLabel.setHorizontalAlignment(11);
        this.usernameLabel.setLabelFor(this.usernameField);
        Mnemonics.setLocalizedText((JLabel)this.usernameLabel, (String)NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"LBL_USERNAME"));
        this.usernameField.setColumns(15);
        this.usernameField.setText("weblogic");
        this.passwordLabel.setHorizontalAlignment(11);
        this.passwordLabel.setLabelFor(this.passwordField);
        Mnemonics.setLocalizedText((JLabel)this.passwordLabel, (String)NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"LBL_PASSWORD"));
        this.passwordField.setColumns(15);
        this.hostNameLabel.setLabelFor(this.hostNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.hostNameLabel, (String)NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ServerRemotePropertiesVisual.hostNameLabel.text"));
        this.adminPortLabel.setLabelFor(this.adminPortTextField);
        Mnemonics.setLocalizedText((JLabel)this.adminPortLabel, (String)NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ServerRemotePropertiesVisual.adminPortLabel.text"));
        this.adminPortTextField.setColumns(5);
        this.adminPortTextField.setText("7001");
        this.debugPortLabel.setLabelFor(this.debugPortTextField);
        Mnemonics.setLocalizedText((JLabel)this.debugPortLabel, (String)NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ServerRemotePropertiesVisual.debugPortLabel.text"));
        this.debugPortTextField.setColumns(5);
        this.debugPortTextField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.debugModeCheckBox, (String)NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ServerRemotePropertiesVisual.debugModeCheckBox.text"));
        this.debugModeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ServerRemotePropertiesVisual.this.debugModeCheckBoxItemStateChanged(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.sslCheckBox, (String)NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ServerRemotePropertiesVisual.sslCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hostNameLabel).addComponent(this.adminPortLabel)).addGap(15, 15, 15).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.adminPortTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sslCheckBox).addContainerGap()).addComponent(this.hostNameTextField))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passwordLabel).addComponent(this.usernameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passwordField, -2, 147, -2).addComponent(this.usernameField, -2, 147, -2))).addComponent(this.debugModeCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.debugPortLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debugPortTextField, -2, -1, -2))).addContainerGap(204, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.hostNameLabel).addComponent(this.hostNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.adminPortLabel).addComponent(this.adminPortTextField, -2, -1, -2).addComponent(this.sslCheckBox)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.debugModeCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.debugPortLabel).addComponent(this.debugPortTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.usernameLabel).addComponent(this.usernameField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.passwordField, -2, -1, -2))));
        this.usernameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_usernameField"));
        this.passwordField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ServerRemotePropertiesVisual.class, (String)"ACSD_ServerPropertiesPanel_passwordField"));
    }

    private void debugModeCheckBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.debugPortTextField.setEnabled(true);
        } else if (evt.getStateChange() == 2) {
            this.debugPortTextField.setEnabled(false);
        }
    }
}

