/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.deploy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import org.netbeans.modules.j2ee.deployment.plugins.spi.TargetModuleIDResolver;
import org.netbeans.modules.j2ee.weblogic9.deploy.WLDeploymentManager;

public class WLTargetModuleIDResolver
extends TargetModuleIDResolver {
    private final WLDeploymentManager dm;

    public WLTargetModuleIDResolver(WLDeploymentManager dm) {
        this.dm = dm;
    }

    public TargetModuleID[] lookupTargetModuleID(Map targetModuleInfo, Target[] targetList) {
        String contextRoot = (String)targetModuleInfo.get("contextRoot");
        if (contextRoot == null) {
            return EMPTY_TMID_ARRAY;
        }
        String noSlashContextRoot = contextRoot;
        if (contextRoot.startsWith("/")) {
            noSlashContextRoot = contextRoot.substring(1);
        }
        ArrayList<TargetModuleID> result = new ArrayList<TargetModuleID>();
        try {
            this.addCollisions(contextRoot, noSlashContextRoot, result, this.dm.getAvailableModules(ModuleType.WAR, targetList));
        }
        catch (Exception ex) {
            Logger.getLogger(WLTargetModuleIDResolver.class.getName()).log(Level.INFO, null, ex);
        }
        return result.toArray(new TargetModuleID[result.size()]);
    }

    private void addCollisions(String contextRoot, String noSlashContextRoot, List<TargetModuleID> result, TargetModuleID[] candidates) {
        if (candidates == null) {
            return;
        }
        for (int i = 0; i < candidates.length; ++i) {
            TargetModuleID tm = candidates[i];
            if (!contextRoot.equals(tm.getModuleID()) && !noSlashContextRoot.equals(tm.getModuleID())) continue;
            TargetModuleID parent = tm.getParentTargetModuleID();
            if (parent != null) {
                result.add(parent);
                continue;
            }
            result.add(tm);
        }
    }
}

