/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.fixes;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.logging.Level;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemFinder;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;

abstract class AbstractCreateAnnotationHint
implements Fix {
    private FileObject fileObject;
    private ElementHandle<TypeElement> classHandle;
    private ElementHandle<Element> elemHandle;
    private String annotationClass;

    public AbstractCreateAnnotationHint(FileObject fileObject, ElementHandle<TypeElement> classHandle, ElementHandle<Element> elemHandle, String annotationClass) {
        this.classHandle = classHandle;
        this.fileObject = fileObject;
        this.annotationClass = annotationClass;
        this.elemHandle = elemHandle;
    }

    public ChangeInfo implement() {
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void cancel() {
            }

            public void run(WorkingCopy workingCopy) throws Exception {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                TypeElement clazz = (TypeElement)AbstractCreateAnnotationHint.this.classHandle.resolve((CompilationInfo)workingCopy);
                if (clazz != null) {
                    GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)workingCopy);
                    AnnotationTree annTree = genUtils.createAnnotation(AbstractCreateAnnotationHint.this.annotationClass);
                    Tree elemTree = workingCopy.getTrees().getTree(AbstractCreateAnnotationHint.this.elemHandle.resolve((CompilationInfo)workingCopy));
                    Tree newElemTree = null;
                    switch (elemTree.getKind()) {
                        case ANNOTATION_TYPE: 
                        case CLASS: 
                        case ENUM: 
                        case INTERFACE: {
                            newElemTree = genUtils.addAnnotation((ClassTree)elemTree, annTree);
                            break;
                        }
                        case METHOD: {
                            newElemTree = genUtils.addAnnotation((MethodTree)elemTree, annTree);
                            break;
                        }
                        case VARIABLE: {
                            newElemTree = genUtils.addAnnotation((VariableTree)elemTree, annTree);
                        }
                    }
                    if (newElemTree != null) {
                        workingCopy.rewrite(elemTree, newElemTree);
                    } else {
                        throw new IllegalStateException("Unsupported element type");
                    }
                }
            }
        };
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.fileObject);
        try {
            javaSource.runModificationTask((Task)task).commit();
        }
        catch (IOException e) {
            JPAProblemFinder.LOG.log(Level.SEVERE, e.getMessage(), e);
        }
        return null;
    }
}

