/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Timer;

class SlowListenerDetector {
    private final Logger logger;
    private final Level level;
    private final Timer timer;
    private final int timeout;
    private final Object lock = new Object();
    private Thread thread;
    private StackTraceElement[] stackTrace;
    private long startTime;
    private String methodName;

    public SlowListenerDetector(int timeout, Logger log, Level level) {
        this.logger = log;
        this.level = level;
        this.timeout = timeout;
        this.timer = new Timer(timeout, new TimerListener());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.thread = null;
            this.stackTrace = null;
            this.startTime = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String methodName) {
        Object object = this.lock;
        synchronized (object) {
            this.clear();
            this.methodName = methodName;
            this.thread = Thread.currentThread();
            this.startTime = System.currentTimeMillis();
        }
        this.timer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.timer.stop();
        Throwable ex = null;
        Object object = this.lock;
        synchronized (object) {
            long time = System.currentTimeMillis() - this.startTime;
            if (time > (long)this.timeout && this.stackTrace != null) {
                ex = new SlowListenerException("Too much time spent in " + this.methodName + ": " + time + " ms", this.stackTrace);
            }
            this.clear();
        }
        if (ex != null) {
            this.logger.log(this.level, ex.getMessage(), ex);
        }
    }

    static /* synthetic */ StackTraceElement[] access$302(SlowListenerDetector x0, StackTraceElement[] x1) {
        x0.stackTrace = x1;
        return x1;
    }

    private static class SlowListenerException
    extends RuntimeException {
        public SlowListenerException(String message, StackTraceElement[] stackTrace) {
            super(message);
            this.setStackTrace(stackTrace);
        }
    }

    private class TimerListener
    implements ActionListener {
        private TimerListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            SlowListenerDetector.this.timer.stop();
            Object object = SlowListenerDetector.this.lock;
            synchronized (object) {
                SlowListenerDetector.access$302(SlowListenerDetector.this, SlowListenerDetector.this.thread.getStackTrace());
            }
        }
    }
}

