/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.diff;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.diff.ExportDiff;
import org.netbeans.modules.mercurial.remote.ui.log.RepositoryRevision;
import org.netbeans.modules.mercurial.remote.ui.repository.ChangesetPickerPanel;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ExportDiffAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set roots = context.getFiles();
        if (roots == null) {
            return false;
        }
        if (!HgUtils.isFromHgRepository(context)) {
            return false;
        }
        for (VCSFileProxy root : roots) {
            FileInformation info = Mercurial.getInstance().getFileStatusCache().getCachedStatus(root);
            if (info == null || info.getStatus() != 4 && info.getStatus() != 4096) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ExportDiff";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        ExportDiffAction.exportDiff(context);
    }

    private static void exportDiff(VCSContext ctx) {
        VCSFileProxy[] files = HgUtils.getActionRoots(ctx);
        if (files == null || files.length == 0) {
            return;
        }
        final VCSFileProxy repository = Mercurial.getInstance().getRepositoryRoot(files[0]);
        ExportDiff exportDiffSupport = new ExportDiff(repository, files){

            public void writeDiffFile(final VCSFileProxy toFile) {
                final String revStr = this.getSelectionRevision();
                ExportDiffAction.saveFolderToPrefs(toFile);
                RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
                HgProgressSupport support = new HgProgressSupport(){

                    @Override
                    public void perform() {
                        OutputLogger logger = this.getLogger();
                        ExportDiffAction.performExport(repository, revStr, toFile.getPath(), logger);
                    }
                };
                support.start(rp, repository, NbBundle.getMessage(ExportDiffAction.class, (String)"LBL_ExportDiff_Progress")).waitFinished();
            }
        };
        exportDiffSupport.export();
    }

    public static void exportDiffFileRevision(RepositoryRevision.Event drev) {
        if (drev == null) {
            return;
        }
        final VCSFileProxy fileToDiff = drev.getFile();
        RepositoryRevision repoRev = drev.getLogInfoHeader();
        final VCSFileProxy root = repoRev.getRepositoryRoot();
        if (root == null || root.getPath().equals("")) {
            return;
        }
        final String revStr = repoRev.getLog().getRevisionNumber();
        ExportDiff exportDiffSupport = new ExportDiff(root, repoRev.getLog(), null, fileToDiff){

            public void writeDiffFile(final VCSFileProxy toFile) {
                ExportDiffAction.saveFolderToPrefs(toFile);
                RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                HgProgressSupport support = new HgProgressSupport(){

                    @Override
                    public void perform() {
                        OutputLogger logger = this.getLogger();
                        ExportDiffAction.performExportFile(root, revStr, fileToDiff, toFile.getPath(), logger);
                    }
                };
                support.start(rp, root, NbBundle.getMessage(ExportDiffAction.class, (String)"LBL_ExportDiff_Progress")).waitFinished();
            }
        };
        exportDiffSupport.export();
    }

    public static void exportDiffRevision(final RepositoryRevision repoRev, VCSFileProxy[] roots) {
        if (repoRev == null) {
            return;
        }
        final VCSFileProxy root = repoRev.getRepositoryRoot();
        if (root == null || root.getPath().equals("")) {
            return;
        }
        ExportDiff exportDiffSupport = new ExportDiff(root, repoRev.getLog(), roots){

            public void writeDiffFile(final VCSFileProxy toFile) {
                final String revStr = repoRev.getLog().getRevisionNumber();
                ExportDiffAction.saveFolderToPrefs(toFile);
                RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                HgProgressSupport support = new HgProgressSupport(){

                    @Override
                    public void perform() {
                        OutputLogger logger = this.getLogger();
                        ExportDiffAction.performExport(root, revStr, toFile.getPath(), logger);
                    }
                };
                support.start(rp, root, NbBundle.getMessage(ExportDiffAction.class, (String)"LBL_ExportDiff_Progress")).waitFinished();
            }
        };
        exportDiffSupport.export();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performExport(VCSFileProxy repository, String revStr, String outputFileName, OutputLogger logger) {
        try {
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_TITLE"));
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_TITLE_SEP"));
            if (revStr != null && NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Revision_Default").startsWith(revStr)) {
                logger.output(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_NOTHING"));
            } else {
                VCSFileProxy outFile;
                List<String> list = HgCommand.doExport(repository, revStr, outputFileName, logger);
                logger.output(list);
                if (!list.isEmpty() && list.size() > 1 && (outFile = VCSFileProxySupport.getResource((VCSFileProxy)repository, (String)list.get(1))) != null && VCSFileProxySupport.canRead((VCSFileProxy)outFile)) {
                    ExportDiffAction.openFile(outFile);
                }
            }
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        finally {
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_DONE"));
            logger.output("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performExportFile(VCSFileProxy repository, String revStr, VCSFileProxy fileToDiff, String outputFileName, OutputLogger logger) {
        try {
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_TITLE"));
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_TITLE_SEP"));
            if (NbBundle.getMessage(ChangesetPickerPanel.class, (String)"MSG_Revision_Default").startsWith(revStr)) {
                logger.output(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_NOTHING"));
            } else {
                VCSFileProxy outFile;
                List<String> list = HgCommand.doExportFileDiff(repository, fileToDiff, revStr, outputFileName, logger);
                String repoPath = repository.getPath();
                String fileToDiffPath = fileToDiff.getPath();
                fileToDiffPath = fileToDiffPath.substring(repoPath.length() + 1);
                logger.output(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE", (Object)fileToDiffPath, (Object)revStr, (Object)outputFileName));
                if (!list.isEmpty() && list.size() > 1 && (outFile = VCSFileProxySupport.getResource((VCSFileProxy)repository, (String)outputFileName)) != null && VCSFileProxySupport.canRead((VCSFileProxy)outFile)) {
                    ExportDiffAction.openFile(outFile);
                }
            }
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        finally {
            logger.outputInRed(NbBundle.getMessage(ExportDiffAction.class, (String)"MSG_EXPORT_FILE_DONE"));
            logger.output("");
        }
    }

    static void saveFolderToPrefs(VCSFileProxy file) {
        if (file.getParentFile() != null) {
            HgModuleConfig.getDefault(file).getPreferences().put("ExportDiff.saveFolder", file.getParentFile().getPath());
        }
    }

    private static void openFile(VCSFileProxy outFile) {
        outFile = outFile.normalizeFile();
        if (HgCommand.ENCODING != null) {
            VCSFileProxySupport.associateEncoding((VCSFileProxy)outFile, (Charset)Charset.forName(HgCommand.ENCODING));
        }
        VCSFileProxySupport.openFile((VCSFileProxy)outFile);
    }
}

