/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.ui;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.favorites.api.Favorites;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.modules.remote.ui.HostListRootNode;
import org.netbeans.modules.remote.ui.OpenRemoteProjectAction;
import org.netbeans.modules.remote.ui.SingleHostAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class AddToFavoritesAction
extends SingleHostAction {
    private static final String FILE_CHOOSER_KEY = "remote.add.favorite";
    private JMenu popupMenu;

    public String getName() {
        return NbBundle.getMessage(HostListRootNode.class, (String)"AddToFavoritesMenuItem");
    }

    @Override
    protected void performAction(ExecutionEnvironment env, Node node) {
        FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
        FileObject fo = fs.getRoot();
        if (!Favorites.getDefault().isInFavorites(fo)) {
            try {
                Favorites.getDefault().add(new FileObject[]{fo});
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isVisible(Node node) {
        TopComponent favoritesComponent = AddToFavoritesAction.getFavorites();
        return favoritesComponent != null && this.isRemote(node);
    }

    private static TopComponent getFavorites() {
        TopComponent favoritesComponent = WindowManager.getDefault().findTopComponent("favorites");
        return favoritesComponent;
    }

    public JMenuItem getPopupPresenter() {
        this.createSubMenu();
        return this.popupMenu;
    }

    private void createSubMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JMenu(this.getName());
            this.popupMenu.add(((AddHome)SystemAction.get(AddHome.class)).getPopupPresenter());
            this.popupMenu.add(((AddMirror)SystemAction.get(AddMirror.class)).getPopupPresenter());
            this.popupMenu.add(((AddRoot)SystemAction.get(AddRoot.class)).getPopupPresenter());
            this.popupMenu.add(((AddOther)SystemAction.get(AddOther.class)).getPopupPresenter());
        }
    }

    static FileObject getRemoteFileObject(final ExecutionEnvironment env, String title, String btn, Frame mainWindow) {
        final String curDir = RemoteFileChooserUtil.getCurrentChooserFile((String)FILE_CHOOSER_KEY, (ExecutionEnvironment)env);
        Callable<String> homeDirCallable = new Callable<String>(){

            @Override
            public String call() throws Exception {
                return curDir == null ? AddToFavoritesAction.getHomeDir(env) : curDir;
            }
        };
        JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)env, (String)title, (String)btn, (int)1, null, (Callable)homeDirCallable, (boolean)true);
        int ret = fileChooser.showOpenDialog(mainWindow);
        if (ret == 1) {
            return null;
        }
        FileObject fo = null;
        if (fileChooser instanceof FileChooserBuilder.JFileChooserEx) {
            fo = ((FileChooserBuilder.JFileChooserEx)fileChooser).getSelectedFileObject();
        } else {
            File selectedFile = fileChooser.getSelectedFile();
            if (selectedFile != null) {
                fo = FileUtil.toFileObject((File)selectedFile);
            }
        }
        if (fo == null || !fo.isFolder()) {
            String msg;
            String string = msg = fileChooser.getSelectedFile() != null ? fileChooser.getSelectedFile().getPath() : null;
            if (msg != null) {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"InvalidFolder", (Object)msg));
            }
            return null;
        }
        String lastPath = fo.getParent() == null ? fo.getPath() : fo.getParent().getPath();
        RemoteFileChooserUtil.setCurrentChooserFile((String)FILE_CHOOSER_KEY, (String)lastPath, (ExecutionEnvironment)env);
        return fo;
    }

    private static String getHomeDir(ExecutionEnvironment env) {
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
            if (hostInfo != null) {
                String userDir = env.isLocal() ? hostInfo.getUserDirFile().getAbsolutePath() : hostInfo.getUserDir();
                return userDir;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return null;
    }

    private static final class AddOther
    extends AddPlace {
        private final Frame mainWindow = WindowManager.getDefault().getMainWindow();

        public AddOther() {
            super(PLACE.OTHER);
        }

        @Override
        protected FileObject getRoot(ExecutionEnvironment env, FileSystem fs) {
            throw new IllegalArgumentException(NbBundle.getMessage(AddToFavoritesAction.class, (String)"AddToFavoritesAction.AddOther.DoNotInvoke.getRoot.directly"));
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            return null;
        }

        @Override
        protected void performAction(final ExecutionEnvironment env, Node node) {
            TopComponent favorites = AddToFavoritesAction.getFavorites();
            if (favorites != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!ConnectionManager.getInstance().connect(env)) {
                            return;
                        }
                        final String dir = RemoteFileChooserUtil.getCurrentChooserFile((String)AddToFavoritesAction.FILE_CHOOSER_KEY, (ExecutionEnvironment)env);
                        final Callable<String> homeDirCallable = new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return dir == null ? AddToFavoritesAction.getHomeDir(env) : dir;
                            }
                        };
                        Runnable openFavorites = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    FileObject rootFO = null;
                                    String title = NbBundle.getMessage(AddToFavoritesAction.class, (String)"SelectFolder");
                                    String btn = NbBundle.getMessage(AddToFavoritesAction.class, (String)"AddText");
                                    JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)env, (String)title, (String)btn, (int)1, null, (Callable)homeDirCallable, (boolean)true);
                                    int ret = fileChooser.showOpenDialog(AddOther.this.mainWindow);
                                    if (ret == 1) {
                                        rootFO = null;
                                    } else {
                                        if (fileChooser instanceof FileChooserBuilder.JFileChooserEx) {
                                            rootFO = ((FileChooserBuilder.JFileChooserEx)fileChooser).getSelectedFileObject();
                                        } else {
                                            File selectedFile = fileChooser.getSelectedFile();
                                            if (selectedFile != null) {
                                                rootFO = FileUtil.toFileObject((File)selectedFile);
                                            }
                                        }
                                        if (rootFO == null || !rootFO.isFolder()) {
                                            String msg;
                                            String string = msg = fileChooser.getSelectedFile() != null ? fileChooser.getSelectedFile().getPath() : null;
                                            if (msg != null) {
                                                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), NbBundle.getMessage(OpenRemoteProjectAction.class, (String)"InvalidFolder", (Object)msg));
                                            }
                                        } else {
                                            String lastPath = rootFO.getParent() == null ? rootFO.getPath() : rootFO.getParent().getPath();
                                            RemoteFileChooserUtil.setCurrentChooserFile((String)AddToFavoritesAction.FILE_CHOOSER_KEY, (String)lastPath, (ExecutionEnvironment)env);
                                        }
                                    }
                                    if (rootFO != null) {
                                        Favorites.getDefault().selectWithAddition(rootFO);
                                    }
                                }
                                catch (DataObjectNotFoundException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                        };
                        SwingUtilities.invokeLater(openFavorites);
                    }
                };
                RP.post(runnable);
            }
        }
    }

    private static final class AddMirror
    extends AddPlace {
        public AddMirror() {
            super(PLACE.MIRROR);
        }

        @Override
        protected FileObject getRoot(ExecutionEnvironment env, FileSystem fs) {
            String path = this.getPath(env);
            return path == null ? null : fs.findResource(path);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            String remoteSyncRoot = RemotePathMap.getRemoteSyncRoot((ExecutionEnvironment)env);
            return remoteSyncRoot;
        }
    }

    private static final class AddProjects
    extends AddPlace {
        public AddProjects() {
            super(PLACE.PROJECTS);
        }

        @Override
        protected FileObject getRoot(ExecutionEnvironment env, FileSystem fs) {
            return fs.getRoot();
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            return "/";
        }
    }

    private static final class AddHome
    extends AddPlace {
        public AddHome() {
            super(PLACE.HOME);
        }

        @Override
        protected FileObject getRoot(ExecutionEnvironment env, FileSystem fs) {
            String path = this.getPath(env);
            return path == null ? null : fs.findResource(path);
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                if (hostInfo != null) {
                    String userDir = hostInfo.getUserDir();
                    return userDir;
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ConnectionManager.CancellationException cancellationException) {
                // empty catch block
            }
            return null;
        }
    }

    private static final class AddRoot
    extends AddPlace {
        public AddRoot() {
            super(PLACE.ROOT);
        }

        @Override
        protected FileObject getRoot(ExecutionEnvironment env, FileSystem fs) {
            return fs.getRoot();
        }

        @Override
        protected String getPath(ExecutionEnvironment env) {
            return "/";
        }
    }

    private static abstract class AddPlace
    extends SingleHostAction {
        protected static final RequestProcessor RP = new RequestProcessor("AddToFavoritesAction", 1);
        private final PLACE place;

        private AddPlace(PLACE place) {
            this.place = place;
            this.putProperty("noIconInMenu", Boolean.TRUE);
        }

        protected abstract FileObject getRoot(ExecutionEnvironment var1, FileSystem var2);

        protected abstract String getPath(ExecutionEnvironment var1);

        @Override
        protected void performAction(final ExecutionEnvironment env, Node node) {
            TopComponent favorites = AddToFavoritesAction.getFavorites();
            if (favorites != null) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (!ConnectionManager.getInstance().connect(env)) {
                            return;
                        }
                        FileSystem fs = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
                        final FileObject fo = AddPlace.this.getRoot(env, fs);
                        if (fo != null) {
                            Runnable openFavorites = new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Favorites.getDefault().selectWithAddition(fo);
                                    }
                                    catch (DataObjectNotFoundException ex) {
                                        Exceptions.printStackTrace((Throwable)ex);
                                    }
                                }
                            };
                            SwingUtilities.invokeLater(openFavorites);
                        } else {
                            String path = AddPlace.this.getPath(env);
                            if (path != null) {
                                String msg = !ConnectionManager.getInstance().isConnectedTo(env) ? NbBundle.getMessage(AddToFavoritesAction.class, (String)"NotConnected", (Object)path, (Object)env.getDisplayName()) : NbBundle.getMessage(AddToFavoritesAction.class, (String)"NoRemotePath", (Object)path);
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                            }
                        }
                    }
                };
                RP.post(runnable);
            }
        }

        public String getName() {
            return this.place.getName();
        }
    }

    private static enum PLACE {
        ROOT("AddRoot"),
        HOME("AddHome"),
        PROJECTS("AddProjects"),
        OTHER("AddOtherFolder"),
        MIRROR("AddMirror");

        private final String name;

        private PLACE(String nameKey) {
            this.name = NbBundle.getMessage(AddToFavoritesAction.class, (String)nameKey);
        }

        private String getName() {
            return this.name;
        }
    }
}

