/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.support;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.api.ServerRecord;
import org.netbeans.modules.remote.support.RemoteLogger;

public final class ServerListImpl {
    private static ServerListImpl instance = new ServerListImpl();
    private static final List<WeakReference<PropertyChangeListener>> listeners = new ArrayList<WeakReference<PropertyChangeListener>>();
    private final List<ServerRecord> records;
    private ServerRecord defaultRecord = null;
    private final Object lock = new Object();

    public static ServerListImpl getDefault() {
        return instance;
    }

    private ServerListImpl() {
        this.records = new ArrayList<ServerRecord>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<ServerRecord> getRecords() {
        Object object = this.lock;
        synchronized (object) {
            return Collections.unmodifiableCollection(new ArrayList<ServerRecord>(this.records));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerRecord get(ExecutionEnvironment env) {
        Object object = this.lock;
        synchronized (object) {
            for (ServerRecord record : this.records) {
                if (!record.getExecutionEnvironment().equals((Object)env)) continue;
                return record;
            }
        }
        return null;
    }

    public ServerRecord getDefaultRecord() {
        return this.defaultRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultRecord(ServerRecord newDefaultRecord) {
        ServerRecord oldDefaultRecord = null;
        boolean fire = false;
        Object object = this.lock;
        synchronized (object) {
            ServerRecord found = this.get(newDefaultRecord.getExecutionEnvironment());
            RemoteLogger.assertTrue(found != null, "the record to be set as default is absent in the list");
            if (found != null) {
                newDefaultRecord = found;
                oldDefaultRecord = this.defaultRecord;
                this.defaultRecord = newDefaultRecord;
            }
        }
        if (fire) {
            this.firePropertyChange("DEFAULT_RECORD", oldDefaultRecord, newDefaultRecord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adRecord(ServerRecord record) {
        List<ServerRecord> newRecords;
        List<ServerRecord> oldRecords;
        ServerRecord found = this.get(record.getExecutionEnvironment());
        RemoteLogger.assertTrue(found == null, "the record to be added already exists in the list");
        Object object = this.lock;
        synchronized (object) {
            oldRecords = Collections.unmodifiableList(new ArrayList<ServerRecord>(this.records));
            this.records.add(record);
            newRecords = Collections.unmodifiableList(new ArrayList<ServerRecord>(this.records));
        }
        this.firePropertyChange("RECORD_LIST", oldRecords, newRecords);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            List<WeakReference<PropertyChangeListener>> list = listeners;
            synchronized (list) {
                for (WeakReference<PropertyChangeListener> ref : listeners) {
                    if (!listener.equals(ref.get())) continue;
                    return;
                }
                listeners.add(new WeakReference<PropertyChangeListener>(listener));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            List<WeakReference<PropertyChangeListener>> list = listeners;
            synchronized (list) {
                for (WeakReference<PropertyChangeListener> ref : listeners) {
                    if (!listener.equals(ref.get())) continue;
                    listeners.remove(ref);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firePropertyChange(String name, Object oldValue, Object newValue) {
        ArrayList<PropertyChangeListener> listenersCopy;
        List<WeakReference<PropertyChangeListener>> list = listeners;
        synchronized (list) {
            listenersCopy = new ArrayList<PropertyChangeListener>(listeners.size());
            for (WeakReference<PropertyChangeListener> ref : listeners) {
                PropertyChangeListener listener = (PropertyChangeListener)ref.get();
                if (listener == null) continue;
                listenersCopy.add(listener);
            }
        }
        for (PropertyChangeListener listener : listenersCopy) {
            listener.propertyChange(new PropertyChangeEvent(this, name, oldValue, newValue));
        }
    }
}

