/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.debugger.jpda.ui.debugging.JPDADVThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.JPDADVThreadGroup;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingMonitorModel;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingNodeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeExpansionModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.WeakSet;

public class DebuggingTreeExpansionModelFilter
implements TreeExpansionModelFilter {
    private static final Map<JPDADebugger, DebuggingTreeExpansionModelFilter> FILTERS = new WeakHashMap<JPDADebugger, DebuggingTreeExpansionModelFilter>();
    private final Set<Object> expandedNodes = new WeakSet();
    private final Set<Object> expandedExplicitly = new WeakSet();
    private final Set<Object> collapsedExplicitly = new WeakSet();
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();
    private final Reference<JPDADebugger> debuggerRef;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DebuggingTreeExpansionModelFilter(ContextProvider lookupProvider) {
        JPDADebugger debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.debuggerRef = new WeakReference<JPDADebugger>(debugger);
        Map<JPDADebugger, DebuggingTreeExpansionModelFilter> map = FILTERS;
        synchronized (map) {
            FILTERS.put(debugger, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isExpanded(JPDADebugger debugger, Object node) {
        DebuggingTreeExpansionModelFilter filter;
        Map<JPDADebugger, DebuggingTreeExpansionModelFilter> map = FILTERS;
        synchronized (map) {
            filter = FILTERS.get(debugger);
        }
        if (filter == null) {
            return false;
        }
        return filter.isExpanded(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expand(JPDADebugger debugger, Object node) {
        DebuggingTreeExpansionModelFilter filter;
        Map<JPDADebugger, DebuggingTreeExpansionModelFilter> map = FILTERS;
        synchronized (map) {
            filter = FILTERS.get(debugger);
        }
        if (filter != null) {
            filter.expand(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expand(Object node) {
        DebuggingTreeExpansionModelFilter debuggingTreeExpansionModelFilter = this;
        synchronized (debuggingTreeExpansionModelFilter) {
            if (this.collapsedExplicitly.contains(node)) {
                return;
            }
            this.expandedExplicitly.add(node);
        }
        this.fireNodeExpanded(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExpanded(Object node) {
        DebuggingTreeExpansionModelFilter debuggingTreeExpansionModelFilter = this;
        synchronized (debuggingTreeExpansionModelFilter) {
            return this.expandedNodes.contains(node) || this.expandedExplicitly.contains(node) && !this.collapsedExplicitly.contains(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpanded(TreeExpansionModel original, Object node) throws UnknownTypeException {
        Object object;
        JPDADebugger debugger = this.debuggerRef.get();
        if (debugger == null) {
            return false;
        }
        Set nodesInDeadlock = DebuggingNodeModel.getNodesInDeadlock(debugger);
        if (nodesInDeadlock != null) {
            object = nodesInDeadlock;
            synchronized (object) {
                if (nodesInDeadlock.contains(node)) {
                    return true;
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.expandedExplicitly.contains(node)) {
                return true;
            }
            if (this.collapsedExplicitly.contains(node)) {
                return false;
            }
        }
        if (node instanceof JPDADVThreadGroup) {
            return true;
        }
        if (node instanceof JPDADVThread && ((JPDADVThread)node).getCurrentBreakpoint() != null) {
            return true;
        }
        if (node instanceof CallStackFrame) {
            return true;
        }
        if (node instanceof DebuggingMonitorModel.OwnedMonitors) {
            return ((DebuggingMonitorModel.OwnedMonitors)node).monitors != null;
        }
        return original.isExpanded(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeExpanded(Object node) {
        DebuggingTreeExpansionModelFilter debuggingTreeExpansionModelFilter = this;
        synchronized (debuggingTreeExpansionModelFilter) {
            this.expandedNodes.add(node);
            this.collapsedExplicitly.remove(node);
        }
        if (node instanceof JPDADVThread || node instanceof JPDADVThreadGroup) {
            this.fireNodeChanged(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeCollapsed(Object node) {
        DebuggingTreeExpansionModelFilter debuggingTreeExpansionModelFilter = this;
        synchronized (debuggingTreeExpansionModelFilter) {
            this.expandedNodes.remove(node);
            this.expandedExplicitly.remove(node);
            this.collapsedExplicitly.add(node);
        }
        if (node instanceof JPDADVThread || node instanceof JPDADVThreadGroup) {
            this.fireNodeChanged(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChanged(Object node) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, node, 1);
        for (ModelListener ml : ls) {
            ml.modelChanged((ModelEvent)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeExpanded(Object node) {
        ArrayList<ModelListener> ls;
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            ls = new ArrayList<ModelListener>(this.listeners);
        }
        ModelEvent.NodeChanged event = new ModelEvent.NodeChanged((Object)this, node, 16);
        for (ModelListener ml : ls) {
            ml.modelChanged((ModelEvent)event);
        }
    }
}

