/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlyWindowStore;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.CompositeKeyValueIterator;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.KeyValueIterators;
import org.apache.kafka.streams.state.internals.NextIteratorFunction;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class CompositeReadOnlyWindowStore<K, V>
implements ReadOnlyWindowStore<K, V> {
    private final QueryableStoreType<ReadOnlyWindowStore<K, V>> windowStoreType;
    private final String storeName;
    private final StateStoreProvider provider;

    public CompositeReadOnlyWindowStore(StateStoreProvider provider, QueryableStoreType<ReadOnlyWindowStore<K, V>> windowStoreType, String storeName) {
        this.provider = provider;
        this.windowStoreType = windowStoreType;
        this.storeName = storeName;
    }

    @Override
    public WindowStoreIterator<V> fetch(K key, long timeFrom, long timeTo) {
        Objects.requireNonNull(key, "key can't be null");
        List<ReadOnlyWindowStore<K, V>> stores = this.provider.stores(this.storeName, this.windowStoreType);
        for (ReadOnlyWindowStore<K, V> windowStore : stores) {
            try {
                WindowStoreIterator<V> result = windowStore.fetch(key, timeFrom, timeTo);
                if (!result.hasNext()) {
                    result.close();
                    continue;
                }
                return result;
            }
            catch (InvalidStateStoreException e) {
                throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
            }
        }
        return KeyValueIterators.emptyWindowStoreIterator();
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetch(final K from, final K to, final long timeFrom, final long timeTo) {
        Objects.requireNonNull(from, "from can't be null");
        Objects.requireNonNull(to, "to can't be null");
        NextIteratorFunction nextIteratorFunction = new NextIteratorFunction<Windowed<K>, V, ReadOnlyWindowStore<K, V>>(){

            @Override
            public KeyValueIterator<Windowed<K>, V> apply(ReadOnlyWindowStore<K, V> store) {
                return store.fetch(from, to, timeFrom, timeTo);
            }
        };
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.provider.stores(this.storeName, this.windowStoreType).iterator(), nextIteratorFunction));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> all() {
        NextIteratorFunction nextIteratorFunction = new NextIteratorFunction<Windowed<K>, V, ReadOnlyWindowStore<K, V>>(){

            @Override
            public KeyValueIterator<Windowed<K>, V> apply(ReadOnlyWindowStore<K, V> store) {
                return store.all();
            }
        };
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.provider.stores(this.storeName, this.windowStoreType).iterator(), nextIteratorFunction));
    }

    @Override
    public KeyValueIterator<Windowed<K>, V> fetchAll(final long timeFrom, final long timeTo) {
        NextIteratorFunction nextIteratorFunction = new NextIteratorFunction<Windowed<K>, V, ReadOnlyWindowStore<K, V>>(){

            @Override
            public KeyValueIterator<Windowed<K>, V> apply(ReadOnlyWindowStore<K, V> store) {
                return store.fetchAll(timeFrom, timeTo);
            }
        };
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(this.provider.stores(this.storeName, this.windowStoreType).iterator(), nextIteratorFunction));
    }
}

