/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import java.util.Objects;
import org.apache.kafka.streams.errors.InvalidStateStoreException;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.QueryableStoreType;
import org.apache.kafka.streams.state.ReadOnlyKeyValueStore;
import org.apache.kafka.streams.state.internals.CompositeKeyValueIterator;
import org.apache.kafka.streams.state.internals.DelegatingPeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.NextIteratorFunction;
import org.apache.kafka.streams.state.internals.StateStoreProvider;

public class CompositeReadOnlyKeyValueStore<K, V>
implements ReadOnlyKeyValueStore<K, V> {
    private final StateStoreProvider storeProvider;
    private final QueryableStoreType<ReadOnlyKeyValueStore<K, V>> storeType;
    private final String storeName;

    public CompositeReadOnlyKeyValueStore(StateStoreProvider storeProvider, QueryableStoreType<ReadOnlyKeyValueStore<K, V>> storeType, String storeName) {
        this.storeProvider = storeProvider;
        this.storeType = storeType;
        this.storeName = storeName;
    }

    @Override
    public V get(K key) {
        Objects.requireNonNull(key);
        List<ReadOnlyKeyValueStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.storeType);
        for (ReadOnlyKeyValueStore<K, V> store : stores) {
            try {
                V result = store.get(key);
                if (result == null) continue;
                return result;
            }
            catch (InvalidStateStoreException e) {
                throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
            }
        }
        return null;
    }

    @Override
    public KeyValueIterator<K, V> range(final K from, final K to) {
        Objects.requireNonNull(from);
        Objects.requireNonNull(to);
        NextIteratorFunction nextIteratorFunction = new NextIteratorFunction<K, V, ReadOnlyKeyValueStore<K, V>>(){

            @Override
            public KeyValueIterator<K, V> apply(ReadOnlyKeyValueStore<K, V> store) {
                try {
                    return store.range(from, to);
                }
                catch (InvalidStateStoreException e) {
                    throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
                }
            }
        };
        List<ReadOnlyKeyValueStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.storeType);
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(stores.iterator(), nextIteratorFunction));
    }

    @Override
    public KeyValueIterator<K, V> all() {
        NextIteratorFunction nextIteratorFunction = new NextIteratorFunction<K, V, ReadOnlyKeyValueStore<K, V>>(){

            @Override
            public KeyValueIterator<K, V> apply(ReadOnlyKeyValueStore<K, V> store) {
                try {
                    return store.all();
                }
                catch (InvalidStateStoreException e) {
                    throw new InvalidStateStoreException("State store is not available anymore and may have been migrated to another instance; please re-discover its location from the state metadata.");
                }
            }
        };
        List<ReadOnlyKeyValueStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.storeType);
        return new DelegatingPeekingKeyValueIterator(this.storeName, new CompositeKeyValueIterator(stores.iterator(), nextIteratorFunction));
    }

    @Override
    public long approximateNumEntries() {
        List<ReadOnlyKeyValueStore<K, V>> stores = this.storeProvider.stores(this.storeName, this.storeType);
        long total = 0L;
        for (ReadOnlyKeyValueStore<K, V> store : stores) {
            if ((total += store.approximateNumEntries()) >= 0L) continue;
            return Long.MAX_VALUE;
        }
        return total;
    }
}

