/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.stats;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.rtcp.RtcpListener;
import org.jitsi.nlj.rtp.LossTracker;
import org.jitsi.nlj.stats.SsrcAndTimestamp;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpReportBlock;
import org.jitsi.rtp.rtcp.RtcpRrPacket;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.utils.DurationKt;
import org.jitsi.utils.LRUCache;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002()B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u001a\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"H\u0016J\u001a\u0010%\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u000e2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006*"}, d2={"Lorg/jitsi/nlj/stats/EndpointConnectionStats;", "Lorg/jitsi/nlj/rtcp/RtcpListener;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "endpointConnectionStatsListeners", "", "Lorg/jitsi/nlj/stats/EndpointConnectionStats$EndpointConnectionStatsListener;", "srSentTimes", "", "Lorg/jitsi/nlj/stats/SsrcAndTimestamp;", "Ljava/time/Instant;", "logger", "lock", "Ljava/lang/Object;", "rtt", "", "incomingLossTracker", "Lorg/jitsi/nlj/rtp/LossTracker;", "getIncomingLossTracker", "()Lorg/jitsi/nlj/rtp/LossTracker;", "outgoingLossTracker", "getOutgoingLossTracker", "addListener", "", "listener", "removeListener", "getSnapshot", "Lorg/jitsi/nlj/stats/EndpointConnectionStats$Snapshot;", "rtcpPacketReceived", "packet", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "receivedTime", "rtcpPacketSent", "processReportBlock", "reportBlock", "Lorg/jitsi/rtp/rtcp/RtcpReportBlock;", "EndpointConnectionStatsListener", "Snapshot", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nEndpointConnectionStats.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EndpointConnectionStats.kt\norg/jitsi/nlj/stats/EndpointConnectionStats\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,182:1\n63#2,4:183\n63#2,4:189\n63#2,4:195\n63#2,4:199\n63#2,4:203\n63#2,4:209\n1863#3,2:187\n1863#3,2:193\n1863#3,2:207\n*S KotlinDebug\n*F\n+ 1 EndpointConnectionStats.kt\norg/jitsi/nlj/stats/EndpointConnectionStats\n*L\n106#1:183,4\n110#1:189,4\n119#1:195,4\n131#1:199,4\n139#1:203,4\n175#1:209,4\n107#1:187,2\n111#1:193,2\n173#1:207,2\n*E\n"})
public final class EndpointConnectionStats
implements RtcpListener {
    @NotNull
    private final Clock clock;
    @NotNull
    private final List<EndpointConnectionStatsListener> endpointConnectionStatsListeners;
    @NotNull
    private final Map<SsrcAndTimestamp, Instant> srSentTimes;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Object lock;
    private double rtt;
    @NotNull
    private final LossTracker incomingLossTracker;
    @NotNull
    private final LossTracker outgoingLossTracker;

    public EndpointConnectionStats(@NotNull Logger parentLogger, @NotNull Clock clock) {
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        Intrinsics.checkNotNullParameter(clock, "clock");
        this.clock = clock;
        this.endpointConnectionStatsListeners = new CopyOnWriteArrayList();
        Map map = Collections.synchronizedMap(new LRUCache(200));
        Intrinsics.checkNotNullExpressionValue(map, "synchronizedMap(...)");
        this.srSentTimes = map;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.lock = new Object();
        this.incomingLossTracker = new LossTracker();
        this.outgoingLossTracker = new LossTracker();
    }

    public /* synthetic */ EndpointConnectionStats(Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker2) {
        if ((n & 2) != 0) {
            clock = Clock.systemUTC();
        }
        this(logger, clock);
    }

    @NotNull
    public final LossTracker getIncomingLossTracker() {
        return this.incomingLossTracker;
    }

    @NotNull
    public final LossTracker getOutgoingLossTracker() {
        return this.outgoingLossTracker;
    }

    public final void addListener(@NotNull EndpointConnectionStatsListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.endpointConnectionStatsListeners.add(listener);
    }

    public final void removeListener(@NotNull EndpointConnectionStatsListener listener) {
        Intrinsics.checkNotNullParameter(listener, "listener");
        this.endpointConnectionStatsListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Snapshot getSnapshot() {
        Snapshot snapshot;
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            snapshot = new Snapshot(this.rtt, this.incomingLossTracker.getSnapshot(), this.outgoingLossTracker.getSnapshot());
        }
        return snapshot;
    }

    @Override
    public void rtcpPacketReceived(@NotNull RtcpPacket packet, @Nullable Instant receivedTime) {
        block5: {
            RtcpPacket rtcpPacket;
            block4: {
                Intrinsics.checkNotNullParameter(packet, "packet");
                rtcpPacket = packet;
                if (!(rtcpPacket instanceof RtcpSrPacket)) break block4;
                Logger $this$cdebug$iv = this.logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    Logger logger = $this$cdebug$iv;
                    boolean bl = false;
                    logger.debug("Received SR packet with " + ((RtcpSrPacket)packet).getReportBlocks().size() + " report blocks");
                }
                Iterable $this$forEach$iv = ((RtcpSrPacket)packet).getReportBlocks();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RtcpReportBlock reportBlock = (RtcpReportBlock)element$iv;
                    boolean bl = false;
                    this.processReportBlock(receivedTime, reportBlock);
                }
                break block5;
            }
            if (!(rtcpPacket instanceof RtcpRrPacket)) break block5;
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("Received RR packet with " + ((RtcpRrPacket)packet).getReportBlocks().size() + " report blocks");
            }
            Iterable $this$forEach$iv = ((RtcpRrPacket)packet).getReportBlocks();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RtcpReportBlock reportBlock = (RtcpReportBlock)element$iv;
                boolean bl = false;
                this.processReportBlock(receivedTime, reportBlock);
            }
        }
    }

    @Override
    public void rtcpPacketSent(@NotNull RtcpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        if (packet instanceof RtcpSrPacket) {
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl = false;
                logger.debug("Tracking sent SR packet with compacted timestamp " + ((RtcpSrPacket)packet).getSenderInfo().getCompactedNtpTimestamp());
            }
            SsrcAndTimestamp entry = new SsrcAndTimestamp(packet.getSenderSsrc(), ((RtcpSrPacket)packet).getSenderInfo().getCompactedNtpTimestamp());
            this.srSentTimes.put(entry, this.clock.instant());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processReportBlock(Instant receivedTime, RtcpReportBlock reportBlock) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            if (reportBlock.getLastSrTimestamp() == 0L && reportBlock.getDelaySinceLastSr() == 0L) {
                Logger $this$cdebug$iv = this.logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    Logger logger = $this$cdebug$iv;
                    boolean bl2 = false;
                    logger.debug("Report block for ssrc " + reportBlock.getSsrc() + " didn't have SR data: lastSrTimestamp was " + reportBlock.getLastSrTimestamp() + ", delaySinceLastSr was " + reportBlock.getDelaySinceLastSr());
                }
                return;
            }
            if (receivedTime == null) {
                Logger $this$cdebug$iv = this.logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    Logger logger = $this$cdebug$iv;
                    boolean bl3 = false;
                    logger.debug("Arrival time of report block is null, cannot calculate RTT");
                }
                return;
            }
            Instant instant = this.srSentTimes.get(new SsrcAndTimestamp(reportBlock.getSsrc(), reportBlock.getLastSrTimestamp()));
            if (instant != null) {
                Instant srSentTime = instant;
                boolean bl4 = false;
                Duration remoteProcessingDelay = Duration.ofNanos((long)((double)reportBlock.getDelaySinceLastSr() / 6.5536E-5));
                if (remoteProcessingDelay.compareTo(Duration.ofMinutes(5L)) > 0) {
                    this.logger.warn("Ignoring report block with suspiciously long DLSR: " + remoteProcessingDelay);
                } else {
                    Duration duration = Duration.between(srSentTime, receivedTime).minus(remoteProcessingDelay);
                    Intrinsics.checkNotNullExpressionValue(duration, "minus(...)");
                    double newRtt = DurationKt.toDoubleMillis(duration);
                    if (newRtt > (double)DurationKt.getSecs(7).toMillis()) {
                        this.logger.warn("Ignoring suspiciously high rtt value: " + newRtt + " ms, remote processing delay was " + remoteProcessingDelay + " (" + reportBlock.getDelaySinceLastSr() + "), srSentTime was " + srSentTime + ", received time was " + receivedTime);
                    } else if (newRtt < 0.0) {
                        this.logger.warn("Negative rtt value: " + newRtt + " ms, remote processing delay was " + remoteProcessingDelay + " (" + reportBlock.getDelaySinceLastSr() + "), srSentTime was " + srSentTime + ", received time was " + receivedTime);
                    } else {
                        this.rtt = newRtt;
                        Iterable $this$forEach$iv = this.endpointConnectionStatsListeners;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            EndpointConnectionStatsListener it = (EndpointConnectionStatsListener)element$iv;
                            boolean bl5 = false;
                            it.onRttUpdate(this.rtt);
                        }
                    }
                }
            } else {
                EndpointConnectionStats $this$processReportBlock_u24lambda_u2412_u24lambda_u2411 = this;
                boolean bl6 = false;
                Logger $this$cdebug$iv = $this$processReportBlock_u24lambda_u2412_u24lambda_u2411.logger;
                boolean $i$f$cdebug = false;
                if ($this$cdebug$iv.isDebugEnabled()) {
                    Logger logger = $this$cdebug$iv;
                    boolean bl7 = false;
                    logger.debug("No sent SR found for SSRC " + reportBlock.getSsrc() + " and SR timestamp " + reportBlock.getLastSrTimestamp());
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/nlj/stats/EndpointConnectionStats$EndpointConnectionStatsListener;", "", "onRttUpdate", "", "newRttMs", "", "jitsi-media-transform"})
    public static interface EndpointConnectionStatsListener {
        public void onRttUpdate(double var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/nlj/stats/EndpointConnectionStats$Snapshot;", "", "rtt", "", "incomingLossStats", "Lorg/jitsi/nlj/rtp/LossTracker$Snapshot;", "outgoingLossStats", "<init>", "(DLorg/jitsi/nlj/rtp/LossTracker$Snapshot;Lorg/jitsi/nlj/rtp/LossTracker$Snapshot;)V", "getRtt", "()D", "getIncomingLossStats", "()Lorg/jitsi/nlj/rtp/LossTracker$Snapshot;", "getOutgoingLossStats", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "jitsi-media-transform"})
    public static final class Snapshot {
        private final double rtt;
        @NotNull
        private final LossTracker.Snapshot incomingLossStats;
        @NotNull
        private final LossTracker.Snapshot outgoingLossStats;

        public Snapshot(double rtt, @NotNull LossTracker.Snapshot incomingLossStats, @NotNull LossTracker.Snapshot outgoingLossStats) {
            Intrinsics.checkNotNullParameter(incomingLossStats, "incomingLossStats");
            Intrinsics.checkNotNullParameter(outgoingLossStats, "outgoingLossStats");
            this.rtt = rtt;
            this.incomingLossStats = incomingLossStats;
            this.outgoingLossStats = outgoingLossStats;
        }

        public final double getRtt() {
            return this.rtt;
        }

        @NotNull
        public final LossTracker.Snapshot getIncomingLossStats() {
            return this.incomingLossStats;
        }

        @NotNull
        public final LossTracker.Snapshot getOutgoingLossStats() {
            return this.outgoingLossStats;
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u240.put("rtt", (Object)this.rtt);
            $this$toJson_u24lambda_u240.put("incoming_loss_stats", this.incomingLossStats.toJson());
            $this$toJson_u24lambda_u240.put("outgoing_loss_stats", this.outgoingLossStats.toJson());
            return orderedJsonObject;
        }

        public final double component1() {
            return this.rtt;
        }

        @NotNull
        public final LossTracker.Snapshot component2() {
            return this.incomingLossStats;
        }

        @NotNull
        public final LossTracker.Snapshot component3() {
            return this.outgoingLossStats;
        }

        @NotNull
        public final Snapshot copy(double rtt, @NotNull LossTracker.Snapshot incomingLossStats, @NotNull LossTracker.Snapshot outgoingLossStats) {
            Intrinsics.checkNotNullParameter(incomingLossStats, "incomingLossStats");
            Intrinsics.checkNotNullParameter(outgoingLossStats, "outgoingLossStats");
            return new Snapshot(rtt, incomingLossStats, outgoingLossStats);
        }

        public static /* synthetic */ Snapshot copy$default(Snapshot snapshot, double d, LossTracker.Snapshot snapshot2, LossTracker.Snapshot snapshot3, int n, Object object) {
            if ((n & 1) != 0) {
                d = snapshot.rtt;
            }
            if ((n & 2) != 0) {
                snapshot2 = snapshot.incomingLossStats;
            }
            if ((n & 4) != 0) {
                snapshot3 = snapshot.outgoingLossStats;
            }
            return snapshot.copy(d, snapshot2, snapshot3);
        }

        @NotNull
        public String toString() {
            return "Snapshot(rtt=" + this.rtt + ", incomingLossStats=" + this.incomingLossStats + ", outgoingLossStats=" + this.outgoingLossStats + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.rtt);
            result = result * 31 + this.incomingLossStats.hashCode();
            result = result * 31 + this.outgoingLossStats.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Snapshot)) {
                return false;
            }
            Snapshot snapshot = (Snapshot)other;
            if (Double.compare(this.rtt, snapshot.rtt) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual(this.incomingLossStats, snapshot.incomingLossStats)) {
                return false;
            }
            return Intrinsics.areEqual(this.outgoingLossStats, snapshot.outgoingLossStats);
        }
    }
}

