/*
 * Decompiled with CFR 0.152.
 */
package free.jin.scripter;

import bsh.EvalError;
import bsh.Interpreter;
import free.jin.Connection;
import free.jin.event.JinEvent;
import free.jin.scripter.Script;
import free.jin.scripter.Scripter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommandScript
extends Script {
    private final String condition;
    private final String[] commands;
    private final Interpreter bsh;

    public CommandScript(Scripter scripter, String string, String string2, String[] stringArray, String string3, String[] stringArray2) throws EvalError {
        super(scripter, string, string2, stringArray);
        this.condition = string3;
        this.commands = (String[])stringArray2.clone();
        this.bsh = new Interpreter();
        this.bsh.set("scripter", (Object)scripter);
        this.bsh.set("prefs", (Object)scripter.getPrefs());
        this.bsh.set("connection", (Object)scripter.getConn());
        CommandScript.addImports(this.bsh);
    }

    private static void addImports(Interpreter interpreter) throws EvalError {
        interpreter.eval("import free.jin.*;");
        interpreter.eval("import free.jin.event.*");
        interpreter.eval("import free.chess.*");
    }

    public String getType() {
        return "commands";
    }

    public String getCondition() {
        return this.condition;
    }

    public String[] getCommands() {
        return (String[])this.commands.clone();
    }

    private String preprocess(String string, Object[][] objectArray) {
        Collections.sort(Arrays.asList(objectArray), new Comparator(){

            public int compare(Object object, Object object2) {
                Object[] objectArray = (Object[])object;
                Object[] objectArray2 = (Object[])object2;
                String string = (String)objectArray[0];
                String string2 = (String)objectArray2[0];
                return string2.length() - string.length();
            }
        });
        for (int i = 0; i < objectArray.length; ++i) {
            Object[] objectArray2 = objectArray[i];
            String string2 = (String)objectArray2[0];
            String string3 = String.valueOf(objectArray2[1]);
            Pattern pattern = Pattern.compile("\\$" + string2);
            Matcher matcher = pattern.matcher(string);
            string = matcher.replaceAll(string3);
        }
        return string;
    }

    public void run(JinEvent jinEvent, String string, Object[][] objectArray) {
        try {
            Object object;
            Connection connection;
            int n;
            this.bsh.set("event", (Object)jinEvent);
            this.bsh.set("eventSubtype", (Object)string);
            for (n = 0; n < objectArray.length; ++n) {
                connection = objectArray[n];
                String string2 = (String)connection[0];
                object = connection[1];
                this.bsh.set(string2, object);
            }
            n = ((Boolean)this.bsh.eval(this.condition)).booleanValue() ? 1 : 0;
            if (n == 0) {
                return;
            }
            connection = this.scripter.getConn();
            for (int i = 0; i < this.commands.length; ++i) {
                object = this.preprocess(this.commands[i], objectArray);
                connection.sendCommand((String)object);
            }
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
        }
    }

    public Script createCopy() {
        try {
            CommandScript commandScript = new CommandScript(this.scripter, this.getName(), this.getEventType(), this.getEventSubtypes(), this.getCondition(), this.getCommands());
            commandScript.setEnabled(this.isEnabled());
            return commandScript;
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
            throw new IllegalStateException("EvalError while cloning an existing CommandScript!!!");
        }
    }
}

