/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.validation.client.impl;

import com.google.gwt.validation.client.impl.ConstraintDescriptorImpl;
import com.google.gwt.validation.client.impl.ConstraintOrigin;
import com.google.gwt.validation.client.impl.Group;
import com.google.gwt.validation.client.impl.GroupChain;
import com.google.gwt.validation.client.impl.GroupChainGenerator;
import com.google.gwt.validation.client.impl.metadata.BeanMetadata;
import com.google.gwt.validation.client.impl.metadata.ValidationGroupsMetadata;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.validation.groups.Default;
import javax.validation.metadata.ConstraintDescriptor;
import javax.validation.metadata.ElementDescriptor;
import javax.validation.metadata.Scope;

public final class ConstraintFinderImpl
implements ElementDescriptor.ConstraintFinder {
    private Set<ConstraintDescriptorImpl<?>> constraintDescriptors;
    private ValidationGroupsMetadata validationGroupsMetadata;
    private List<Class<?>> groups;
    private Set<ConstraintOrigin> definedInSet;
    private Set<ElementType> elementTypes;
    private BeanMetadata beanMetadata;

    public ConstraintFinderImpl(BeanMetadata beanMetadata, ValidationGroupsMetadata validationGroupsMetadata, Set<ConstraintDescriptorImpl<?>> constraintDescriptors) {
        this.validationGroupsMetadata = validationGroupsMetadata;
        this.constraintDescriptors = constraintDescriptors;
        this.beanMetadata = beanMetadata;
        this.elementTypes = new HashSet<ElementType>();
        this.elementTypes.add(ElementType.TYPE);
        this.elementTypes.add(ElementType.METHOD);
        this.elementTypes.add(ElementType.FIELD);
        this.definedInSet = new HashSet<ConstraintOrigin>();
        this.definedInSet.add(ConstraintOrigin.DEFINED_LOCALLY);
        this.definedInSet.add(ConstraintOrigin.DEFINED_IN_HIERARCHY);
        this.groups = Collections.emptyList();
    }

    public ElementDescriptor.ConstraintFinder declaredOn(ElementType ... types) {
        this.elementTypes.clear();
        this.elementTypes.addAll(Arrays.asList(types));
        return this;
    }

    public Set<ConstraintDescriptor<?>> getConstraintDescriptors() {
        if (this.validationGroupsMetadata == null) {
            throw new IllegalStateException("ConstraintFinderImpl not initialized properly. A ValidationGroupsMetadata object is required by GWT to properly find all constraint descriptors.");
        }
        HashSet matchingDescriptors = new HashSet();
        this.findMatchingDescriptors(matchingDescriptors);
        return Collections.unmodifiableSet(matchingDescriptors);
    }

    public boolean hasConstraints() {
        return !this.getConstraintDescriptors().isEmpty();
    }

    public ElementDescriptor.ConstraintFinder lookingAt(Scope scope) {
        if (scope.equals((Object)Scope.LOCAL_ELEMENT)) {
            this.definedInSet.remove((Object)ConstraintOrigin.DEFINED_IN_HIERARCHY);
        }
        return this;
    }

    public ElementDescriptor.ConstraintFinder unorderedAndMatchingGroups(Class<?> ... groups) {
        this.groups = new ArrayList();
        for (Class<?> clazz : groups) {
            if (Default.class.equals(clazz) && this.beanMetadata.defaultGroupSequenceIsRedefined()) {
                this.groups.addAll(this.beanMetadata.getDefaultGroupSequence());
                continue;
            }
            this.groups.add(clazz);
        }
        return this;
    }

    private void addMatchingDescriptorsForGroup(Class<?> group, Set<ConstraintDescriptor<?>> matchingDescriptors) {
        for (ConstraintDescriptorImpl<?> descriptor : this.constraintDescriptors) {
            if (!this.definedInSet.contains((Object)descriptor.getDefinedOn()) || !this.elementTypes.contains((Object)descriptor.getElementType()) || !descriptor.getGroups().contains(group)) continue;
            matchingDescriptors.add(descriptor);
        }
    }

    private void findMatchingDescriptors(Set<ConstraintDescriptor<?>> matchingDescriptors) {
        if (!this.groups.isEmpty()) {
            GroupChain groupChain = new GroupChainGenerator(this.validationGroupsMetadata).getGroupChainFor(this.groups);
            Iterator<Group> groupIterator = groupChain.getGroupIterator();
            while (groupIterator.hasNext()) {
                Group g = groupIterator.next();
                this.addMatchingDescriptorsForGroup(g.getGroup(), matchingDescriptors);
            }
        } else {
            for (ConstraintDescriptorImpl<?> descriptor : this.constraintDescriptors) {
                if (!this.definedInSet.contains((Object)descriptor.getDefinedOn()) || !this.elementTypes.contains((Object)descriptor.getElementType())) continue;
                matchingDescriptors.add(descriptor);
            }
        }
    }
}

