/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import com.google.common.collect.ImmutableSortedSet;
import java.util.Comparator;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.initialization.LoadProjectsBuildOperationType;
import org.gradle.initialization.ProjectsIdentifiedProgressDetails;

public class BuildStructureOperationProject
implements LoadProjectsBuildOperationType.Result.Project,
ProjectsIdentifiedProgressDetails.Project {
    private static final Comparator<LoadProjectsBuildOperationType.Result.Project> PROJECT_COMPARATOR = Comparator.comparing(LoadProjectsBuildOperationType.Result.Project::getName);
    private final String name;
    private final String path;
    private final String identityPath;
    private final String projectDir;
    private final String buildFile;
    private final Set<BuildStructureOperationProject> children;

    public BuildStructureOperationProject(String name, String path, String identityPath, String projectDir, String buildFile, Set<BuildStructureOperationProject> children) {
        this.name = name;
        this.path = path;
        this.identityPath = identityPath;
        this.projectDir = projectDir;
        this.buildFile = buildFile;
        this.children = children;
    }

    private static BuildStructureOperationProject convert(Project project) {
        return new BuildStructureOperationProject(project.getName(), project.getPath(), ((ProjectInternal)project).getIdentityPath().toString(), project.getProjectDir().getAbsolutePath(), project.getBuildFile().getAbsolutePath(), BuildStructureOperationProject.convert(ProjectHierarchyUtils.getChildProjectsForInternalUse(project)));
    }

    private static Set<BuildStructureOperationProject> convert(Iterable<Project> children) {
        ImmutableSortedSet.Builder builder = new ImmutableSortedSet.Builder(PROJECT_COMPARATOR);
        for (Project child : children) {
            builder.add((Object)BuildStructureOperationProject.convert(child));
        }
        return builder.build();
    }

    public static BuildStructureOperationProject from(GradleInternal gradle) {
        return BuildStructureOperationProject.convert(gradle.getRootProject());
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getIdentityPath() {
        return this.identityPath;
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    public String getBuildFile() {
        return this.buildFile;
    }

    public Set<BuildStructureOperationProject> getChildren() {
        return this.children;
    }
}

