/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.internal.hash.Hasher;
import org.gradle.internal.hash.HasherExtensions;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.DecoderExtensions;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.EncoderExtensions;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.ValueSnapshotter;
import org.gradle.internal.snapshot.ValueSnapshottingException;

@NonNullApi
public class ArrayOfPrimitiveValueSnapshot
implements ValueSnapshot,
Isolatable<Object> {
    private final PrimitiveType primitiveType;
    private final Object array;

    public ArrayOfPrimitiveValueSnapshot(Object array) {
        this(PrimitiveType.of(array.getClass()), array);
    }

    private ArrayOfPrimitiveValueSnapshot(PrimitiveType primitiveType, Object array) {
        this.primitiveType = primitiveType;
        this.array = array;
    }

    public static ArrayOfPrimitiveValueSnapshot decode(Decoder decoder) throws IOException {
        byte primitiveTypeCode = decoder.readByte();
        PrimitiveType primitiveType = PrimitiveType.fromOrdinal(primitiveTypeCode);
        return new ArrayOfPrimitiveValueSnapshot(primitiveType, primitiveType.decode(decoder));
    }

    public void encode(Encoder encoder) throws IOException {
        encoder.writeByte(this.getPrimitiveTypeCode());
        this.primitiveType.encode(encoder, this.array);
    }

    public int hashCode() {
        return this.primitiveType.hashCode(this.array);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ArrayOfPrimitiveValueSnapshot other = (ArrayOfPrimitiveValueSnapshot)obj;
        return this.primitiveType == other.primitiveType && this.primitiveType.equals(this.array, other.array);
    }

    public String toString() {
        return this.primitiveType.toString(this.array);
    }

    public void appendToHasher(Hasher hasher) {
        this.primitiveType.appendTo(hasher, this.array);
    }

    public ValueSnapshot snapshot(@Nullable Object value, ValueSnapshotter snapshotter) {
        PrimitiveType valueType = PrimitiveType.maybeOfValue(value);
        if (this.primitiveType == valueType && this.primitiveType.equals(this.array, value)) {
            return this;
        }
        ValueSnapshot snapshot = snapshotter.snapshot(value);
        if (snapshot.equals(this)) {
            return this;
        }
        return snapshot;
    }

    public ValueSnapshot asSnapshot() {
        return this;
    }

    public Object isolate() {
        return this.primitiveType.clone(this.array);
    }

    @Nullable
    public <S> S coerce(Class<S> type) {
        return null;
    }

    private byte getPrimitiveTypeCode() {
        return (byte)this.primitiveType.ordinal();
    }

    private static abstract class PrimitiveType
    extends Enum<PrimitiveType> {
        public static final /* enum */ PrimitiveType B = new PrimitiveType((Class)byte[].class){

            @Override
            public Object clone(Object array) {
                return ((byte[])array).clone();
            }

            @Override
            public boolean equals(Object x, Object y) {
                return Arrays.equals((byte[])x, (byte[])y);
            }

            @Override
            public int hashCode(Object array) {
                return Arrays.hashCode((byte[])array);
            }

            @Override
            public String toString(Object array) {
                return Arrays.toString((byte[])array);
            }

            @Override
            public void appendTo(Hasher hasher, Object array) {
                hasher.putBytes((byte[])array);
            }

            @Override
            public void encode(Encoder encoder, Object array) throws IOException {
                encoder.writeBinary((byte[])array);
            }

            @Override
            public Object decode(Decoder decoder) throws IOException {
                return decoder.readBinary();
            }
        };
        public static final /* enum */ PrimitiveType S = new PrimitiveType((Class)short[].class){

            @Override
            public Object clone(Object array) {
                return ((short[])array).clone();
            }

            @Override
            public boolean equals(Object x, Object y) {
                return Arrays.equals((short[])x, (short[])y);
            }

            @Override
            public int hashCode(Object array) {
                return Arrays.hashCode((short[])array);
            }

            @Override
            public String toString(Object array) {
                return Arrays.toString((short[])array);
            }

            @Override
            public void appendTo(Hasher hasher, Object array) {
                HasherExtensions.putShorts((Hasher)hasher, (short[])((short[])array));
            }

            @Override
            public void encode(Encoder encoder, Object array) throws IOException {
                EncoderExtensions.writeLengthPrefixedShorts((Encoder)encoder, (short[])((short[])array));
            }

            @Override
            public Object decode(Decoder decoder) throws IOException {
                return DecoderExtensions.readLengthPrefixedShorts((Decoder)decoder);
            }
        };
        public static final /* enum */ PrimitiveType I = new PrimitiveType((Class)int[].class){

            @Override
            public Object clone(Object array) {
                return ((int[])array).clone();
            }

            @Override
            public boolean equals(Object x, Object y) {
                return Arrays.equals((int[])x, (int[])y);
            }

            @Override
            public int hashCode(Object array) {
                return Arrays.hashCode((int[])array);
            }

            @Override
            public String toString(Object array) {
                return Arrays.toString((int[])array);
            }

            @Override
            public void appendTo(Hasher hasher, Object array) {
                HasherExtensions.putInts((Hasher)hasher, (int[])((int[])array));
            }

            @Override
            public void encode(Encoder encoder, Object array) throws IOException {
                EncoderExtensions.writeLengthPrefixedInts((Encoder)encoder, (int[])((int[])array));
            }

            @Override
            public Object decode(Decoder decoder) throws IOException {
                return DecoderExtensions.readLengthPrefixedInts((Decoder)decoder);
            }
        };
        public static final /* enum */ PrimitiveType J = new PrimitiveType((Class)long[].class){

            @Override
            public Object clone(Object array) {
                return ((long[])array).clone();
            }

            @Override
            public boolean equals(Object x, Object y) {
                return Arrays.equals((long[])x, (long[])y);
            }

            @Override
            public int hashCode(Object array) {
                return Arrays.hashCode((long[])array);
            }

            @Override
            public String toString(Object array) {
                return Arrays.toString((long[])array);
            }

            @Override
            public void appendTo(Hasher hasher, Object array) {
                HasherExtensions.putLongs((Hasher)hasher, (long[])((long[])array));
            }

            @Override
            public void encode(Encoder encoder, Object array) throws IOException {
                EncoderExtensions.writeLengthPrefixedLongs((Encoder)encoder, (long[])((long[])array));
            }

            @Override
            public Object decode(Decoder decoder) throws IOException {
                return DecoderExtensions.readLengthPrefixedLongs((Decoder)decoder);
            }
        };
        public static final /* enum */ PrimitiveType F = new PrimitiveType((Class)float[].class){

            @Override
            public Object clone(Object array) {
                return ((float[])array).clone();
            }

            @Override
            public boolean equals(Object x, Object y) {
                return Arrays.equals((float[])x, (float[])y);
            }

            @Override
            public int hashCode(Object array) {
                return Arrays.hashCode((float[])array);
            }

            @Override
            public String toString(Object array) {
                return Arrays.toString((float[])array);
            }

            @Override
            public void appendTo(Hasher hasher, Object array) {
                HasherExtensions.putFloats((Hasher)hasher, (float[])((float[])array));
            }

            @Override
            public void encode(Encoder encoder, Object array) throws IOException {
                EncoderExtensions.writeLengthPrefixedFloats((Encoder)encoder, (float[])((float[])array));
            }

            @Override
            public Object decode(Decoder decoder) throws IOException {
                return DecoderExtensions.readLengthPrefixedFloats((Decoder)decoder);
            }
        };
        public static final /* enum */ PrimitiveType D = new PrimitiveType((Class)double[].class){

            @Override
            public Object clone(Object array) {
                return ((double[])array).clone();
            }

            @Override
            public boolean equals(Object x, Object y) {
                return Arrays.equals((double[])x, (double[])y);
            }

            @Override
            public int hashCode(Object array) {
                return Arrays.hashCode((double[])array);
            }

            @Override
            public String toString(Object array) {
                return Arrays.toString((double[])array);
            }

            @Override
            public void appendTo(Hasher hasher, Object array) {
                HasherExtensions.putDoubles((Hasher)hasher, (double[])((double[])array));
            }

            @Override
            public void encode(Encoder encoder, Object array) throws IOException {
                EncoderExtensions.writeLengthPrefixedDoubles((Encoder)encoder, (double[])((double[])array));
            }

            @Override
            public Object decode(Decoder decoder) throws IOException {
                return DecoderExtensions.readLengthPrefixedDoubles((Decoder)decoder);
            }
        };
        public static final /* enum */ PrimitiveType C = new PrimitiveType((Class)char[].class){

            @Override
            public Object clone(Object array) {
                return ((char[])array).clone();
            }

            @Override
            public boolean equals(Object x, Object y) {
                return Arrays.equals((char[])x, (char[])y);
            }

            @Override
            public int hashCode(Object array) {
                return Arrays.hashCode((char[])array);
            }

            @Override
            public String toString(Object array) {
                return Arrays.toString((char[])array);
            }

            @Override
            public void appendTo(Hasher hasher, Object array) {
                HasherExtensions.putChars((Hasher)hasher, (char[])((char[])array));
            }

            @Override
            public void encode(Encoder encoder, Object array) throws IOException {
                EncoderExtensions.writeLengthPrefixedChars((Encoder)encoder, (char[])((char[])array));
            }

            @Override
            public Object decode(Decoder decoder) throws IOException {
                return DecoderExtensions.readLengthPrefixedChars((Decoder)decoder);
            }
        };
        public static final /* enum */ PrimitiveType Z = new PrimitiveType((Class)boolean[].class){

            @Override
            public Object clone(Object array) {
                return ((boolean[])array).clone();
            }

            @Override
            public boolean equals(Object x, Object y) {
                return Arrays.equals((boolean[])x, (boolean[])y);
            }

            @Override
            public int hashCode(Object array) {
                return Arrays.hashCode((boolean[])array);
            }

            @Override
            public String toString(Object array) {
                return Arrays.toString((boolean[])array);
            }

            @Override
            public void appendTo(Hasher hasher, Object array) {
                HasherExtensions.putBooleans((Hasher)hasher, (boolean[])((boolean[])array));
            }

            @Override
            public void encode(Encoder encoder, Object array) throws IOException {
                EncoderExtensions.writeLengthPrefixedBooleans((Encoder)encoder, (boolean[])((boolean[])array));
            }

            @Override
            public Object decode(Decoder decoder) throws IOException {
                return DecoderExtensions.readLengthPrefixedBooleans((Decoder)decoder);
            }
        };
        public final Class<?> arrayType;
        private static final /* synthetic */ PrimitiveType[] $VALUES;

        public static PrimitiveType[] values() {
            return (PrimitiveType[])$VALUES.clone();
        }

        public static PrimitiveType valueOf(String name) {
            return Enum.valueOf(PrimitiveType.class, name);
        }

        private PrimitiveType(Class<?> arrayType) {
            this.arrayType = arrayType;
        }

        public abstract Object clone(Object var1);

        public abstract boolean equals(Object var1, Object var2);

        public abstract int hashCode(Object var1);

        public abstract String toString(Object var1);

        public abstract void appendTo(Hasher var1, Object var2);

        public abstract void encode(Encoder var1, Object var2) throws IOException;

        public abstract Object decode(Decoder var1) throws IOException;

        public static PrimitiveType of(Class<?> arrayType) {
            PrimitiveType primitiveType = PrimitiveType.maybeOf(arrayType);
            if (primitiveType == null) {
                throw new ValueSnapshottingException("Unsupported primitive array type: " + arrayType);
            }
            return primitiveType;
        }

        @Nullable
        public static PrimitiveType maybeOfValue(@Nullable Object value) {
            return value != null ? PrimitiveType.maybeOf(value.getClass()) : null;
        }

        @Nullable
        private static PrimitiveType maybeOf(Class<?> arrayType) {
            for (PrimitiveType primitiveType : PrimitiveType.values()) {
                if (primitiveType.arrayType != arrayType) continue;
                return primitiveType;
            }
            return null;
        }

        public static PrimitiveType fromOrdinal(byte ordinal) {
            PrimitiveType[] primitiveTypes = PrimitiveType.values();
            assert (ordinal >= 0 && ordinal < primitiveTypes.length);
            return primitiveTypes[ordinal];
        }

        static {
            $VALUES = new PrimitiveType[]{B, S, I, J, F, D, C, Z};
        }
    }
}

