/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.analysis;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.internal.declarativedsl.analysis.AnalysisContext;
import org.gradle.internal.declarativedsl.analysis.AssignmentRecord;
import org.gradle.internal.declarativedsl.analysis.ErrorCollector;
import org.gradle.internal.declarativedsl.analysis.ExpressionResolver;
import org.gradle.internal.declarativedsl.analysis.ObjectOrigin;
import org.gradle.internal.declarativedsl.analysis.ResolutionError;
import org.gradle.internal.declarativedsl.analysis.ResolutionTrace;
import org.gradle.internal.declarativedsl.analysis.StatementResolver;
import org.gradle.internal.declarativedsl.language.Assignment;
import org.gradle.internal.declarativedsl.language.Expr;
import org.gradle.internal.declarativedsl.language.LanguageTreeElement;
import org.gradle.internal.declarativedsl.language.LocalValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0001\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\"\u001a\u00020\u0016H\u0016J\u0018\u0010$\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00192\u0006\u0010\"\u001a\u00020\u0016H\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/gradle/internal/declarativedsl/analysis/ResolutionTracer;", "Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolver;", "Lorg/gradle/internal/declarativedsl/analysis/StatementResolver;", "Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;", "Lorg/gradle/internal/declarativedsl/analysis/ResolutionTrace;", "expressionResolver", "statementResolver", "errorCollector", "(Lorg/gradle/internal/declarativedsl/analysis/ExpressionResolver;Lorg/gradle/internal/declarativedsl/analysis/StatementResolver;Lorg/gradle/internal/declarativedsl/analysis/ErrorCollector;)V", "assignmentResolutions", "Ljava/util/IdentityHashMap;", "Lorg/gradle/internal/declarativedsl/language/Assignment;", "Lorg/gradle/internal/declarativedsl/analysis/AssignmentRecord;", "elementErrors", "Lorg/gradle/internal/declarativedsl/language/LanguageTreeElement;", "", "Lorg/gradle/internal/declarativedsl/analysis/ResolutionError;", "errors", "", "getErrors", "()Ljava/util/List;", "expressionResolution", "Lorg/gradle/internal/declarativedsl/language/Expr;", "Lorg/gradle/internal/declarativedsl/analysis/ObjectOrigin;", "assignmentResolution", "Lorg/gradle/internal/declarativedsl/analysis/ResolutionTrace$ResolutionOrErrors;", "assignment", "collect", "", "error", "doResolveAssignment", "context", "Lorg/gradle/internal/declarativedsl/analysis/AnalysisContext;", "doResolveExpression", "expr", "doResolveExpressionStatement", "doResolveLocalValue", "localValue", "Lorg/gradle/internal/declarativedsl/language/LocalValue;", "declarative-dsl-core"})
@SourceDebugExtension(value={"SMAP\nResolutionTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionTracer.kt\norg/gradle/internal/declarativedsl/analysis/ResolutionTracer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,104:1\n372#2,7:105\n*S KotlinDebug\n*F\n+ 1 ResolutionTracer.kt\norg/gradle/internal/declarativedsl/analysis/ResolutionTracer\n*L\n97#1:105,7\n*E\n"})
public final class ResolutionTracer
implements ExpressionResolver,
StatementResolver,
ErrorCollector,
ResolutionTrace {
    @NotNull
    private final ExpressionResolver expressionResolver;
    @NotNull
    private final StatementResolver statementResolver;
    @NotNull
    private final ErrorCollector errorCollector;
    @NotNull
    private final IdentityHashMap<Assignment, AssignmentRecord> assignmentResolutions;
    @NotNull
    private final IdentityHashMap<Expr, ObjectOrigin> expressionResolution;
    @NotNull
    private final IdentityHashMap<LanguageTreeElement, List<ResolutionError>> elementErrors;

    public ResolutionTracer(@NotNull ExpressionResolver expressionResolver, @NotNull StatementResolver statementResolver, @NotNull ErrorCollector errorCollector) {
        Intrinsics.checkNotNullParameter((Object)expressionResolver, (String)"expressionResolver");
        Intrinsics.checkNotNullParameter((Object)statementResolver, (String)"statementResolver");
        Intrinsics.checkNotNullParameter((Object)errorCollector, (String)"errorCollector");
        this.expressionResolver = expressionResolver;
        this.statementResolver = statementResolver;
        this.errorCollector = errorCollector;
        this.assignmentResolutions = new IdentityHashMap();
        this.expressionResolution = new IdentityHashMap();
        this.elementErrors = new IdentityHashMap();
    }

    @Override
    @NotNull
    public ResolutionTrace.ResolutionOrErrors<AssignmentRecord> assignmentResolution(@NotNull Assignment assignment) {
        ResolutionTrace.ResolutionOrErrors resolutionOrErrors;
        Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
        AssignmentRecord assignmentRecord = this.assignmentResolutions.get(assignment);
        if (assignmentRecord != null) {
            AssignmentRecord resolution = assignmentRecord;
            boolean bl = false;
            if (!(!((Map)this.elementErrors).containsKey(assignment))) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            resolutionOrErrors = new ResolutionTrace.ResolutionOrErrors.Resolution<AssignmentRecord>(resolution);
        } else {
            List<ResolutionError> list = this.elementErrors.get(assignment);
            if (list != null) {
                List<ResolutionError> errors = list;
                boolean bl = false;
                resolutionOrErrors = new ResolutionTrace.ResolutionOrErrors.Errors(errors);
            } else {
                resolutionOrErrors = ResolutionTrace.ResolutionOrErrors.NoResolution.INSTANCE;
            }
        }
        return resolutionOrErrors;
    }

    @Override
    @NotNull
    public ResolutionTrace.ResolutionOrErrors<ObjectOrigin> expressionResolution(@NotNull Expr expr) {
        ResolutionTrace.ResolutionOrErrors resolutionOrErrors;
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        ObjectOrigin objectOrigin = this.expressionResolution.get(expr);
        if (objectOrigin != null) {
            ObjectOrigin resolution = objectOrigin;
            boolean bl = false;
            if (!(!((Map)this.elementErrors).containsKey(expr))) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            resolutionOrErrors = new ResolutionTrace.ResolutionOrErrors.Resolution<ObjectOrigin>(resolution);
        } else {
            List<ResolutionError> list = this.elementErrors.get(expr);
            if (list != null) {
                List<ResolutionError> errors = list;
                boolean bl = false;
                resolutionOrErrors = new ResolutionTrace.ResolutionOrErrors.Errors(errors);
            } else {
                resolutionOrErrors = ResolutionTrace.ResolutionOrErrors.NoResolution.INSTANCE;
            }
        }
        return resolutionOrErrors;
    }

    @Override
    @Nullable
    public ObjectOrigin doResolveExpression(@NotNull AnalysisContext context, @NotNull Expr expr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        ObjectOrigin result = this.expressionResolver.doResolveExpression(context, expr);
        if (result != null) {
            ((Map)this.expressionResolution).put(expr, result);
        }
        return result;
    }

    @Override
    @Nullable
    public AssignmentRecord doResolveAssignment(@NotNull AnalysisContext context, @NotNull Assignment assignment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)assignment, (String)"assignment");
        AssignmentRecord result = this.statementResolver.doResolveAssignment(context, assignment);
        if (result != null) {
            ((Map)this.assignmentResolutions).put(assignment, result);
        }
        return result;
    }

    @Override
    public void doResolveLocalValue(@NotNull AnalysisContext context, @NotNull LocalValue localValue2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)localValue2, (String)"localValue");
        this.statementResolver.doResolveLocalValue(context, localValue2);
    }

    @Override
    public void doResolveExpressionStatement(@NotNull AnalysisContext context, @NotNull Expr expr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        this.statementResolver.doResolveExpressionStatement(context, expr);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collect(@NotNull ResolutionError error) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        Map map2 = this.elementErrors;
        LanguageTreeElement key$iv = error.getElement();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(error);
        this.errorCollector.collect(error);
    }

    @Override
    @NotNull
    public List<ResolutionError> getErrors() {
        return this.errorCollector.getErrors();
    }
}

