/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.marbl.mhap.main;

import edu.umd.marbl.mhap.utils.Utils;
import java.io.BufferedReader;
import java.util.TreeMap;

public class GetHistogramStats {
    private static final int NUM_SD = 7;
    private TreeMap<Integer, Long> histogram = new TreeMap();
    private double percent = 0.99;
    private double mean = 0.0;
    private double stdev = 0.0;
    private long cut = 0L;

    public GetHistogramStats(String fileName, double p) {
        try {
            BufferedReader bf = Utils.getFile(fileName, null);
            String line = null;
            while ((line = bf.readLine()) != null) {
                String[] split = line.trim().split("\\s+");
                int val = Integer.parseInt(split[0]);
                long count = Long.parseLong(split[1]);
                this.histogram.put(val, count);
            }
            bf.close();
            this.percent = p;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void process() throws NumberFormatException {
        double variance = 0.0;
        double sum = 0.0;
        long total = 0L;
        for (int val : this.histogram.keySet()) {
            long count = this.histogram.get(val);
            for (long i = 0L; i < count; ++i) {
                double delta = (double)val - this.mean;
                this.mean += delta / (double)(++total);
                variance += delta * ((double)val - this.mean);
                sum += (double)val;
            }
        }
        this.stdev = Math.sqrt(variance /= (double)total);
        double runningSum = 0.0;
        for (int val : this.histogram.keySet()) {
            long count;
            if (!((runningSum += (double)val * (double)(count = this.histogram.get(val).longValue())) / sum > this.percent)) continue;
            this.cut = val;
            break;
        }
    }

    public String toString() {
        return Utils.DECIMAL_FORMAT.format(this.mean) + "\t" + Utils.DECIMAL_FORMAT.format(this.stdev) + "\t" + "\t" + this.cut + "\t" + Utils.DECIMAL_FORMAT.format(this.mean + 7.0 * this.stdev);
    }

    public static void main(String[] args) throws NumberFormatException {
        GetHistogramStats s = new GetHistogramStats(args[0], Double.parseDouble(args[1]));
        s.process();
        System.out.println(s.toString());
    }
}

