package org.cdavies.applerecords.search;

import javax.swing.*;
import java.awt.event.*;
import java.util.*;
import java.util.regex.*;
import javax.swing.event.*;
import javax.swing.text.*;

import org.cdavies.applerecords.table.*;
import org.cdavies.itunes.*;
import org.cdavies.applerecords.*;

import javazoom.jl.player.*;

public class SearchPanelActionListener implements DocumentListener {
	
	private TrackListTableModel _model;
	private JTable _table;
	private AppleRecordsStatusPanel _status;
	private AppleRecordsControlPanel _controls;
	private AppleRecordsServerControl _servControl;
	
	public SearchPanelActionListener(TrackListTableModel model, JTable table, AppleRecordsStatusPanel status, AppleRecordsControlPanel controls, AppleRecordsServerControl servControl) {
		
		_model = model;
		_table = table;
		_status = status;
		_controls = controls;
		_servControl = servControl;
		
	}
	
	
	public void insertUpdate(DocumentEvent e) {
		
        _controls.noNextTrack();
		String _text = "";
		
		try {
		
			Document _doc = e.getDocument();
			_text = _doc.getText(0, _doc.getLength());
		
		}
		catch (BadLocationException _e) {
			
			_e.printStackTrace();
			System.exit(1);
			
		}
		
		if (_text.equals(""))
			displayFullLibrary();
		else
			displaySearchResults(_text);
		
    }
    public void removeUpdate(DocumentEvent e) {
		
        _controls.noNextTrack();
		String _text = "";
		
		try {
		
			Document _doc = e.getDocument();
			_text = _doc.getText(0, _doc.getLength());
		
		}
		catch (BadLocationException _e) {
			
			_e.printStackTrace();
			System.exit(1);
			
		}
		
		if (_text.equals(""))
			displayFullLibrary();
		else
			displaySearchResults(_text);
		
    }
    public void changedUpdate(DocumentEvent e) {
        //Plain text components don't fire these events
    }
	
	private void displayFullLibrary() {
		
		ItunesConnection _conn = (ItunesConnection)_servControl.getSelectedItem();
		Track[] _t = _conn.getTracklist(_conn.getDatabases()[0].getId());
		
		Arrays.sort(_t, new TrackComparator());
		
		_model.clear();
		
		for (int _i = 0; _i < _t.length; _i++)
			_model.addRow(_t[_i]);
		
		_table.addNotify();
		_table.validate();
		_table.repaint();
		
	}
	
	private void displaySearchResults(String needle) {
		
		ItunesConnection _conn = (ItunesConnection)_servControl.getSelectedItem();
		Track[] _t = _conn.getTracklist(_conn.getDatabases()[0].getId());
		
		needle = needle.trim();
		
		Arrays.sort(_t, new TrackComparator());
		
		Pattern _matcher = Pattern.compile(".*\\Q" + needle + "\\E.*", Pattern.CASE_INSENSITIVE);
		_model.clear();
		
		for (int _i = 0; _i < _t.length; _i++) {
			
			if (_matcher.matcher(_t[_i].getArtistName()).matches()
					|| _matcher.matcher(_t[_i].getAlbumName()).matches()
					|| _matcher.matcher(_t[_i].getTrackName()).matches())
				_model.addRow(_t[_i]);
			
		}
		
		_table.addNotify();
		_table.validate();
		_table.repaint();
		
		
	}
	
}
