/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.Iterator;
import java.util.Map;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;

public class ShowEnv
extends SigarCommandBase {
    public ShowEnv(Shell shell) {
        super(shell);
    }

    public ShowEnv() {
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    public String getUsageShort() {
        return "Show process environment";
    }

    public boolean isPidCompleter() {
        return true;
    }

    public void output(String[] args) throws SigarException {
        long[] pids = this.shell.findPids(args);
        for (int i = 0; i < pids.length; ++i) {
            try {
                this.println("pid=" + pids[i]);
                this.output(pids[i]);
            }
            catch (SigarException e) {
                this.println(e.getMessage());
            }
            this.println("\n------------------------\n");
        }
    }

    public void output(long pid) throws SigarException {
        Map env = this.proxy.getProcEnv(pid);
        Iterator it = env.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry ent = it.next();
            this.println(ent.getKey() + "=" + ent.getValue());
        }
    }

    public static void main(String[] args) throws Exception {
        new ShowEnv().processCommand(args);
    }
}

