/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.commons.validator.routines.UrlValidator;
import org.omegat.util.Java8Compat;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DesktopWrapper;
import org.omegat.util.gui.Styles;

public final class JTextPaneLinkifier {
    private static final String ATTR_LINK = "linkbuilder_link";

    private JTextPaneLinkifier() {
    }

    public static void linkify(JTextPane jTextPane) {
        JTextPaneLinkifier.linkify(jTextPane, false);
    }

    public static void linkify(JTextPane jTextPane, boolean extended) {
        AttributeInserterMouseListener mouseAdapter = new AttributeInserterMouseListener(jTextPane);
        jTextPane.addMouseListener(mouseAdapter);
        jTextPane.addMouseMotionListener(mouseAdapter);
        JTextPaneLinkifier.setDocumentFilter(jTextPane, extended);
        jTextPane.addPropertyChangeListener("document", evt -> {
            Object source = evt.getSource();
            if (source instanceof JTextPane) {
                JTextPaneLinkifier.setDocumentFilter((JTextPane)source, extended);
            }
        });
    }

    private static void setDocumentFilter(JTextPane textPane, boolean extended) {
        StyledDocument doc = textPane.getStyledDocument();
        if (doc instanceof AbstractDocument) {
            AbstractDocument abstractDocument = (AbstractDocument)((Object)doc);
            abstractDocument.setDocumentFilter(new AttributeInserterDocumentFilter(doc, extended));
        }
    }

    private static class AttributeInserterDocumentFilter
    extends DocumentFilter {
        private static final int REFRESH_DELAY = 200;
        private static final AttributeSet LINK_ATTRIBUTES;
        private final StyledDocument doc;
        private final Timer timer;
        private final Pattern[] urlPatterns;

        AttributeInserterDocumentFilter(StyledDocument doc, boolean extended) {
            this.doc = doc;
            Pattern urlPattern = Pattern.compile("\\bhttps?://\\S+\\b", 2);
            if (extended) {
                Pattern filePattern = Pattern.compile("\\\\bfile://[-A-Za-z0-9+$&@#/%?=~_|!:,.;]*[-A-Za-z0-9+$&@#/%=~_|]\\b", 2);
                this.urlPatterns = new Pattern[]{urlPattern, filePattern};
            } else {
                this.urlPatterns = new Pattern[]{urlPattern};
            }
            this.timer = new Timer(200, e -> this.refreshPane());
            this.timer.setRepeats(false);
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            super.insertString(fb, offset, string, attr);
            if (attr == null || !attr.isDefined(StyleConstants.ComposedTextAttribute)) {
                SwingUtilities.invokeLater(this::refreshPane);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            boolean refresh = true;
            AttributeSet attr = ((StyledDocument)fb.getDocument()).getCharacterElement(offset).getAttributes();
            if (attr != null && attr.isDefined(StyleConstants.ComposedTextAttribute)) {
                refresh = false;
            }
            super.remove(fb, offset, length);
            if (refresh && length != 0 && fb.getDocument().getLength() != 0) {
                this.timer.restart();
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(fb, offset, length, text, attrs);
            if (fb.getDocument().getLength() != 0) {
                this.timer.restart();
            }
        }

        private void refreshPane() {
            if (this.doc.getLength() == 0) {
                return;
            }
            try {
                URLCodec codec = new URLCodec("UTF-8");
                UrlValidator urlValidator = new UrlValidator();
                for (Pattern pattern : this.urlPatterns) {
                    int shift = 0;
                    String text = this.doc.getText(0, this.doc.getLength());
                    Matcher matcher = pattern.matcher(text);
                    while (matcher.find()) {
                        int offset = matcher.start() + shift;
                        if (this.doc.getCharacterElement(offset).getAttributes().containsAttributes(LINK_ATTRIBUTES)) continue;
                        int targetLength = matcher.end() - matcher.start();
                        String uri = matcher.group();
                        if (!urlValidator.isValid(uri)) continue;
                        try {
                            SimpleAttributeSet atts;
                            String decoded = codec.decode(uri);
                            if (decoded.length() == uri.length()) {
                                atts = new SimpleAttributeSet(this.doc.getCharacterElement(offset).getAttributes());
                                this.setLinkAttribute(atts, new URI(uri));
                                this.doc.setCharacterAttributes(offset, targetLength, atts, true);
                                continue;
                            }
                            shift += decoded.length() - targetLength;
                            this.doc.remove(offset, targetLength);
                            atts = new SimpleAttributeSet();
                            this.setLinkAttribute(atts, new URI(uri));
                            this.doc.insertString(offset, decoded, atts);
                        }
                        catch (URISyntaxException | DecoderException ex) {
                            Log.logWarningRB("TPL_ERROR_URL", matcher.group());
                        }
                    }
                }
            }
            catch (BadLocationException ex) {
                Log.log(ex);
            }
        }

        private void setLinkAttribute(SimpleAttributeSet atts, URI target) {
            atts.addAttributes(LINK_ATTRIBUTES);
            atts.addAttribute(JTextPaneLinkifier.ATTR_LINK, () -> {
                try {
                    DesktopWrapper.browse(target);
                }
                catch (Exception e) {
                    JOptionPane.showConfirmDialog(null, e.getLocalizedMessage(), OStrings.getString("ERROR_TITLE"), 0);
                    Log.log(e);
                }
            });
        }

        static {
            SimpleAttributeSet tmp = new SimpleAttributeSet();
            StyleConstants.setUnderline(tmp, true);
            StyleConstants.setForeground(tmp, Styles.EditorColor.COLOR_HYPERLINK.getColor());
            StyleConstants.setBackground(tmp, Styles.EditorColor.COLOR_BACKGROUND.getColor());
            LINK_ATTRIBUTES = tmp;
        }
    }

    private static class AttributeInserterMouseListener
    extends MouseAdapter {
        private final JTextPane jTextPane;

        AttributeInserterMouseListener(JTextPane jTextPane) {
            this.jTextPane = jTextPane;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getButton() == 1) {
                StyledDocument doc = this.jTextPane.getStyledDocument();
                Element characterElement = doc.getCharacterElement(Java8Compat.viewToModel(this.jTextPane, e.getPoint()));
                AttributeSet as = characterElement.getAttributes();
                Object attr = as.getAttribute(JTextPaneLinkifier.ATTR_LINK);
                if (attr instanceof IAttributeAction) {
                    ((IAttributeAction)attr).execute();
                }
            } else {
                super.mouseClicked(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            StyledDocument doc = this.jTextPane.getStyledDocument();
            Element characterElement = doc.getCharacterElement(Java8Compat.viewToModel(this.jTextPane, e.getPoint()));
            AttributeSet as = characterElement.getAttributes();
            Object attr = as.getAttribute(JTextPaneLinkifier.ATTR_LINK);
            if (attr instanceof IAttributeAction) {
                this.jTextPane.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.jTextPane.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private static interface IAttributeAction {
        public void execute();
    }
}

