/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public final class MemoryUtils {
    protected static final boolean IS64 = !"32".equals(System.getProperty("sun.arch.data.model"));
    protected static final int SZ_OBJFOOT = IS64 ? 16 : 8;
    protected static final int SZ_OBJLINK = IS64 ? 8 : 4;

    private MemoryUtils() {
    }

    public static long getMemoryUsed() {
        return Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
    }

    public static long getMemoryAllocated() {
        return Runtime.getRuntime().totalMemory();
    }

    public static long getMemoryLimit() {
        return Runtime.getRuntime().maxMemory();
    }

    public static long calcObjectSize(Object obj) {
        long result;
        if (obj == null) {
            return 0L;
        }
        Class<?> oc = obj.getClass();
        if (oc == String.class) {
            String s = (String)obj;
            return SZ_OBJFOOT + SZ_OBJLINK + 4 + 4 + 4 + s.length() * 2;
        }
        try {
            if (oc.isArray()) {
                result = MemoryUtils.getSimpleTypeSize(oc.getComponentType()) * (long)Array.getLength(obj);
                if (!oc.getComponentType().isPrimitive()) {
                    for (int i = 0; i < Array.getLength(obj); ++i) {
                        Object v = Array.get(obj, i);
                        result += MemoryUtils.calcObjectSize(v);
                    }
                }
            } else {
                result = SZ_OBJFOOT;
                Field[] fields = oc.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    boolean achanged;
                    Field f = fields[i];
                    if (Modifier.isStatic(f.getModifiers())) continue;
                    Class<?> fc = f.getType();
                    result += MemoryUtils.getSimpleTypeSize(fc);
                    if (fc.isPrimitive()) continue;
                    boolean bl = achanged = !f.isAccessible();
                    if (achanged) {
                        f.setAccessible(true);
                    }
                    Object v = f.get(obj);
                    if (achanged) {
                        f.setAccessible(false);
                    }
                    result += MemoryUtils.calcObjectSize(v);
                }
            }
        }
        catch (Exception ex) {
            result = -1L;
        }
        return result;
    }

    protected static long getSimpleTypeSize(Class<?> oc) {
        long result = oc == Byte.TYPE ? 1L : (oc == Short.TYPE ? 2L : (oc == Integer.TYPE ? 4L : (oc == Long.TYPE ? 8L : (oc == Character.TYPE ? 2L : (oc == Boolean.TYPE ? 1L : (oc == Float.TYPE ? 4L : (oc == Double.TYPE ? 8L : (long)SZ_OBJLINK)))))));
        return result;
    }
}

