/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.CancelPanelListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.TimerHolder;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

class CancelPanelCtrl {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(CancelPanelCtrl.class);
    private CancelPanel _panel;
    private int _queryCount;
    private int _currentQueryIndex = 0;
    private CancelPanelListener _listener;
    private final TimerHolder _timer;

    CancelPanelCtrl(CancelPanelListener listener, ISession session) {
        this._listener = listener;
        this._panel = new CancelPanel(session);
        this._panel.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CancelPanelCtrl.this.onCancel();
            }
        });
        this._panel.closeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CancelPanelCtrl.this.onClose();
            }
        });
        this._timer = new TimerHolder(this._panel.txtExecTimeCounter);
    }

    void incCurrentQueryIndex() {
        ++this._currentQueryIndex;
    }

    void setSQL(final String sql) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String label = s_stringMgr.getString("SQLResultExecuterPanel.currentSQLLabel", String.valueOf(CancelPanelCtrl.this._currentQueryIndex), String.valueOf(CancelPanelCtrl.this._queryCount), sql);
                ((CancelPanelCtrl)CancelPanelCtrl.this)._panel.sqlLbl.setText(label);
            }
        };
        GUIUtils.processOnSwingEventThread(runnable);
    }

    void setStatusLabel(final String text) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ((CancelPanelCtrl)CancelPanelCtrl.this)._panel.currentStatusLbl.setText(text);
            }
        };
        GUIUtils.processOnSwingEventThread(runnable);
    }

    void setQueryCount(int value) {
        this._queryCount = value;
        this._currentQueryIndex = 0;
    }

    int getTotalCount() {
        return this._queryCount;
    }

    int getCurrentQueryIndex() {
        return this._currentQueryIndex;
    }

    private void onCancel() {
        this._listener.cancelRequested();
    }

    private void onClose() {
        this._panel.cancelBtn.doClick();
        this._listener.closeRquested();
    }

    CancelPanel getPanel() {
        return this._panel;
    }

    public void wasRemoved() {
        this._timer.stop();
    }
}

