/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.Window;
import java.beans.PropertyVetoException;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.SessionWindowsHolder;
import net.sourceforge.squirrel_sql.client.gui.db.AliasWindowManager;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesList;
import net.sourceforge.squirrel_sql.client.gui.db.AliasesListInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.DriverWindowManager;
import net.sourceforge.squirrel_sql.client.gui.db.DriversList;
import net.sourceforge.squirrel_sql.client.gui.db.DriversListInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAlias;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.DialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IDesktopContainer;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.ISessionWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SelectWidgetAction;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SelectWidgetCommand;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionDialogWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionTabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetListener;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrameWindowState;
import net.sourceforge.squirrel_sql.client.gui.mainframe.WidgetUtils;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.util.ThreadCheckingRepaintManager;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasFileOpenAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasPropertiesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CollapseAllAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyToPasteAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CreateAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CreateDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CutAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DeleteAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DeleteDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ExpandAllAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.NewAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.PasteAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ShowDriverWebsiteAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.SortAliasesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ToggleTreeViewAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewAliasesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewDriversAction;
import net.sourceforge.squirrel_sql.client.preferences.SquirrelPreferences;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.SessionManager;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.client.session.properties.EditWhereColsSheet;
import net.sourceforge.squirrel_sql.client.session.properties.SessionPropertiesSheet;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.SQLFilterSheet;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.gui.WindowState;
import net.sourceforge.squirrel_sql.fw.gui.debug.DebugEventListener;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class WindowManager {
    private static final ILogger s_log = LoggerController.createLogger(WindowManager.class);
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(WindowManager.class);
    private static final String MENU = WindowManager.class.getName() + ".menu";
    private final IApplication _app;
    private final DriverWindowManager _driverWinMgr;
    private final AliasWindowManager _aliasWinMgr;
    private MainFrame _mainFrame;
    private AliasesListInternalFrame _aliasesListWindow;
    private DriversListInternalFrame _driversListWindow;
    private final SessionWindowsHolder _sessionWindows = new SessionWindowsHolder();
    private final SessionWindowListener _windowListener = new SessionWindowListener();
    private final SessionListener _sessionListener = new SessionListener();
    private final EventListenerList _listenerList = new EventListenerList();
    private boolean _sessionClosing = false;

    public WindowManager(IApplication app, boolean enableUserInterfaceDebug) {
        if (app == null) {
            throw new IllegalArgumentException("IApplication == null");
        }
        if (s_log.isDebugEnabled()) {
            RepaintManager.setCurrentManager(new ThreadCheckingRepaintManager());
        }
        this._app = app;
        this._aliasWinMgr = new AliasWindowManager(this._app);
        this._driverWinMgr = new DriverWindowManager(this._app);
        GUIUtils.processOnSwingEventThread(new Runnable(){

            @Override
            public void run() {
                WindowManager.this.initialize();
            }
        }, true);
        new DebugEventListener().setEnabled(enableUserInterfaceDebug);
    }

    public MainFrame getMainFrame() {
        return this._mainFrame;
    }

    public AliasesListInternalFrame getAliasesListInternalFrame() {
        return this._aliasesListWindow;
    }

    public DriversListInternalFrame getDriversListInternalFrame() {
        return this._driversListWindow;
    }

    public WindowState getAliasesWindowState() {
        return new WindowState(this._aliasesListWindow.getInternalFrame());
    }

    public WindowState getDriversWindowState() {
        return new WindowState(this._driversListWindow.getInternalFrame());
    }

    public void showModifyAliasInternalFrame(ISQLAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException("ISQLAlias == null");
        }
        this._aliasWinMgr.showModifyAliasInternalFrame(alias);
    }

    public void showNewAliasInternalFrame() {
        this._aliasWinMgr.showNewAliasInternalFrame();
    }

    public void showCopyAliasInternalFrame(SQLAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException("ISQLAlias == null");
        }
        this._aliasWinMgr.showCopyAliasInternalFrame(alias);
    }

    public void showModifyDriverInternalFrame(ISQLDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        this._driverWinMgr.showModifyDriverInternalFrame(driver);
    }

    public void showNewDriverInternalFrame() {
        this._driverWinMgr.showNewDriverInternalFrame();
    }

    public void showCopyDriverInternalFrame(ISQLDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException("ISQLDriver == null");
        }
        this._driverWinMgr.showCopyDriverInternalFrame(driver);
    }

    public synchronized void registerSessionSheet(ISessionWidget sheet) {
        String dbg = s_stringMgr.getString("WindowManager.registerSessionSheet", sheet.getClass().getName());
        s_log.debug(dbg);
        IIdentifier sessionIdentifier = sheet.getSession().getIdentifier();
        int idx = this._sessionWindows.addFrame(sessionIdentifier, sheet);
        if (idx > 1) {
            sheet.setTitle(sheet.getTitle() + " (" + idx + ")");
        }
        sheet.addWidgetListener(this._windowListener);
    }

    public void addSessionWidgetListener(WidgetAdapter listener) {
        if (listener == null) {
            throw new IllegalArgumentException("InternalFrameListener == null");
        }
        this._listenerList.add(WidgetListener.class, listener);
    }

    public synchronized SessionInternalFrame createInternalFrame(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        final SessionInternalFrame sif = new SessionInternalFrame(session);
        sif.setTip(session.getAlias().getUrl());
        session.setSessionInternalFrame(sif);
        this._app.getPluginManager().sessionStarted(session);
        this._app.getMainFrame().addWidget(sif);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                sif.setVisible(true);
                sif.getObjectTreeAPI().selectRoot();
            }
        });
        return sif;
    }

    public synchronized SQLInternalFrame createSQLInternalFrame(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        final SQLInternalFrame sif = new SQLInternalFrame(session);
        this.getMainFrame().addWidget(sif);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                sif.setVisible(true);
                sif.requestFocus();
            }
        });
        return sif;
    }

    public synchronized ObjectTreeInternalFrame createObjectTreeInternalFrame(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        final ObjectTreeInternalFrame oif = new ObjectTreeInternalFrame(session);
        this.getMainFrame().addWidget(oif);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                oif.setVisible(true);
                oif.getObjectTreeAPI().selectRoot();
            }
        });
        return oif;
    }

    public synchronized void showSessionPropertiesDialog(ISession session, int tabIndexToSelect) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        SessionPropertiesSheet propsSheet = this.getSessionPropertiesDialog(session);
        if (propsSheet == null) {
            propsSheet = new SessionPropertiesSheet(session);
            this._app.getMainFrame().addWidget(propsSheet);
            this.positionSheet(propsSheet);
        } else {
            propsSheet.moveToFront();
        }
        propsSheet.selectTabIndex(tabIndexToSelect);
    }

    public synchronized SQLFilterSheet showSQLFilterDialog(IObjectTreeAPI objectTree, IDatabaseObjectInfo objectInfo) {
        if (objectTree == null) {
            throw new IllegalArgumentException("IObjectTree == null");
        }
        if (objectInfo == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo == null");
        }
        SQLFilterSheet sqlFilterSheet = this.getSQLFilterSheet(objectTree, objectInfo);
        if (sqlFilterSheet == null) {
            sqlFilterSheet = new SQLFilterSheet(objectTree, objectInfo);
            this._app.getMainFrame().addWidget(sqlFilterSheet);
            this.positionSheet(sqlFilterSheet);
        } else {
            sqlFilterSheet.moveToFront();
        }
        return sqlFilterSheet;
    }

    public synchronized EditWhereColsSheet showEditWhereColsDialog(IObjectTreeAPI tree, IDatabaseObjectInfo objectInfo) {
        if (tree == null) {
            throw new IllegalArgumentException("IObjectTreeAPI == null");
        }
        if (objectInfo == null) {
            throw new IllegalArgumentException("IDatabaseObjectInfo == null");
        }
        ISession session = tree.getSession();
        EditWhereColsSheet editWhereColsSheet = this.getEditWhereColsSheet(session, objectInfo);
        if (editWhereColsSheet == null) {
            editWhereColsSheet = new EditWhereColsSheet(session, objectInfo);
            this._app.getMainFrame().addWidget(editWhereColsSheet);
            this.positionSheet(editWhereColsSheet);
        } else {
            editWhereColsSheet.moveToFront();
        }
        return editWhereColsSheet;
    }

    public void moveToFront(final Window win) {
        if (win != null) {
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    win.toFront();
                    win.setVisible(true);
                }
            });
        }
    }

    public void moveToFront(final JInternalFrame fr) {
        if (fr != null) {
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    fr.moveToFront();
                    fr.setVisible(true);
                    try {
                        fr.setSelected(true);
                    }
                    catch (PropertyVetoException ex) {
                        s_log.error(s_stringMgr.getString("WindowManager.error.bringtofront"), ex);
                    }
                }
            });
        }
    }

    public void activateNextSessionWindow() {
        SessionManager sessMgr = this._app.getSessionManager();
        ISession sess = sessMgr.getActiveSession();
        if (sess == null) {
            return;
        }
        ISessionWidget activeSessionWindow = sess.getActiveSessionWindow();
        if (null == activeSessionWindow) {
            throw new IllegalStateException("Active Session with no active window ???");
        }
        ISessionWidget nextSessionWindow = this._sessionWindows.getNextSessionWindow(activeSessionWindow);
        if (!activeSessionWindow.equals(nextSessionWindow)) {
            new SelectWidgetCommand(nextSessionWindow).execute();
        }
    }

    public void activatePreviousSessionWindow() {
        SessionManager sessMgr = this._app.getSessionManager();
        ISession sess = sessMgr.getActiveSession();
        if (sess == null) {
            return;
        }
        ISessionWidget activeSessionWindow = sess.getActiveSessionWindow();
        if (null == activeSessionWindow) {
            throw new IllegalStateException("Active Session with no active window ???");
        }
        ISessionWidget previousSessionWindow = this._sessionWindows.getPreviousSessionWindow(activeSessionWindow);
        if (!activeSessionWindow.equals(previousSessionWindow)) {
            new SelectWidgetCommand(previousSessionWindow).execute();
        }
    }

    protected void refireSessionSheetOpened(WidgetEvent evt) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WidgetListener.class) continue;
            ((WidgetListener)listeners[i + 1]).widgetOpened(evt);
        }
    }

    protected void refireSessionSheetClosing(WidgetEvent evt) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WidgetListener.class) continue;
            ((WidgetListener)listeners[i + 1]).widgetClosing(evt);
        }
    }

    protected void refireSessionSheetClosed(WidgetEvent evt) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WidgetListener.class) continue;
            ((WidgetListener)listeners[i + 1]).widgetClosed(evt);
        }
    }

    protected void refireSessionSheetIconified(WidgetEvent evt) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WidgetListener.class) continue;
            ((WidgetListener)listeners[i + 1]).widgetIconified(evt);
        }
    }

    protected void refireSessionSheetDeiconified(WidgetEvent evt) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WidgetListener.class) continue;
            ((WidgetListener)listeners[i + 1]).widgetDeiconified(evt);
        }
    }

    protected void refireSessionSheetActivated(WidgetEvent evt) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WidgetListener.class) continue;
            ((WidgetListener)listeners[i + 1]).widgetActivated(evt);
        }
    }

    protected void refireSessionSheetDeactivated(WidgetEvent evt) {
        Object[] listeners = this._listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != WidgetListener.class) continue;
            ((WidgetListener)listeners[i + 1]).widgetDeactivated(evt);
        }
    }

    private SessionPropertiesSheet getSessionPropertiesDialog(ISession session) {
        ISessionWidget[] framesOfSession = this._sessionWindows.getFramesOfSession(session.getIdentifier());
        for (int i = 0; i < framesOfSession.length; ++i) {
            if (!(framesOfSession[i] instanceof SessionPropertiesSheet)) continue;
            return (SessionPropertiesSheet)framesOfSession[i];
        }
        return null;
    }

    private SQLFilterSheet getSQLFilterSheet(IObjectTreeAPI tree, IDatabaseObjectInfo objectInfo) {
        ISession session = tree.getSession();
        ISessionWidget[] framesOfSession = this._sessionWindows.getFramesOfSession(session.getIdentifier());
        for (int i = 0; i < framesOfSession.length; ++i) {
            SQLFilterSheet sfs;
            if (!(framesOfSession[i] instanceof SQLFilterSheet) || (sfs = (SQLFilterSheet)framesOfSession[i]).getObjectTree() != tree || !objectInfo.equals(sfs.getDatabaseObjectInfo())) continue;
            return sfs;
        }
        return null;
    }

    private EditWhereColsSheet getEditWhereColsSheet(ISession session, IDatabaseObjectInfo objectInfo) {
        ISessionWidget[] framesOfSession = this._sessionWindows.getFramesOfSession(session.getIdentifier());
        for (int i = 0; i < framesOfSession.length; ++i) {
            EditWhereColsSheet sfs;
            if (!(framesOfSession[i] instanceof EditWhereColsSheet) || !objectInfo.equals((sfs = (EditWhereColsSheet)framesOfSession[i]).getDatabaseObjectInfo())) continue;
            return sfs;
        }
        return null;
    }

    private void positionSheet(SessionDialogWidget sfs) {
        DialogWidget.centerWithinDesktop(sfs);
        sfs.moveToFront();
    }

    private void selectFrontWindow() {
        IWidget[] jifs;
        if (!this._app.getDesktopStyle().isInternalFrameStyle()) {
            return;
        }
        IDesktopContainer desktop = this._app.getMainFrame().getDesktopContainer();
        if (desktop != null && (jifs = desktop.getAllWidgets()) != null && jifs.length > 0) {
            jifs[0].moveToFront();
        }
    }

    private void initialize() {
        this.createAliasesListUI();
        this.createDriversListUI();
        this.preLoadActions();
        this._app.getSessionManager().addSessionListener(this._sessionListener);
        this.createMainFrame();
        this.setupFromPreferences();
    }

    private void createMainFrame() {
        this._mainFrame = new MainFrame(this._app);
    }

    private void createAliasesListUI() {
        AliasesList al = new AliasesList(this._app);
        ActionCollection actions = this._app.getActionCollection();
        actions.add(new ModifyAliasAction(this._app, al));
        actions.add(new DeleteAliasAction(this._app, al));
        actions.add(new CopyAliasAction(this._app, al));
        actions.add(new ConnectToAliasAction(this._app, al));
        actions.add(new CreateAliasAction(this._app));
        actions.add(new SortAliasesAction(this._app, al));
        actions.add(new AliasPropertiesAction(this._app, al));
        actions.add(new AliasFileOpenAction(this._app, al));
        actions.add(new ToggleTreeViewAction(this._app, al));
        actions.add(new NewAliasFolderAction(this._app, al));
        actions.add(new CopyToPasteAliasFolderAction(this._app, al));
        actions.add(new CutAliasFolderAction(this._app, al));
        actions.add(new PasteAliasFolderAction(this._app, al));
        actions.add(new CollapseAllAliasFolderAction(this._app, al));
        actions.add(new ExpandAllAliasFolderAction(this._app, al));
        this._aliasesListWindow = new AliasesListInternalFrame(this._app, al);
    }

    private void createDriversListUI() {
        DriversList dl = new DriversList(this._app);
        ActionCollection actions = this._app.getActionCollection();
        actions.add(new ModifyDriverAction(this._app, dl));
        actions.add(new DeleteDriverAction(this._app, dl));
        actions.add(new CopyDriverAction(this._app, dl));
        actions.add(new CreateDriverAction(this._app));
        actions.add(new ShowDriverWebsiteAction(this._app, dl));
        this._driversListWindow = new DriversListInternalFrame(this._app, dl);
    }

    private void preLoadActions() {
        ActionCollection actions = this._app.getActionCollection();
        if (actions == null) {
            throw new IllegalStateException("ActionCollection hasn't been created.");
        }
        actions.add(new ViewAliasesAction(this._app, this.getAliasesListInternalFrame()));
        actions.add(new ViewDriversAction(this._app, this.getDriversListInternalFrame()));
    }

    private void setupFromPreferences() {
        SquirrelPreferences prefs = this._app.getSquirrelPreferences();
        MainFrameWindowState ws = prefs.getMainFrameWindowState();
        this.prepareAliasWindow(ws);
        this.prepareDriversWindow(ws);
        prefs.setMainFrameWindowState(new MainFrameWindowState(this));
    }

    private void prepareDriversWindow(MainFrameWindowState ws) {
        this._mainFrame.addWidget(this._driversListWindow);
        WindowState toolWs = ws.getDriversWindowState();
        this._driversListWindow.setBounds(toolWs.getBounds().createRectangle());
        if (toolWs.isVisible() && this._app.getDesktopStyle().isInternalFrameStyle()) {
            this._driversListWindow.setVisible(true);
            this._mainFrame.setEnabledDriversMenu(true);
            try {
                this._driversListWindow.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                s_log.error(s_stringMgr.getString("WindowManager.errorselectingwindow"), ex);
            }
        } else {
            this._driversListWindow.setVisible(false);
            this._mainFrame.setEnabledDriversMenu(false);
        }
    }

    private void prepareAliasWindow(MainFrameWindowState ws) {
        this._mainFrame.addWidget(this._aliasesListWindow);
        WindowState toolWs = ws.getAliasesWindowState();
        this._aliasesListWindow.setBounds(toolWs.getBounds().createRectangle());
        if (toolWs.isVisible() && this._app.getDesktopStyle().isInternalFrameStyle() || !this._app.getDesktopStyle().isInternalFrameStyle() && !this._aliasesListWindow.isEmpty()) {
            this._aliasesListWindow.setVisible(true);
            this._mainFrame.setEnabledAliasesMenu(true);
            try {
                this._aliasesListWindow.setSelected(true);
            }
            catch (PropertyVetoException ex) {
                s_log.error(s_stringMgr.getString("WindowManager.errorselectingwindow"), ex);
            }
        } else if (!this._app.getDesktopStyle().isInternalFrameStyle()) {
            this._aliasesListWindow.setVisible(false);
            this._mainFrame.setEnabledAliasesMenu(false);
        }
    }

    private IWidget getWidgetForSession(ISession session) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        ISessionWidget firstWindow = null;
        ISessionWidget[] framesOfSession = this._sessionWindows.getFramesOfSession(session.getIdentifier());
        for (int i = 0; i < framesOfSession.length; ++i) {
            SessionInternalFrame sif;
            if (framesOfSession[i] instanceof ISessionWidget) {
                firstWindow = framesOfSession[i];
            }
            if (!(framesOfSession[i] instanceof SessionInternalFrame) || !(sif = (SessionInternalFrame)framesOfSession[i]).getSession().equals(session)) continue;
            return sif;
        }
        return firstWindow;
    }

    public ISessionWidget[] getAllFramesOfSession(IIdentifier sessionIdentifier) {
        return this._sessionWindows.getFramesOfSession(sessionIdentifier);
    }

    public void setEnabledSessionMenu(boolean b) {
        this.getMainFrame().getSessionMenu().setEnabled(b);
    }

    private void addWidgetToWindowMenu(IWidget widget) {
        JMenu menu = this.getMainFrame().getWindowsMenu();
        SelectWidgetAction action = new SelectWidgetAction(widget);
        JMenuItem menuItem = menu.add(action);
        widget.putClientProperty(MENU, menuItem);
    }

    public void removeWidgetFromWindowMenu(IWidget widget) {
        JMenu menu;
        JMenuItem menuItem = (JMenuItem)widget.getClientProperty(MENU);
        if (menuItem != null && (menu = this.getMainFrame().getWindowsMenu()) != null) {
            menu.remove(menuItem);
        }
    }

    private final class SessionListener
    extends SessionAdapter {
        private SessionListener() {
        }

        @Override
        public void sessionConnected(SessionEvent evt) {
            evt.getSession().setMessageHandler(WindowManager.this._app.getMessageHandler());
        }

        @Override
        public void sessionActivated(SessionEvent evt) {
            ISession newSession = evt.getSession();
            WindowManager.this._app.getActionCollection().setCurrentSession(newSession);
            ISession currSession = null;
            IWidget sif = WindowManager.this.getMainFrame().getDesktopContainer().getSelectedWidget();
            if (sif instanceof ISessionWidget) {
                currSession = ((ISessionWidget)sif).getSession();
            }
            if (currSession != newSession && (sif = WindowManager.this.getWidgetForSession(newSession)) != null) {
                sif.moveToFront();
            }
            GUIUtils.processOnSwingEventThread(new Runnable(){

                @Override
                public void run() {
                    WindowManager.this.getMainFrame().getSessionMenu().setEnabled(true);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sessionClosing(SessionEvent evt) {
            WindowManager.this.getMainFrame().getSessionMenu().setEnabled(false);
            WindowManager.this._app.getActionCollection().setCurrentSession(null);
            try {
                if (WindowManager.this._sessionClosing) {
                    return;
                }
                WindowManager.this._sessionClosing = true;
                IIdentifier sessionId = evt.getSession().getIdentifier();
                ISessionWidget[] framesOfSession = WindowManager.this._sessionWindows.getFramesOfSession(sessionId);
                for (int i = 0; i < framesOfSession.length; ++i) {
                    if (framesOfSession[i] instanceof SessionTabWidget) {
                        framesOfSession[i].closeFrame(false);
                        continue;
                    }
                    framesOfSession[i].closeFrame(true);
                }
                WindowManager.this._sessionWindows.removeAllWindows(sessionId);
                WindowManager.this.selectFrontWindow();
            }
            finally {
                WindowManager.this._sessionClosing = false;
            }
        }
    }

    private final class SessionWindowListener
    implements WidgetListener {
        private SessionWindowListener() {
        }

        @Override
        public void widgetOpened(WidgetEvent evt) {
            IWidget widget = evt.getWidget();
            if (null != evt.getTabHandleEvent() && evt.getTabHandleEvent().isWasAddedToToMainApplicationWindow()) {
                WindowManager.this.addWidgetToWindowMenu(widget);
            }
            IWidget[] frames = WidgetUtils.getOpenNonToolWindows(WindowManager.this.getMainFrame().getDesktopContainer().getAllWidgets());
            WindowManager.this._app.getActionCollection().internalFrameOpenedOrClosed(frames.length);
            WindowManager.this.refireSessionSheetOpened(evt);
        }

        @Override
        public void widgetClosing(WidgetEvent evt) {
            WindowManager.this.refireSessionSheetClosing(evt);
        }

        @Override
        public void widgetClosed(WidgetEvent evt) {
            IWidget widget = evt.getWidget();
            if (!WindowManager.this._sessionClosing && widget instanceof ISessionWidget) {
                ISessionWidget sessionWidget = (ISessionWidget)widget;
                IIdentifier sessionID = sessionWidget.getSession().getIdentifier();
                ISessionWidget[] sessionSheets = WindowManager.this._sessionWindows.getFramesOfSession(sessionID);
                for (int i = 0; i < sessionSheets.length; ++i) {
                    if (sessionSheets[i] != sessionWidget) continue;
                    WindowManager.this._sessionWindows.removeWindow(sessionSheets[i]);
                    WindowManager.this.selectFrontWindow();
                    break;
                }
            }
            WindowManager.this.removeWidgetFromWindowMenu(widget);
            IWidget[] frames = WidgetUtils.getOpenNonToolWindows(WindowManager.this.getMainFrame().getDesktopContainer().getAllWidgets());
            WindowManager.this._app.getActionCollection().internalFrameOpenedOrClosed(frames.length);
            WindowManager.this.refireSessionSheetClosed(evt);
        }

        @Override
        public void widgetIconified(WidgetEvent e) {
            WindowManager.this.refireSessionSheetIconified(e);
        }

        @Override
        public void widgetDeiconified(WidgetEvent e) {
            WindowManager.this.refireSessionSheetDeiconified(e);
        }

        @Override
        public void widgetActivated(WidgetEvent e) {
            WindowManager.this.refireSessionSheetActivated(e);
        }

        @Override
        public void widgetDeactivated(WidgetEvent e) {
            WindowManager.this.refireSessionSheetDeactivated(e);
        }
    }
}

