# -*- tcl -*-
# Tcl package index file
#
# Unless this file is named pkgIndex.tcl.in, you are probably looking
# at an automatically generated/filtered copy and should probably not
# edit it.
#
# Adapted from https://core.tcl-lang.org/tcltls
if { ![package vsatisfies [package provide Tcl] 8.5-] } {
  error {Package sqlite 3.51.1 requires {Tcl 8.5-}}
}
if {[package vsatisfies [package provide Tcl] 9.0-]} {
  package ifneeded {sqlite3} {3.51.1} [list apply {{dir} {
    load [file join $dir {libtcl9sqlite3.51.1.so}] Sqlite3
  }} $dir]
} else {
  package ifneeded {sqlite3} {3.51.1} [list apply {{dir} {
    if {[string tolower [file extension {libsqlite3.51.1.so}]] in [list .dll .dylib .so]} {
      load [file join $dir {libsqlite3.51.1.so}] Sqlite3
    } else {
      load {} Sqlite3
    }
  }} $dir]
}
