/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.ColorPaintContext;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.Serializable;

public class Color
implements Paint,
Serializable {
    private static final long serialVersionUID = 118526816881161077L;
    public static final Color white;
    public static final Color WHITE;
    public static final Color lightGray;
    public static final Color LIGHT_GRAY;
    public static final Color gray;
    public static final Color GRAY;
    public static final Color darkGray;
    public static final Color DARK_GRAY;
    public static final Color black;
    public static final Color BLACK;
    public static final Color red;
    public static final Color RED;
    public static final Color pink;
    public static final Color PINK;
    public static final Color orange;
    public static final Color ORANGE;
    public static final Color yellow;
    public static final Color YELLOW;
    public static final Color green;
    public static final Color GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    public static final Color blue;
    public static final Color BLUE;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    static final int ALPHA_MASK = -16777216;
    private static final float BRIGHT_SCALE = 0.7f;
    final int value;
    private float[] frgbvalue;
    private float[] fvalue;
    private final float falpha;
    private final ColorSpace cs;
    transient ColorPaintContext context;

    public int getRed() {
        return (this.getRGB() & 0xFF0000) >> 16;
    }

    public int getGreen() {
        return (this.getRGB() & 0xFF00) >> 8;
    }

    public int getBlue() {
        return this.getRGB() & 0xFF;
    }

    public int getAlpha() {
        return (this.getRGB() & 0xFF000000) >>> 24;
    }

    public int getRGB() {
        return this.value;
    }

    public Color brighter() {
        int value = this.getRGB();
        int red = (value & 0xFF0000) >> 16;
        int green = (value & 0xFF00) >> 8;
        int blue = value & 0xFF;
        red = red < 3 ? 3 : (int)Math.min(255.0f, (float)red / 0.7f);
        green = green < 3 ? 3 : (int)Math.min(255.0f, (float)green / 0.7f);
        blue = blue < 3 ? 3 : (int)Math.min(255.0f, (float)blue / 0.7f);
        return new Color(red, green, blue, 255);
    }

    public Color darker() {
        int value = this.getRGB();
        return new Color((int)((float)((value & 0xFF0000) >> 16) * 0.7f), (int)((float)((value & 0xFF00) >> 8) * 0.7f), (int)((float)(value & 0xFF) * 0.7f), 255);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object obj) {
        boolean bl = false;
        if (obj instanceof Color && ((Color)obj).value == this.value) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + ((this.value & 0xFF0000) >> 16) + ",g=" + ((this.value & 0xFF00) >> 8) + ",b=" + (this.value & 0xFF) + ']';
    }

    public static Color decode(String str) {
        return new Color(Integer.decode(str), false);
    }

    public static Color getColor(String prop) {
        return Color.getColor(prop, null);
    }

    public static Color getColor(String prop, Color defcolor) {
        Integer val = Integer.getInteger(prop, null);
        return val == null ? defcolor : new Color(val, false);
    }

    public static Color getColor(String prop, int defrgb) {
        Color c = Color.getColor(prop, null);
        return c == null ? new Color(defrgb, false) : c;
    }

    public static int HSBtoRGB(float hue, float saturation, float brightness) {
        if (saturation == 0.0f) {
            return Color.convert(brightness, brightness, brightness, 0.0f);
        }
        if (saturation < 0.0f || saturation > 1.0f || brightness < 0.0f || brightness > 1.0f) {
            throw new IllegalArgumentException();
        }
        hue -= (float)Math.floor(hue);
        int i = (int)(6.0f * hue);
        float f = 6.0f * hue - (float)i;
        float p = brightness * (1.0f - saturation);
        float q = brightness * (1.0f - saturation * f);
        float t = brightness * (1.0f - saturation * (1.0f - f));
        switch (i) {
            case 0: {
                return Color.convert(brightness, t, p, 0.0f);
            }
            case 1: {
                return Color.convert(q, brightness, p, 0.0f);
            }
            case 2: {
                return Color.convert(p, brightness, t, 0.0f);
            }
            case 3: {
                return Color.convert(p, q, brightness, 0.0f);
            }
            case 4: {
                return Color.convert(t, p, brightness, 0.0f);
            }
            case 5: {
                return Color.convert(brightness, p, q, 0.0f);
            }
        }
        throw new InternalError("impossible");
    }

    public static float[] RGBtoHSB(int red, int green, int blue, float[] array) {
        int max;
        int min;
        if (array == null) {
            array = new float[3];
        }
        if (red < green) {
            min = red;
            max = green;
        } else {
            min = green;
            max = red;
        }
        if (blue > max) {
            max = blue;
        } else if (blue < min) {
            min = blue;
        }
        array[2] = (float)max / 255.0f;
        array[1] = max == 0 ? 0.0f : (float)(max - min) / (float)max;
        if (array[1] == 0.0f) {
            array[0] = 0.0f;
        } else {
            float delta = (max - min) * 6;
            array[0] = red == max ? (float)(green - blue) / delta : (green == max ? 0.33333334f + (float)(blue - red) / delta : 0.6666667f + (float)(red - green) / delta);
            if (array[0] < 0.0f) {
                array[0] = array[0] + 1.0f;
            }
        }
        return array;
    }

    public static Color getHSBColor(float hue, float saturation, float brightness) {
        return new Color(Color.HSBtoRGB(hue, saturation, brightness), false);
    }

    public float[] getRGBComponents(float[] array) {
        if (array == null) {
            array = new float[4];
        }
        this.getRGBColorComponents(array);
        array[3] = this.falpha == 0.0f && this.frgbvalue == null ? (float)((this.getRGB() & 0xFF000000) >> 24) / 255.0f : this.falpha;
        return array;
    }

    public float[] getRGBColorComponents(float[] array) {
        if (array == null) {
            array = new float[3];
        } else if (array == this.frgbvalue) {
            return array;
        }
        if (this.frgbvalue == null) {
            int value = this.getRGB();
            this.frgbvalue = new float[]{(float)((value & 0xFF0000) >> 16) / 255.0f, (float)((value & 0xFF00) >> 8) / 255.0f, (float)(value & 0xFF) / 255.0f};
        }
        array[0] = this.frgbvalue[0];
        array[1] = this.frgbvalue[1];
        array[2] = this.frgbvalue[2];
        return array;
    }

    public float[] getComponents(float[] array) {
        int numComponents;
        int n = numComponents = this.cs == null ? 3 : this.cs.getNumComponents();
        if (array == null) {
            array = new float[1 + numComponents];
        }
        this.getColorComponents(array);
        array[numComponents] = this.falpha == 0.0f && this.frgbvalue == null ? (float)((this.getRGB() & 0xFF000000) >> 24) / 255.0f : this.falpha;
        return array;
    }

    public float[] getColorComponents(float[] array) {
        int numComponents;
        int n = numComponents = this.cs == null ? 3 : this.cs.getNumComponents();
        if (array == null) {
            array = new float[numComponents];
        }
        if (this.fvalue == null) {
            this.fvalue = this.getRGBColorComponents(this.frgbvalue);
        }
        System.arraycopy(this.fvalue, 0, array, 0, numComponents);
        return array;
    }

    public float[] getComponents(ColorSpace space, float[] array) {
        int numComponents = space.getNumComponents();
        if (array == null) {
            array = new float[1 + numComponents];
        }
        this.getColorComponents(space, array);
        array[numComponents] = this.falpha == 0.0f && this.frgbvalue == null ? (float)((this.getRGB() & 0xFF000000) >> 24) / 255.0f : this.falpha;
        return array;
    }

    public float[] getColorComponents(ColorSpace space, float[] array) {
        float[] components = space.fromRGB(this.getRGBColorComponents(this.frgbvalue));
        if (array == null) {
            return components;
        }
        System.arraycopy(components, 0, array, 0, components.length);
        return array;
    }

    public ColorSpace getColorSpace() {
        return this.cs == null ? ColorSpace.getInstance(1000) : this.cs;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        if (this.context == null || !this.context.getColorModel().equals(cm)) {
            this.context = new ColorPaintContext(cm, this.value);
        }
        return this.context;
    }

    public int getTransparency() {
        int alpha = this.getRGB() & 0xFF000000;
        int n = 1;
        if (alpha != -16777216) {
            int n2 = 0;
            if (alpha == 0) {
                n2 = 1;
            }
            n = 3 - n2;
        }
        return n;
    }

    private static final int convert(float red, float green, float blue, float alpha) {
        if (red < 0.0f || red > 1.0f || green < 0.0f || green > 1.0f || blue < 0.0f || blue > 1.0f || alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("Bad RGB values");
        }
        int redval = Math.round(255.0f * red);
        int greenval = Math.round(255.0f * green);
        int blueval = Math.round(255.0f * blue);
        int alphaval = Math.round(255.0f * alpha);
        return alphaval << 24 | redval << 16 | greenval << 8 | blueval;
    }

    public Color(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public Color(int red, int green, int blue, int alpha) {
        if ((red & 0xFF) != red || (green & 0xFF) != green || (blue & 0xFF) != blue || (alpha & 0xFF) != alpha) {
            throw new IllegalArgumentException("Bad RGB values red=0x" + Integer.toHexString(red) + " green=0x" + Integer.toHexString(green) + " blue=0x" + Integer.toHexString(blue) + " alpha=0x" + Integer.toHexString(alpha));
        }
        this.value = alpha << 24 | red << 16 | green << 8 | blue;
        this.falpha = 1.0f;
        this.cs = null;
    }

    public Color(int value) {
        this(value, false);
    }

    public Color(int value, boolean hasalpha) {
        if (hasalpha) {
            this.falpha = (float)((value & 0xFF000000) >> 24) / 255.0f;
        } else {
            value |= 0xFF000000;
            this.falpha = 1.0f;
        }
        this.value = value;
        this.cs = null;
    }

    public Color(float red, float green, float blue) {
        this(red, green, blue, 1.0f);
    }

    public Color(float red, float green, float blue, float alpha) {
        this.value = Color.convert(red, green, blue, alpha);
        this.frgbvalue = new float[]{red, green, blue};
        this.falpha = alpha;
        this.cs = null;
    }

    public Color(ColorSpace space, float[] components, float alpha) {
        this.frgbvalue = space.toRGB(components);
        this.fvalue = components;
        this.falpha = alpha;
        this.cs = space;
        this.value = Color.convert(this.frgbvalue[0], this.frgbvalue[1], this.frgbvalue[2], alpha);
    }

    static {
        WHITE = white = new Color(0xFFFFFF, false);
        LIGHT_GRAY = lightGray = new Color(0xC0C0C0, false);
        GRAY = gray = new Color(0x808080, false);
        DARK_GRAY = darkGray = new Color(0x404040, false);
        BLACK = black = new Color(0, false);
        RED = red = new Color(0xFF0000, false);
        PINK = pink = new Color(0xFFAFAF, false);
        ORANGE = orange = new Color(16762880, false);
        YELLOW = yellow = new Color(0xFFFF00, false);
        GREEN = green = new Color(65280, false);
        MAGENTA = magenta = new Color(0xFF00FF, false);
        CYAN = cyan = new Color((char)-1, false);
        BLUE = blue = new Color(255, false);
    }
}

