# generated by RubyMine
debug_port = ENV['RUBYMINE_DEBUG_PORT']

if debug_port
  $stdout.puts "Preparing to launch debugger for #{$$}, #{debug_port}"
  $stdout.flush
  $:.push(*ENV['RUBYLIB'].split(":"))
  ENV['RUBYOPT'] = (ENV['RUBYOPT'] || '').gsub('-rrubymine_debug_anything.rb', '')

  ENV['DEBUGGER_STORED_RUBYLIB'] = ENV['RUBYLIB']
  old_opts = ENV['RUBYOPT'] || ''
  ENV['RUBYOPT'] = "-rruby-debug-ide/multiprocess/starter"
  ENV['RUBYOPT'] += " #{old_opts}" if old_opts != ''

  require 'ruby-debug-ide'
  require 'ruby-debug-ide/multiprocess'
  require 'ostruct'

  if Debugger::FRONT_END == "debase"
    Debugger.init_variables
  end

  options = OpenStruct.new(
      'frame_bind'  => false,
      'host'        => '127.0.0.1',
      'load_mode'   => false,
      'port'        => debug_port.to_i,
      'stop'        => false,
      'tracing'     => false,
      'int_handler' => true,
      'cli_debug'   => (ENV['DEBUGGER_CLI_DEBUG'] == 'true'),
      'notify_dispatcher' => true,
      'evaluation_timeout' => 10,
      'trace_to_s' => false,
      'debugger_memory_limit' => 10,
      'inspect_time_limit' => 100
  )

  Debugger::MultiProcess::do_monkey
  Debugger::MultiProcess::pre_child(options)

  if Debugger::FRONT_END == "debase"
    Debugger.setup_tracepoints
    Debugger.prepare_context
  end
end