/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger;

import b.h.la;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.GenericProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyProcessDispatcher;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.DebugGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyDebugTarget;

public class RubyDebugRunner
extends GenericProgramRunner {
    private static final Logger a;
    public static final int RUBY_DEBUG_DEFAULT_TIMEOUT = 10;
    public static final int RUBY_DEBUG_DEFAULT_TIMELIMIT = 100;
    public static final int RUBY_DEBUG_DEFAULT_MEMORYLIMIT = 0;
    public static final String ID = "RubyDebugRunner";
    private static final long g;

    @NotNull
    public String getRunnerId() {
        long l2 = g ^ 0x2992850C7879L;
        if (ID == null) {
            RubyDebugRunner.a(0);
        }
        return ID;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            RubyDebugRunner.a(1);
        }
        if (profile == null) {
            RubyDebugRunner.a(2);
        }
        if (profile instanceof WrappingRunConfiguration) {
            profile = ((WrappingRunConfiguration)profile).getPeer();
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof AbstractRubyRunConfiguration;
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        long l2 = g ^ 0x3FF851F83FE3L;
        if (state == null) {
            RubyDebugRunner.a(3);
        }
        if (environment == null) {
            RubyDebugRunner.a(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        a.debug("Initializing debugger service");
        XDebugSession xDebugSession = new RubyDebugSessionBuilder((RubyAbstractCommandLineState)state, environment).setRubyDebuggerProxy().setAcceptor().setRubyDebugTarget().connectProxy().build();
        a.debug("Debugger service initialized. Starting RubyDebugProcess");
        return xDebugSession.getRunContentDescriptor();
    }

    protected static boolean supportsCatchpointRemoval(@NotNull DebugGemHelper helper, @Nullable Sdk sdk) {
        if (helper == null) {
            RubyDebugRunner.a(5);
        }
        if (sdk == null) {
            return false;
        }
        return helper.supportsCatchpointRemoval();
    }

    protected static boolean shouldUseDebugConsole(@NotNull DebugGemHelper helper, @Nullable Sdk sdk, @NotNull RubyCommandLineData data) {
        if (helper == null) {
            RubyDebugRunner.a(6);
        }
        if (data == null) {
            RubyDebugRunner.a(7);
        }
        if (sdk == null) {
            return false;
        }
        Boolean bl2 = (Boolean)data.getUserData(RubyCommandLineData.DEBUG_CONSOLE_ALLOWED_KEY);
        if (bl2 == null || !bl2.booleanValue()) {
            return false;
        }
        return helper.debugConsoleSupported(sdk);
    }

    @NotNull
    public static RubyDebugTarget getDebugTarget(@Nullable String debuggedScript, ProcessHandler serverProcessHandler, Integer debuggerPort, RubyDebuggerProxy rubyDebuggerProxy, String localHostString) {
        Process process;
        Process process2 = process = serverProcessHandler instanceof OSProcessHandler ? ((OSProcessHandler)serverProcessHandler).getProcess() : null;
        if (process != null) {
            RubyDebugTarget rubyDebugTarget = new RubyDebugTarget(rubyDebuggerProxy, localHostString, debuggerPort, process, debuggedScript, null);
            if (rubyDebugTarget == null) {
                RubyDebugRunner.a(8);
            }
            return rubyDebugTarget;
        }
        RubyDebugTarget rubyDebugTarget = new RubyDebugTarget(rubyDebuggerProxy, localHostString, debuggerPort);
        if (rubyDebugTarget == null) {
            RubyDebugRunner.a(9);
        }
        return rubyDebugTarget;
    }

    @Nullable
    public static RubyProcessDispatcher getAcceptor(boolean supportsNonSuspendedFramesReading, String localHostString, boolean supportsCatchpointRemoval, @Nullable Integer dispatcherPort, boolean masterConnectionExpected) throws ExecutionException {
        RubyProcessDispatcher rubyProcessDispatcher;
        if (RubyDebuggerSettings.getInstance().getState().isMultiprocess() && dispatcherPort != null) {
            rubyProcessDispatcher = new RubyProcessDispatcher(localHostString, dispatcherPort, supportsNonSuspendedFramesReading, supportsCatchpointRemoval, masterConnectionExpected);
            rubyProcessDispatcher.start();
        } else {
            rubyProcessDispatcher = null;
        }
        return rubyProcessDispatcher;
    }

    public static boolean supportsNonSuspendedFramesReading(@NotNull DebugGemHelper debugGemHelper, @Nullable Sdk sdk) {
        if (debugGemHelper == null) {
            RubyDebugRunner.a(10);
        }
        if (sdk == null) {
            return false;
        }
        if (!RubyDebuggerSettings.getInstance().getState().isReadNonSuspendedFrames()) {
            return false;
        }
        return debugGemHelper.supportsNonSuspendedFramesReading(sdk);
    }

    static {
        g = la.a(5610175466806538266L, -4475802174087331175L, MethodHandles.lookup().lookupClass()).a(135633293529661L);
        a = Logger.getInstance(RubyDebugRunner.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x2016F739E50CL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugGemHelper";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugTarget";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supportsCatchpointRemoval";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseDebugConsole";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "supportsNonSuspendedFramesReading";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class RubyDebugSessionBuilder {
        protected RubyDebugTarget myRubyDebugTarget;
        protected List<VirtualFile> mySourceRoots;
        protected List<VirtualFile> myExcludedDirs;
        protected String myLocalHostString;
        protected RubyDebuggerProxy myRubyDebuggerProxy;
        protected final Integer myDebuggerPort;
        protected boolean mySupportsNonSuspendedFramesReading;
        protected boolean myEnableFileFiltering;
        @NotNull
        private final RubyAbstractCommandLineState l;
        @NotNull
        private final ExecutionEnvironment b;
        @NotNull
        private final RubyCommandLineData j;
        @NotNull
        private final ProcessHandler k;
        @NotNull
        private final Project m;
        private DebugGemHelper h;
        private SourcePositionConverter g;
        private int c;
        private Sdk i;
        private RubyProcessDispatcher f;
        private boolean a;
        private boolean e;
        private String d;
        private static final long n = la.a(7231899026674341707L, -3810917140688713280L, MethodHandles.lookup().lookupClass()).a(164673556830960L);

        public RubyDebugSessionBuilder(@NotNull RubyAbstractCommandLineState state, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            long l2 = n ^ 0x669C49A83938L;
            if (state == null) {
                RubyDebugSessionBuilder.a(0);
            }
            if (environment == null) {
                RubyDebugSessionBuilder.a(1);
            }
            this.mySupportsNonSuspendedFramesReading = false;
            this.myEnableFileFiltering = false;
            this.a = false;
            this.e = false;
            this.l = state;
            this.b = environment;
            this.m = this.l.getConfig().getProject();
            Pair<RubyCommandLineData, ProcessHandler> pair = this.l.createCommandLineAndProcessHandler();
            this.j = (RubyCommandLineData)((Object)pair.getFirst());
            this.k = (ProcessHandler)pair.getSecond();
            this.myDebuggerPort = (Integer)this.j.getUserData(RubyCommandLineData.DEBUG_PORT_KEY);
            if (this.myDebuggerPort != null) {
                this.h = (DebugGemHelper)this.j.getUserData(RubyCommandLineData.DEBUG_GEM_HELPER_KEY);
                a.assertTrue(this.h != null, (Object)"cannot create debug runner without gem helper");
                this.g = (SourcePositionConverter)this.j.getUserData(RubyCommandLineData.SOURCE_POSITION_CONVERTER_KEY);
                assert (this.g != null) : "source position converter must not be null";
                this.c = RubyDebuggerSettings.getInstance().getState().getTimeout();
                this.i = this.l.getConfig().getSdk();
                this.mySupportsNonSuspendedFramesReading = RubyDebugRunner.supportsNonSuspendedFramesReading(this.h, this.i);
                this.a = RubyDebugRunner.shouldUseDebugConsole(this.h, this.i, this.j);
                this.e = RubyDebugRunner.supportsCatchpointRemoval(this.h, this.i);
                this.mySourceRoots = this.h.getSourceRoots(this.m);
                this.myExcludedDirs = this.h.getExcludedDirs(this.m);
                this.myEnableFileFiltering = this.h.supportFileFiltering() && RubyDebuggerSettings.getInstance().getState().isStepIntoProjectOnly();
                this.myLocalHostString = NetUtils.getLocalHostString();
            }
        }

        @NotNull
        public RubyDebugSessionBuilder setRubyDebuggerProxy() {
            if (this.myDebuggerPort != null) {
                this.myRubyDebuggerProxy = new RubyDebuggerProxy(this.c, this.mySupportsNonSuspendedFramesReading, true, this.e);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.a(2);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder setAcceptor() throws ExecutionException {
            if (this.myDebuggerPort != null) {
                this.f = RubyDebugRunner.getAcceptor(this.mySupportsNonSuspendedFramesReading, this.myLocalHostString, this.e, (Integer)this.j.getCopyableUserData(RubyCommandLineData.DISPATCHER_KEY), false);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.a(3);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder setRubyDebugTarget() {
            long l2 = n ^ 0xF7AA3872A85L;
            if (this.myDebuggerPort != null) {
                String string = (String)this.j.getUserData(RubyCommandLineData.DEBUGED_SCRIPT_KEY);
                assert (string != null) : "script cannot be null";
                this.myRubyDebugTarget = RubyDebugRunner.getDebugTarget(string, this.k, this.myDebuggerPort, this.myRubyDebuggerProxy, this.myLocalHostString);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.a(4);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder connectProxy() {
            if (this.myDebuggerPort != null) {
                this.myRubyDebuggerProxy.setDebugTarget(this.myRubyDebugTarget);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.a(5);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder showTab(String sessionName) {
            this.d = sessionName;
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.a(6);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public XDebugSession build() throws ExecutionException {
            if (this.myDebuggerPort == null) {
                XDebugSession xDebugSession = RubyMotionUtil.getInstance().createMotionDebugSession((RunProfileState)this.l, this.b, this.k);
                if (xDebugSession == null) {
                    RubyDebugSessionBuilder.a(7);
                }
                return xDebugSession;
            }
            XDebugProcessStarter xDebugProcessStarter = new XDebugProcessStarter(){
                private static final long a = la.a(5811178934761532440L, -1918442751750052079L, MethodHandles.lookup().lookupClass()).a(9821395944751L);

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) {
                    if (session == null) {
                        1.a(0);
                    }
                    RubyDebugProcess rubyDebugProcess = new RubyDebugProcess(session, (RunProfileState)l, k, myRubyDebuggerProxy, c, g, b, f, h.pauseActionSupported(), a, myEnableFileFiltering, mySourceRoots, myExcludedDirs);
                    if (rubyDebugProcess == null) {
                        1.a(1);
                    }
                    return rubyDebugProcess;
                }

                private static /* synthetic */ void a(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    long l2 = a ^ 0x70E21EB0E055L;
                    switch (n2) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 3;
                            break;
                        }
                        case 1: {
                            n3 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder$1";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            if (this.d == null) {
                XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.b.getProject()).startSession(this.b, xDebugProcessStarter);
                if (xDebugSession == null) {
                    RubyDebugSessionBuilder.a(8);
                }
                return xDebugSession;
            }
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.b.getProject()).startSessionAndShowTab(this.d, null, xDebugProcessStarter);
            if (xDebugSession == null) {
                RubyDebugSessionBuilder.a(9);
            }
            return xDebugSession;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = n ^ 0x73A78BA4610L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRubyDebuggerProxy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAcceptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRubyDebugTarget";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "connectProxy";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showTab";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

