/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.rails.refactoring.rename;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Map;
import org.jetbrains.plugins.ruby.rails.model.RailsAction;
import org.jetbrains.plugins.ruby.rails.model.RailsView;
import org.jetbrains.plugins.ruby.rails.nameConventions.ViewsConventions;
import org.jetbrains.plugins.ruby.rails.refactoring.rename.RenameByRailsViewFileProcessor;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.rename.RenameProcessor;

public class RenameByRailsActionProcessor
extends RenameProcessor {
    @Override
    public boolean canProcessElement(PsiElement element) {
        return element instanceof RMethod && RailsAction.fromMethod((RMethod)element) != null;
    }

    @Override
    public void prepareRenaming(PsiElement element, String newName, Map<PsiElement, String> allRenames) {
        RailsAction railsAction = RailsAction.fromMethod((RMethod)element);
        assert (railsAction != null);
        String string = railsAction.getName();
        List<RailsView> list2 = railsAction.getViews();
        String string2 = null;
        RailsView railsView = null;
        for (RailsView railsView2 : list2) {
            PsiFile psiFile = railsView2.getPsiFile();
            assert (psiFile != null);
            if (allRenames.containsKey(psiFile)) continue;
            String string3 = ViewsConventions.getViewOrLayoutNameByFileName(FileUtil.getNameWithoutExtension((String)newName));
            String string4 = RenameByRailsActionProcessor.getNewViewNameBy(string3, string, psiFile);
            if (string2 == null && railsView == null) {
                string2 = string4;
                railsView = railsView2;
            }
            if (psiFile.getVirtualFile().getParent().findChild(newName) != null) continue;
            allRenames.put((PsiElement)psiFile, string4);
        }
        if (string2 != null && railsView != null) {
            RenameByRailsViewFileProcessor.addElementsToRenameByView(railsView, string2, allRenames);
        }
    }

    public static String getNewViewNameBy(String newActionName, String currentActionName, PsiFile viewFile) {
        return viewFile.getName().replace(currentActionName, newActionName);
    }
}

