/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.modules;

import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.modules.TypeScriptSimpleModuleReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class TypeScriptFileModuleReference
extends TypeScriptSimpleModuleReference {
    @NotNull
    private final JSModuleBaseReference.ModuleTypes myModuleType;

    public TypeScriptFileModuleReference(String text, int i, TextRange textRange, FileReferenceSet refSet, @NotNull JSModuleBaseReference.ModuleTypes moduleType) {
        if (moduleType == null) {
            TypeScriptFileModuleReference.$$$reportNull$$$0(0);
        }
        super(text, i, textRange, refSet);
        this.myModuleType = moduleType;
    }

    @Override
    protected void processResolveInContext(@NotNull String referenceText, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        if (referenceText == null) {
            TypeScriptFileModuleReference.$$$reportNull$$$0(1);
        }
        if (context == null) {
            TypeScriptFileModuleReference.$$$reportNull$$$0(2);
        }
        super.processResolveInContext(referenceText, context, results, caseSensitive);
        this.innerResolveAdditionalRoots(referenceText, context, results, caseSensitive);
    }

    private void innerResolveAdditionalRoots(@NotNull String s, @NotNull PsiFileSystemItem context, Collection<ResolveResult> results, boolean caseSensitive) {
        FileReferenceSet set;
        String requiredModuleName;
        boolean isRelative;
        boolean startsWithDot;
        if (s == null) {
            TypeScriptFileModuleReference.$$$reportNull$$$0(3);
        }
        if (context == null) {
            TypeScriptFileModuleReference.$$$reportNull$$$0(4);
        }
        if (!(startsWithDot = this.getText().startsWith(".")) && context.isDirectory() && (isRelative = (requiredModuleName = (set = this.getFileReferenceSet()).getPathString()).startsWith("."))) {
            Collection<PsiFileSystemItem> dirs;
            PsiElement element = set.getElement();
            Collection<TypeScriptConfig> configs = TypeScriptConfigService.Provider.getConfigFiles(element.getProject());
            if (configs.isEmpty() || !TypeScriptFileModuleReference.configsIncludeRootDirs(configs)) {
                return;
            }
            TypeScriptConfig config2 = TypeScriptConfigUtil.getConfigForPsiFile(element.getContainingFile().getOriginalFile());
            if (config2 != null && (dirs = config2.getRootDirs()).contains(context)) {
                for (PsiFileSystemItem dir : dirs) {
                    if (dir == context) continue;
                    super.processResolveInContext(s, dir, results, caseSensitive);
                }
            }
        }
    }

    private static boolean configsIncludeRootDirs(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            TypeScriptFileModuleReference.$$$reportNull$$$0(5);
        }
        return configs.stream().anyMatch(el -> !el.getRootDirs().isEmpty());
    }

    @Override
    public int getWeight() {
        return this.myModuleType.weight();
    }

    @Override
    protected NodeModuleDirectorySearchProcessor getNodeModuleSearchProcessor() {
        return new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(this.getElement().getProject());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configs";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/modules/TypeScriptFileModuleReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processResolveInContext";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "innerResolveAdditionalRoots";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "configsIncludeRootDirs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

