/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.inspections.ES6ConvertModuleExportToExportQuickFix;
import com.intellij.lang.javascript.inspections.ES6ConvertRequireIntoImportInspection;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.intentions.ES6CoolRefactoring;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertModuleExportToExportInspection
extends JSInspection
implements ES6CoolRefactoring {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final ProblemsHolder holder, LocalInspectionToolSession session) {
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression assignment) {
                if (assignment == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ES6CoolRefactoring.isEs6Compatible((PsiElement)assignment)) {
                    return;
                }
                List nameParts = ES6ConvertModuleExportToExportInspection.checkAssignmentGetDefinitionReference(assignment);
                if (nameParts == null) {
                    return;
                }
                List exportedNameParts = ES6ConvertModuleExportToExportInspection.isExport(nameParts, false);
                if (exportedNameParts == null) {
                    return;
                }
                String exportedName = exportedNameParts.isEmpty() ? null : (String)exportedNameParts.get(0);
                boolean onlyHighlight = "exports".equals(nameParts.get(0)) && exportedNameParts.isEmpty() || exportedNameParts.size() > 1 || !exportedNameParts.isEmpty() && ("prototype".equals(exportedName) || "constructor".equals(exportedName) || exportedName != null && exportedName.startsWith("["));
                JSExpression expression = assignment.getDefinitionExpression().getExpression();
                assert (expression != null);
                if (onlyHighlight) {
                    holder.registerProblem((PsiElement)expression, JSBundle.message((String)"js.convert.module.exports.into.es6.export.inspection.text", (Object[])new Object[0]), new LocalQuickFix[0]);
                } else {
                    holder.registerProblem((PsiElement)expression, JSBundle.message((String)"js.convert.module.exports.into.es6.export.inspection.text", (Object[])new Object[0]), new LocalQuickFix[]{new ES6ConvertModuleExportToExportQuickFix(assignment, exportedName)});
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assignment", "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection$1", "visitJSAssignmentExpression"));
            }
        };
        if (jSElementVisitor == null) {
            ES6ConvertModuleExportToExportInspection.$$$reportNull$$$0(0);
        }
        return jSElementVisitor;
    }

    static boolean checkContext(@NotNull JSAssignmentExpression assignment) {
        if (assignment == null) {
            ES6ConvertModuleExportToExportInspection.$$$reportNull$$$0(1);
        }
        if (!ES6ConvertRequireIntoImportInspection.checkElementIsOnTopLevel((JSElement)assignment)) {
            return false;
        }
        PsiElement parent = assignment.getParent();
        return parent instanceof JSSourceElement || parent instanceof JSCommaExpression;
    }

    private static List<String> checkAssignmentGetDefinitionReference(@NotNull JSAssignmentExpression assignment) {
        if (assignment == null) {
            ES6ConvertModuleExportToExportInspection.$$$reportNull$$$0(2);
        }
        if (assignment.getOperationSign() != JSTokenTypes.EQ) {
            return null;
        }
        JSDefinitionExpression definition = assignment.getDefinitionExpression();
        if (definition == null || definition.getInitializerOrStub() == null || definition.getExpression() == null) {
            return null;
        }
        if (!ES6ConvertModuleExportToExportInspection.checkContext(assignment)) {
            return null;
        }
        return JSSymbolUtil.getReferenceParts(definition.getExpression());
    }

    @Nullable
    static List<String> checkAssignmentToBeExport(@NotNull JSAssignmentExpression assignment) {
        List<String> nameParts;
        if (assignment == null) {
            ES6ConvertModuleExportToExportInspection.$$$reportNull$$$0(3);
        }
        if ((nameParts = ES6ConvertModuleExportToExportInspection.checkAssignmentGetDefinitionReference(assignment)) == null) {
            return null;
        }
        return ES6ConvertModuleExportToExportInspection.isExport(nameParts, true);
    }

    @Nullable
    private static List<String> isExport(@NotNull List<String> nameParts, boolean ignoreShortDefaultExport) {
        if (nameParts == null) {
            ES6ConvertModuleExportToExportInspection.$$$reportNull$$$0(4);
        }
        if ("exports".equals(nameParts.get(0))) {
            return ignoreShortDefaultExport && nameParts.size() == 1 ? null : nameParts.subList(1, nameParts.size());
        }
        if ("module".equals(nameParts.get(0)) && nameParts.size() > 1 && "exports".equals(nameParts.get(1))) {
            return nameParts.subList(2, nameParts.size());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/ES6ConvertModuleExportToExportInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignmentGetDefinitionReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkAssignmentToBeExport";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isExport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

