/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.dekaf.jdbc;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.exceptions.DBFetchingException;
import org.jetbrains.dekaf.exceptions.DBPreparingException;
import org.jetbrains.dekaf.jdbc.JdbcValueGetter;
import org.jetbrains.dekaf.util.Numbers;

public final class JdbcValueGetters {
    @NotNull
    private static final Map<Class<?>, JdbcValueGetter<?>> NORMAL_GETTERS = new HashMap(30);
    @NotNull
    private static final Map<SpecificKey, JdbcValueGetter<?>> SPECIFIC_GETTERS;

    @NotNull
    static <W> JdbcValueGetter<W> of(int jdbcType, @NotNull Class<W> clazz) {
        JdbcValueGetter<W> getter = JdbcValueGetters.find(jdbcType, clazz);
        if (getter != null) {
            return getter;
        }
        String message = String.format("Unknown how to get a value of class %s for jdbc type %d", clazz.getSimpleName(), jdbcType);
        throw new DBPreparingException(message, (String)null);
    }

    @Nullable
    static <W> JdbcValueGetter<W> find(int jdbcType, @NotNull Class<W> clazz) {
        JdbcValueGetter<Object> getter = null;
        if (jdbcType != 1111) {
            getter = SPECIFIC_GETTERS.get(new SpecificKey(jdbcType, clazz));
        }
        if (getter == null) {
            getter = NORMAL_GETTERS.get(clazz);
        }
        if (getter == null && clazz.isArray()) {
            getter = JdbcValueGetters.lookForArrayGetter(clazz);
        }
        return getter;
    }

    @Nullable
    protected static <W> JdbcValueGetter<W> lookForArrayGetter(@NotNull Class<W> clazz) {
        return new ArrayGetter<W>(clazz);
    }

    @NotNull
    private static Class<?> getArrayComponentClass(@NotNull Class<?> arrayClass) {
        Class<?> c = arrayClass;
        while (c.isArray()) {
            c = c.getComponentType();
        }
        return c;
    }

    static {
        NORMAL_GETTERS.put(Boolean.TYPE, IntBoolGetter.INSTANCE);
        NORMAL_GETTERS.put(Boolean.class, IntBoolGetter.INSTANCE);
        NORMAL_GETTERS.put(Byte.TYPE, ByteGetter.INSTANCE);
        NORMAL_GETTERS.put(Byte.class, ByteGetter.INSTANCE);
        NORMAL_GETTERS.put(Short.TYPE, ShortGetter.INSTANCE);
        NORMAL_GETTERS.put(Short.class, ShortGetter.INSTANCE);
        NORMAL_GETTERS.put(Integer.TYPE, IntGetter.INSTANCE);
        NORMAL_GETTERS.put(Integer.class, IntGetter.INSTANCE);
        NORMAL_GETTERS.put(Long.TYPE, LongGetter.INSTANCE);
        NORMAL_GETTERS.put(Long.class, LongGetter.INSTANCE);
        NORMAL_GETTERS.put(Float.TYPE, FloatGetter.INSTANCE);
        NORMAL_GETTERS.put(Float.class, FloatGetter.INSTANCE);
        NORMAL_GETTERS.put(Double.TYPE, DoubleGetter.INSTANCE);
        NORMAL_GETTERS.put(Double.class, DoubleGetter.INSTANCE);
        NORMAL_GETTERS.put(BigInteger.class, BigIntegerGetter.INSTANCE);
        NORMAL_GETTERS.put(BigDecimal.class, BigDecimalGetter.INSTANCE);
        NORMAL_GETTERS.put(Number.class, GenericNumberGetter.INSTANCE);
        NORMAL_GETTERS.put(String.class, StringGetter.INSTANCE);
        NORMAL_GETTERS.put(Character.TYPE, CharGetter.INSTANCE);
        NORMAL_GETTERS.put(Character.class, CharGetter.INSTANCE);
        NORMAL_GETTERS.put(java.util.Date.class, JavaDateGetter.INSTANCE);
        NORMAL_GETTERS.put(Date.class, DateGetter.INSTANCE);
        NORMAL_GETTERS.put(Timestamp.class, TimestampGetter.INSTANCE);
        NORMAL_GETTERS.put(Time.class, TimeGetter.INSTANCE);
        NORMAL_GETTERS.put(Object.class, ObjectGetter.INSTANCE);
        NORMAL_GETTERS.put(byte[].class, ArrayOfByteGetter.INSTANCE);
        NORMAL_GETTERS.put(short[].class, ArrayOfShortGetter.INSTANCE);
        NORMAL_GETTERS.put(int[].class, ArrayOfIntGetter.INSTANCE);
        NORMAL_GETTERS.put(long[].class, ArrayOfLongGetter.INSTANCE);
        NORMAL_GETTERS.put(Number[].class, ArrayOfNumberGetter.INSTANCE);
        NORMAL_GETTERS.put(String[].class, ArrayOfStringGetter.INSTANCE);
        SPECIFIC_GETTERS = new HashMap(30);
        SPECIFIC_GETTERS.put(new SpecificKey(16, Boolean.TYPE), BoolBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(16, Boolean.class), BoolBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(16, Object.class), BoolBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(16, Byte.TYPE), BoolByteGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(16, Byte.class), BoolByteGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(16, Short.TYPE), BoolShortGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(16, Short.class), BoolShortGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(16, Integer.TYPE), BoolIntGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(16, Integer.class), BoolIntGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(16, Number.class), BoolByteGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-7, Boolean.TYPE), BoolBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-7, Boolean.class), BoolBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-7, Byte.TYPE), BoolByteGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-7, Byte.class), BoolByteGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-7, Short.TYPE), BoolShortGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-7, Short.class), BoolShortGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-7, Integer.TYPE), BoolIntGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-7, Integer.class), BoolIntGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-7, Number.class), BoolByteGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-7, Object.class), BoolByteGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-6, Boolean.TYPE), IntBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-6, Boolean.class), IntBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-6, Number.class), ByteGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-6, Object.class), ByteGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(5, Boolean.TYPE), IntBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(5, Boolean.class), IntBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(5, Number.class), ShortGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(5, Object.class), ShortGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(4, Boolean.TYPE), IntBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(4, Boolean.class), IntBoolGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(4, Number.class), IntGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-5, Number.class), LongGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-5, Object.class), LongGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(7, Number.class), FloatGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(7, Object.class), FloatGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(6, Number.class), DoubleGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(6, Object.class), DoubleGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(8, Number.class), DoubleGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(8, Object.class), DoubleGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(3, Number.class), BigDecimalGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(3, Object.class), BigDecimalGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-2, byte[].class), BinaryGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-2, Object.class), BinaryGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-3, byte[].class), BinaryGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-3, Object.class), BinaryGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-4, byte[].class), BinaryGetter.INSTANCE);
        SPECIFIC_GETTERS.put(new SpecificKey(-4, Object.class), BinaryGetter.INSTANCE);
    }

    static final class DumbNullGetter
    extends JdbcValueGetter<Object> {
        static final DumbNullGetter INSTANCE = new DumbNullGetter();

        DumbNullGetter() {
        }

        @Override
        @Nullable
        Object getValue(@NotNull ResultSet rset, int index) {
            return null;
        }
    }

    static final class ArrayOfStringGetter
    extends AbstractArrayGetter<String[]> {
        static final ArrayOfStringGetter INSTANCE = new ArrayOfStringGetter();

        ArrayOfStringGetter() {
        }

        @Override
        protected String[] convertArray(java.sql.Array array) throws SQLException {
            Object arr = array.getArray();
            if (arr instanceof String[]) {
                return (String[])arr;
            }
            if (arr instanceof Object[]) {
                Object[] objects = (Object[])arr;
                int n = objects.length;
                String[] result = new String[n];
                for (int i = 0; i < n; ++i) {
                    Object object = objects[i];
                    result[i] = object != null ? object.toString() : null;
                }
                return result;
            }
            throw new DBFetchingException("Unknown how to convert " + arr.getClass().getSimpleName() + " to String[]", null);
        }
    }

    static final class ArrayOfNumberGetter
    extends AbstractArrayGetter<Number[]> {
        static final ArrayOfNumberGetter INSTANCE = new ArrayOfNumberGetter();

        ArrayOfNumberGetter() {
        }

        @Override
        protected Number[] convertArray(java.sql.Array array) throws SQLException {
            Object arr = array.getArray();
            if (arr instanceof Number[]) {
                return (Number[])arr;
            }
            throw new DBFetchingException("Unknown how to convert " + arr.getClass().getSimpleName() + " to Number[]", null);
        }
    }

    static final class ArrayOfLongGetter
    extends AbstractArrayGetter<long[]> {
        static final ArrayOfLongGetter INSTANCE = new ArrayOfLongGetter();

        ArrayOfLongGetter() {
        }

        @Override
        protected long[] convertArray(java.sql.Array array) throws SQLException {
            Object arr = array.getArray();
            if (arr instanceof long[]) {
                return (long[])arr;
            }
            if (arr instanceof Number[]) {
                Number[] arrN = (Number[])arr;
                int n = arrN.length;
                long[] result = new long[n];
                for (int i = 0; i < n; ++i) {
                    Number v = arrN[i];
                    result[i] = v != null ? v.longValue() : 0L;
                }
                return result;
            }
            throw new DBFetchingException("Unknown how to convert " + arr.getClass().getSimpleName() + " to long[]", null);
        }
    }

    static final class ArrayOfIntGetter
    extends AbstractArrayGetter<int[]> {
        static final ArrayOfIntGetter INSTANCE = new ArrayOfIntGetter();

        ArrayOfIntGetter() {
        }

        @Override
        protected int[] convertArray(java.sql.Array array) throws SQLException {
            Object arr = array.getArray();
            if (arr instanceof int[]) {
                return (int[])arr;
            }
            if (arr instanceof Number[]) {
                Number[] arrN = (Number[])arr;
                int n = arrN.length;
                int[] result = new int[n];
                for (int i = 0; i < n; ++i) {
                    Number v = arrN[i];
                    result[i] = v != null ? v.intValue() : 0;
                }
                return result;
            }
            throw new DBFetchingException("Unknown how to convert " + arr.getClass().getSimpleName() + " to int[]", null);
        }
    }

    static final class ArrayOfShortGetter
    extends AbstractArrayGetter<short[]> {
        static final ArrayOfShortGetter INSTANCE = new ArrayOfShortGetter();

        ArrayOfShortGetter() {
        }

        @Override
        protected short[] convertArray(java.sql.Array array) throws SQLException {
            Object arr = array.getArray();
            if (arr instanceof short[]) {
                return (short[])arr;
            }
            if (arr instanceof Number[]) {
                Number[] arrN = (Number[])arr;
                int n = arrN.length;
                short[] result = new short[n];
                for (int i = 0; i < n; ++i) {
                    Number v = arrN[i];
                    result[i] = v != null ? v.shortValue() : (short)0;
                }
                return result;
            }
            throw new DBFetchingException("Unknown how to convert " + arr.getClass().getSimpleName() + " to short[]", null);
        }
    }

    static final class ArrayOfByteGetter
    extends AbstractArrayGetter<byte[]> {
        static final ArrayOfByteGetter INSTANCE = new ArrayOfByteGetter();

        ArrayOfByteGetter() {
        }

        @Override
        protected byte[] convertArray(java.sql.Array array) throws SQLException {
            Object arr = array.getArray();
            if (arr instanceof byte[]) {
                return (byte[])arr;
            }
            if (arr instanceof Number[]) {
                Number[] arrN = (Number[])arr;
                int n = arrN.length;
                byte[] result = new byte[n];
                for (int i = 0; i < n; ++i) {
                    Number v = arrN[i];
                    result[i] = v != null ? v.byteValue() : (byte)0;
                }
                return result;
            }
            throw new DBFetchingException("Unknown how to convert " + arr.getClass().getSimpleName() + " to byte[]", null);
        }
    }

    static final class ArrayGetter<A>
    extends AbstractArrayGetter<A> {
        private final Class<A> arrayClass;

        ArrayGetter(Class<A> arrayClass) {
            this.arrayClass = arrayClass;
        }

        @Override
        protected A convertArray(java.sql.Array array) throws SQLException {
            Object result;
            Object gotArray = array.getArray();
            try {
                result = this.arrayClass.isAssignableFrom(gotArray.getClass()) ? gotArray : ArrayGetter.copySlice(this.arrayClass, gotArray);
            }
            catch (Exception e) {
                String msg = String.format("Failed to fetch an array value. Required type: %s, actual type: %s. Encountered exception class %s with message %s.", this.arrayClass.getCanonicalName(), gotArray.getClass().getCanonicalName(), e.getClass().getSimpleName(), e.getMessage());
                throw new DBFetchingException(msg, e, null);
            }
            return (A)result;
        }

        private static Object copySlice(Class<?> sliceClass, Object sliceSource) {
            Class<?> componentType = sliceClass.getComponentType();
            int n = Array.getLength(sliceSource);
            Object result = Array.newInstance(sliceClass.getComponentType(), n);
            if (n == 0) {
                return result;
            }
            for (int i = 0; i < n; ++i) {
                Object component;
                Object x = Array.get(sliceSource, i);
                if (x == null) continue;
                Class<?> xClass = x.getClass();
                if (componentType.isAssignableFrom(xClass)) {
                    component = x;
                } else if (componentType == String.class) {
                    component = x.toString();
                } else if (componentType.isArray()) {
                    component = ArrayGetter.copySlice(componentType, x);
                } else if ((componentType.isPrimitive() || Number.class.isAssignableFrom(componentType)) && Number.class.isAssignableFrom(xClass)) {
                    component = Numbers.convertNumber(componentType, (Number)x);
                } else {
                    String message = String.format("Array value fetching problem: unknown how to convert value (%s) of type %s to %s.", x.toString(), xClass.getCanonicalName(), componentType.getCanonicalName());
                    throw new IllegalStateException(message);
                }
                Array.set(result, i, component);
            }
            return result;
        }
    }

    static abstract class AbstractArrayGetter<A>
    extends JdbcValueGetter<A> {
        AbstractArrayGetter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        A getValue(@NotNull ResultSet rset, int index) throws SQLException {
            java.sql.Array array = rset.getArray(index);
            if (array == null) {
                return null;
            }
            try {
                if (rset.wasNull()) {
                    A a = null;
                    return a;
                }
                A a = this.convertArray(array);
                return a;
            }
            finally {
                array.free();
            }
        }

        protected abstract A convertArray(java.sql.Array var1) throws SQLException;
    }

    static final class ObjectGetter
    extends JdbcValueGetter<Object> {
        static final ObjectGetter INSTANCE = new ObjectGetter();

        ObjectGetter() {
        }

        @Override
        @Nullable
        Object getValue(@NotNull ResultSet rset, int index) throws SQLException {
            return rset.getObject(index);
        }
    }

    static final class TimeGetter
    extends JdbcValueGetter<Time> {
        static final TimeGetter INSTANCE = new TimeGetter();

        TimeGetter() {
        }

        @Override
        @Nullable
        Time getValue(@NotNull ResultSet rset, int index) throws SQLException {
            Time time = rset.getTime(index);
            return time != null ? new Time(time.getTime()) : null;
        }
    }

    static final class TimestampGetter
    extends JdbcValueGetter<Timestamp> {
        static final TimestampGetter INSTANCE = new TimestampGetter();

        TimestampGetter() {
        }

        @Override
        @Nullable
        Timestamp getValue(@NotNull ResultSet rset, int index) throws SQLException {
            Timestamp timestamp = rset.getTimestamp(index);
            return timestamp != null ? new Timestamp(timestamp.getTime()) : null;
        }
    }

    static final class DateGetter
    extends JdbcValueGetter<Date> {
        static final DateGetter INSTANCE = new DateGetter();

        DateGetter() {
        }

        @Override
        @Nullable
        Date getValue(@NotNull ResultSet rset, int index) throws SQLException {
            Date date = rset.getDate(index);
            return date != null ? new Date(date.getTime()) : null;
        }
    }

    static final class JavaDateGetter
    extends JdbcValueGetter<java.util.Date> {
        static final JavaDateGetter INSTANCE = new JavaDateGetter();

        JavaDateGetter() {
        }

        @Override
        @Nullable
        java.util.Date getValue(@NotNull ResultSet rset, int index) throws SQLException {
            Timestamp timestamp = rset.getTimestamp(index);
            return timestamp != null ? new java.util.Date(timestamp.getTime()) : null;
        }
    }

    static final class CharGetter
    extends JdbcValueGetter<Character> {
        static final CharGetter INSTANCE = new CharGetter();

        CharGetter() {
        }

        @Override
        @Nullable
        Character getValue(@NotNull ResultSet rset, int index) throws SQLException {
            String str = rset.getString(index);
            if (rset.wasNull() || str == null || str.length() == 0) {
                return null;
            }
            return Character.valueOf(str.charAt(0));
        }
    }

    static final class StringGetter
    extends JdbcValueGetter<String> {
        static final StringGetter INSTANCE = new StringGetter();

        StringGetter() {
        }

        @Override
        @Nullable
        String getValue(@NotNull ResultSet rset, int index) throws SQLException {
            return rset.getString(index);
        }
    }

    static final class BinaryGetter
    extends JdbcValueGetter<byte[]> {
        static final BinaryGetter INSTANCE = new BinaryGetter();

        BinaryGetter() {
        }

        @Override
        @Nullable
        byte[] getValue(@NotNull ResultSet rset, int index) throws SQLException {
            byte[] binaryValue = rset.getBytes(index);
            return rset.wasNull() ? null : binaryValue;
        }
    }

    static final class GenericNumberGetter
    extends JdbcValueGetter<Number> {
        static final GenericNumberGetter INSTANCE = new GenericNumberGetter();

        GenericNumberGetter() {
        }

        @Override
        @Nullable
        Number getValue(@NotNull ResultSet rset, int index) throws SQLException {
            return Numbers.convertNumberSmartly(rset.getBigDecimal(index));
        }
    }

    static final class BigDecimalGetter
    extends JdbcValueGetter<BigDecimal> {
        static final BigDecimalGetter INSTANCE = new BigDecimalGetter();

        BigDecimalGetter() {
        }

        @Override
        @Nullable
        BigDecimal getValue(@NotNull ResultSet rset, int index) throws SQLException {
            return rset.getBigDecimal(index);
        }
    }

    static final class BigIntegerGetter
    extends JdbcValueGetter<BigInteger> {
        static final BigDecimalGetter INSTANCE = new BigDecimalGetter();

        BigIntegerGetter() {
        }

        @Override
        @Nullable
        BigInteger getValue(@NotNull ResultSet rset, int index) throws SQLException {
            BigDecimal bd = rset.getBigDecimal(index);
            if (rset.wasNull()) {
                return null;
            }
            return bd.toBigInteger();
        }
    }

    static final class DoubleGetter
    extends JdbcValueGetter<Double> {
        static final DoubleGetter INSTANCE = new DoubleGetter();

        DoubleGetter() {
        }

        @Override
        @Nullable
        Double getValue(@NotNull ResultSet rset, int index) throws SQLException {
            double value = rset.getDouble(index);
            return rset.wasNull() ? null : Double.valueOf(value);
        }
    }

    static final class FloatGetter
    extends JdbcValueGetter<Float> {
        static final FloatGetter INSTANCE = new FloatGetter();

        FloatGetter() {
        }

        @Override
        @Nullable
        Float getValue(@NotNull ResultSet rset, int index) throws SQLException {
            float value = rset.getFloat(index);
            return rset.wasNull() ? null : Float.valueOf(value);
        }
    }

    static final class LongGetter
    extends JdbcValueGetter<Long> {
        static final LongGetter INSTANCE = new LongGetter();

        LongGetter() {
        }

        @Override
        @Nullable
        Long getValue(@NotNull ResultSet rset, int index) throws SQLException {
            long value = rset.getLong(index);
            return rset.wasNull() ? null : Long.valueOf(value);
        }
    }

    static final class IntGetter
    extends JdbcValueGetter<Integer> {
        static final IntGetter INSTANCE = new IntGetter();

        IntGetter() {
        }

        @Override
        @Nullable
        Integer getValue(@NotNull ResultSet rset, int index) throws SQLException {
            int value = rset.getInt(index);
            return rset.wasNull() ? null : Integer.valueOf(value);
        }
    }

    static final class ShortGetter
    extends JdbcValueGetter<Short> {
        static final ShortGetter INSTANCE = new ShortGetter();

        ShortGetter() {
        }

        @Override
        @Nullable
        Short getValue(@NotNull ResultSet rset, int index) throws SQLException {
            short value = rset.getShort(index);
            return rset.wasNull() ? null : Short.valueOf(value);
        }
    }

    static final class ByteGetter
    extends JdbcValueGetter<Byte> {
        static final ByteGetter INSTANCE = new ByteGetter();

        ByteGetter() {
        }

        @Override
        @Nullable
        Byte getValue(@NotNull ResultSet rset, int index) throws SQLException {
            byte value = rset.getByte(index);
            return rset.wasNull() ? null : Byte.valueOf(value);
        }
    }

    static final class IntBoolGetter
    extends JdbcValueGetter<Boolean> {
        static final IntBoolGetter INSTANCE = new IntBoolGetter();

        IntBoolGetter() {
        }

        @Override
        @Nullable
        Boolean getValue(@NotNull ResultSet rset, int index) throws SQLException {
            int value = rset.getInt(index);
            return rset.wasNull() ? null : Boolean.valueOf(value > 0);
        }
    }

    static final class BoolIntGetter
    extends JdbcValueGetter<Integer> {
        private static final Integer _1_ = 1;
        private static final Integer _0_ = 0;
        static final BoolIntGetter INSTANCE = new BoolIntGetter();

        BoolIntGetter() {
        }

        @Override
        @Nullable
        Integer getValue(@NotNull ResultSet rset, int index) throws SQLException {
            boolean value = rset.getBoolean(index);
            return rset.wasNull() ? null : (value ? _1_ : _0_);
        }
    }

    static final class BoolShortGetter
    extends JdbcValueGetter<Short> {
        private static final Short _1_ = 1;
        private static final Short _0_ = 0;
        static final BoolShortGetter INSTANCE = new BoolShortGetter();

        BoolShortGetter() {
        }

        @Override
        @Nullable
        Short getValue(@NotNull ResultSet rset, int index) throws SQLException {
            boolean value = rset.getBoolean(index);
            return rset.wasNull() ? null : (value ? _1_ : _0_);
        }
    }

    static final class BoolByteGetter
    extends JdbcValueGetter<Byte> {
        private static final Byte _1_ = 1;
        private static final Byte _0_ = 0;
        static final BoolByteGetter INSTANCE = new BoolByteGetter();

        BoolByteGetter() {
        }

        @Override
        @Nullable
        Byte getValue(@NotNull ResultSet rset, int index) throws SQLException {
            boolean value = rset.getBoolean(index);
            return rset.wasNull() ? null : (value ? _1_ : _0_);
        }
    }

    static final class BoolBoolGetter
    extends JdbcValueGetter<Boolean> {
        static final BoolBoolGetter INSTANCE = new BoolBoolGetter();

        BoolBoolGetter() {
        }

        @Override
        @Nullable
        Boolean getValue(@NotNull ResultSet rset, int index) throws SQLException {
            boolean value = rset.getBoolean(index);
            return rset.wasNull() ? null : Boolean.valueOf(value);
        }
    }

    protected static final class SpecificKey {
        final int jdbcType;
        @NotNull
        final Class<?> desiredClass;

        SpecificKey(int jdbcType, @NotNull Class<?> desiredClass) {
            this.jdbcType = jdbcType;
            this.desiredClass = desiredClass;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SpecificKey that = (SpecificKey)o;
            return this.jdbcType == that.jdbcType && this.desiredClass == that.desiredClass;
        }

        public int hashCode() {
            return Math.abs(this.jdbcType) * 17 + this.desiredClass.hashCode();
        }
    }
}

